/*
 * Decompiled with CFR 0.152.
 */
package uk.org.okapibarcode.backend;

import uk.org.okapibarcode.backend.HumanReadableLocation;
import uk.org.okapibarcode.backend.OkapiInputException;
import uk.org.okapibarcode.backend.Symbol;
import uk.org.okapibarcode.graphics.Rectangle;

public class Pharmacode2Track
extends Symbol {
    public Pharmacode2Track() {
        this.humanReadableLocation = HumanReadableLocation.NONE;
    }

    @Override
    protected void encode() {
        if (this.content.length() > 8) {
            throw OkapiInputException.inputTooLong();
        }
        if (!this.content.matches("[0-9]+")) {
            throw OkapiInputException.invalidCharactersInInput();
        }
        int tester = Integer.parseInt(this.content);
        if (tester < 4 || tester > 64570080) {
            throw new OkapiInputException("Data out of range");
        }
        StringBuilder dest = new StringBuilder();
        do {
            switch (tester % 3) {
                case 0: {
                    dest.append('F');
                    tester = (tester - 3) / 3;
                    break;
                }
                case 1: {
                    dest.append('D');
                    tester = (tester - 1) / 3;
                    break;
                }
                case 2: {
                    dest.append('A');
                    tester = (tester - 2) / 3;
                }
            }
        } while (tester != 0);
        dest.reverse();
        this.infoLine("Encoding: " + dest);
        this.readable = "";
        this.pattern = new String[]{dest.toString()};
        this.row_count = 1;
        this.row_height = new int[]{-1};
    }

    @Override
    protected void plotSymbol() {
        int x = 0;
        int w = this.moduleWidth;
        int y = 0;
        int h = 0;
        this.resetPlotElements();
        for (int xBlock = 0; xBlock < this.pattern[0].length(); ++xBlock) {
            switch (this.pattern[0].charAt(xBlock)) {
                case 'A': {
                    y = 0;
                    h = this.default_height / 2;
                    break;
                }
                case 'D': {
                    y = this.default_height / 2;
                    h = this.default_height / 2;
                    break;
                }
                case 'F': {
                    y = 0;
                    h = this.default_height;
                }
            }
            Rectangle rect = new Rectangle(x, y, w, h);
            this.rectangles.add(rect);
            x += 2 * w;
        }
        this.symbol_width = this.pattern[0].length() * 2 * w;
        this.symbol_height = this.default_height;
    }
}

