/*
 * Decompiled with CFR 0.152.
 */
package uk.org.okapibarcode.backend;

import uk.org.okapibarcode.backend.OkapiInputException;
import uk.org.okapibarcode.backend.OkapiInternalException;
import uk.org.okapibarcode.backend.Symbol;

public class MsiPlessey
extends Symbol {
    private static final String[] MSI_PLESS_TABLE = new String[]{"12121212", "12121221", "12122112", "12122121", "12211212", "12211221", "12212112", "12212121", "21121212", "21121221"};
    private CheckDigit checkDigit = CheckDigit.NONE;
    private boolean checkDigitInHumanReadableText = true;
    private double moduleWidthRatio = 2.0;

    public void setCheckDigit(CheckDigit checkDigit) {
        this.checkDigit = checkDigit;
    }

    public CheckDigit getCheckDigit() {
        return this.checkDigit;
    }

    public void setCheckDigitInHumanReadableText(boolean checkDigitInHumanReadableText) {
        this.checkDigitInHumanReadableText = checkDigitInHumanReadableText;
    }

    public boolean getCheckDigitInHumanReadableText() {
        return this.checkDigitInHumanReadableText;
    }

    public void setModuleWidthRatio(double moduleWidthRatio) {
        this.moduleWidthRatio = moduleWidthRatio;
    }

    public double getModuleWidthRatio() {
        return this.moduleWidthRatio;
    }

    @Override
    protected void encode() {
        int checkDigit;
        if (!this.content.matches("[0-9]*")) {
            throw OkapiInputException.invalidCharactersInInput();
        }
        int length = this.content.length();
        int maxExpectedLength = 2 + (length + MsiPlessey.maxCheckDigits(this.checkDigit)) * 8 + 3;
        StringBuilder intermediate = new StringBuilder(maxExpectedLength);
        intermediate.append("21");
        for (int i = 0; i < length; ++i) {
            char c = this.content.charAt(i);
            int n = Character.getNumericValue(c);
            intermediate.append(MSI_PLESS_TABLE[n]);
        }
        String data = this.content;
        if (this.checkDigit == CheckDigit.MOD10 || this.checkDigit == CheckDigit.MOD10_MOD10) {
            checkDigit = MsiPlessey.calcMod10(this.content);
            intermediate.append(MSI_PLESS_TABLE[checkDigit]);
            data = data + checkDigit;
        }
        if (this.checkDigit == CheckDigit.MOD11 || this.checkDigit == CheckDigit.MOD11_MOD10) {
            checkDigit = MsiPlessey.calcMod11(this.content);
            data = data + checkDigit;
            if (checkDigit == 10) {
                intermediate.append(MSI_PLESS_TABLE[1]);
                intermediate.append(MSI_PLESS_TABLE[0]);
            } else {
                intermediate.append(MSI_PLESS_TABLE[checkDigit]);
            }
        }
        if (this.checkDigit == CheckDigit.MOD10_MOD10 || this.checkDigit == CheckDigit.MOD11_MOD10) {
            checkDigit = MsiPlessey.calcMod10(data);
            intermediate.append(MSI_PLESS_TABLE[checkDigit]);
            data = data + checkDigit;
        }
        intermediate.append("121");
        assert (maxExpectedLength >= intermediate.length());
        assert (maxExpectedLength - intermediate.length() <= 8);
        this.readable = this.checkDigitInHumanReadableText ? data : this.content;
        this.pattern = new String[]{intermediate.toString()};
        this.row_count = 1;
        this.row_height = new int[]{-1};
    }

    private static int maxCheckDigits(CheckDigit scheme) {
        switch (scheme.ordinal()) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 3: {
                return 2;
            }
            case 2: {
                return 2;
            }
            case 4: {
                return 3;
            }
        }
        throw new OkapiInternalException("Unknown check digit scheme: " + (Object)((Object)scheme));
    }

    private static int calcMod10(String s) {
        int sum = 0;
        int parity = s.length() % 2;
        for (int i = s.length() - 1; i >= 0; --i) {
            int val = s.charAt(i) - 48;
            if (i % 2 == parity) {
                sum += val;
                continue;
            }
            sum += (val *= 2) % 10;
            sum += val / 10;
        }
        int checkDigit = 10 - sum % 10;
        if (checkDigit == 10) {
            checkDigit = 0;
        }
        return checkDigit;
    }

    private static int calcMod11(String s) {
        int sum = 0;
        int weight = 2;
        for (int i = s.length() - 1; i >= 0; --i) {
            sum += (s.charAt(i) - 48) * weight;
            if (++weight != 8) continue;
            weight = 2;
        }
        int checkDigit = 11 - sum % 11;
        if (checkDigit == 11) {
            checkDigit = 0;
        }
        return checkDigit;
    }

    @Override
    protected double getModuleWidth(int originalWidth) {
        if (originalWidth == 1) {
            return 1.0;
        }
        return this.moduleWidthRatio;
    }

    public static enum CheckDigit {
        NONE,
        MOD10,
        MOD10_MOD10,
        MOD11,
        MOD11_MOD10;

    }
}

