/*
 * Decompiled with CFR 0.152.
 */
package uk.org.okapibarcode.backend;

import uk.org.okapibarcode.backend.OkapiInputException;
import uk.org.okapibarcode.backend.Symbol;

public class KoreaPost
extends Symbol {
    private static final String[] KOREA_TABLE = new String[]{"1313150613", "0713131313", "0417131313", "1506131313", "0413171313", "17171313", "1315061313", "0413131713", "17131713", "13171713"};

    @Override
    protected void encode() {
        if (!this.content.matches("[0-9]+")) {
            throw OkapiInputException.invalidCharactersInInput();
        }
        if (this.content.length() > 6) {
            throw OkapiInputException.inputTooLong();
        }
        StringBuilder padded = new StringBuilder(6);
        for (int i = this.content.length(); i < 6; ++i) {
            padded.append('0');
        }
        padded.append(this.content);
        int total = 0;
        String accumulator = "";
        for (int i = 0; i < padded.length(); ++i) {
            int j = Character.getNumericValue(padded.charAt(i));
            accumulator = accumulator + KOREA_TABLE[j];
            total += j;
        }
        int check = 10 - total % 10;
        if (check == 10) {
            check = 0;
        }
        accumulator = accumulator + KOREA_TABLE[check];
        this.infoLine("Check Digit: " + check);
        this.readable = padded.toString() + check;
        this.pattern = new String[]{accumulator};
        this.row_count = 1;
        this.row_height = new int[]{-1};
    }
}

