/*
 * Decompiled with CFR 0.152.
 */
package uk.org.okapibarcode.backend;

import java.util.Locale;
import uk.org.okapibarcode.backend.Code128;
import uk.org.okapibarcode.backend.OkapiInputException;
import uk.org.okapibarcode.backend.Symbol;

public class DpdCode
extends Symbol {
    @Override
    protected void encode() {
        int start;
        int mod;
        this.content = this.content.toUpperCase(Locale.US);
        if (this.content.length() < 27) {
            throw new OkapiInputException("Input data too short");
        }
        if (this.content.length() > 28) {
            throw OkapiInputException.inputTooLong();
        }
        if (!this.content.matches(".?[0-9A-Z]{11}[0-9]{16}")) {
            throw OkapiInputException.invalidCharactersInInput();
        }
        Code128 code128 = new Code128();
        code128.setContent(this.content);
        int cd = mod = 36;
        for (int i = start = this.content.length() == 27 ? 0 : 1; i < this.content.length(); ++i) {
            char c = this.content.charAt(i);
            if ((cd += c >= 'A' ? c - 65 + 10 : c - 48) > mod) {
                cd -= mod;
            }
            if ((cd *= 2) <= mod) continue;
            cd -= mod + 1;
        }
        if ((cd = mod + 1 - cd) == mod) {
            cd = 0;
        }
        char check = (char)(cd < 10 ? cd + 48 : cd - 10 + 65);
        String hrt = this.content.substring(start, start + 4) + " " + this.content.substring(start + 4, start + 7) + " " + this.content.substring(start + 7, start + 11) + " " + this.content.substring(start + 11, start + 15) + " " + this.content.substring(start + 15, start + 19) + " " + this.content.substring(start + 19, start + 21) + " " + this.content.substring(start + 21, start + 24) + " " + this.content.substring(start + 24, start + 27) + " " + check;
        this.encodeInfo = code128.encodeInfo;
        this.readable = hrt;
        this.pattern = new String[]{code128.pattern[0]};
        this.row_count = 1;
        this.row_height = new int[]{-1};
    }

    @Override
    protected int[] getCodewords() {
        return this.getPatternAsCodewords(6);
    }
}

