/*
 * Decompiled with CFR 0.152.
 */
package uk.org.okapibarcode.backend;

import java.math.BigInteger;
import uk.org.okapibarcode.backend.DataBarLimited;
import uk.org.okapibarcode.backend.OkapiInputException;
import uk.org.okapibarcode.backend.Symbol;

public class DataBar14
extends Symbol {
    private static final int[] G_SUM_TABLE = new int[]{0, 161, 961, 2015, 2715, 0, 336, 1036, 1516};
    private static final int[] T_TABLE = new int[]{1, 10, 34, 70, 126, 4, 20, 48, 81};
    private static final int[] MODULES_ODD = new int[]{12, 10, 8, 6, 4, 5, 7, 9, 11};
    private static final int[] MODULES_EVEN = new int[]{4, 6, 8, 10, 12, 10, 8, 6, 4};
    private static final int[] WIDEST_ODD = new int[]{8, 6, 4, 3, 1, 2, 4, 6, 8};
    private static final int[] WIDEST_EVEN = new int[]{1, 3, 5, 6, 8, 7, 5, 3, 1};
    private static final int[] CHECKSUM_WEIGHT = new int[]{1, 3, 9, 27, 2, 6, 18, 54, 4, 12, 36, 29, 8, 24, 72, 58, 16, 48, 65, 37, 32, 17, 51, 74, 64, 34, 23, 69, 49, 68, 46, 59};
    private static final int[] FINDER_PATTERN = new int[]{3, 8, 2, 1, 1, 3, 5, 5, 1, 1, 3, 3, 7, 1, 1, 3, 1, 9, 1, 1, 2, 7, 4, 1, 1, 2, 5, 6, 1, 1, 2, 3, 8, 1, 1, 1, 5, 7, 1, 1, 1, 3, 9, 1, 1};
    private boolean linkageFlag;
    private int separatorHeight = 1;
    private Mode mode;

    public DataBar14() {
        this(Mode.LINEAR);
    }

    public DataBar14(Mode mode) {
        this.mode = mode;
    }

    @Override
    public void setDataType(Symbol.DataType dummy) {
    }

    @Override
    public boolean supportsGs1() {
        return false;
    }

    public void setMode(Mode mode) {
        this.mode = mode;
    }

    public Mode getMode() {
        return this.mode;
    }

    public void setSeparatorHeight(int separatorHeight) {
        if (separatorHeight < 1) {
            throw new IllegalArgumentException("Invalid DataBar-14 Stacked separator height: " + separatorHeight);
        }
        this.separatorHeight = separatorHeight;
    }

    public int getSeparatorHeight() {
        return this.separatorHeight;
    }

    protected void setLinkageFlag(boolean linkageFlag) {
        this.linkageFlag = linkageFlag;
    }

    protected boolean getLinkageFlag() {
        return this.linkageFlag;
    }

    @Override
    protected void encode() {
        int j;
        int latch;
        int writer;
        int i;
        boolean[][] grid = new boolean[5][100];
        int[] data_character = new int[4];
        int[] data_group = new int[4];
        int[] v_odd = new int[4];
        int[] v_even = new int[4];
        int[][] data_widths = new int[8][4];
        int[] total_widths = new int[46];
        StringBuilder bin = new StringBuilder();
        int compositeOffset = 0;
        if (this.content.length() > 13) {
            throw OkapiInputException.inputTooLong();
        }
        if (!this.content.matches("[0-9]+?")) {
            throw OkapiInputException.invalidCharactersInInput();
        }
        BigInteger accum = new BigInteger(this.content);
        if (this.linkageFlag) {
            accum = accum.add(new BigInteger("10000000000000"));
            compositeOffset = 1;
        }
        BigInteger left_reg = accum.divide(new BigInteger("4537077"));
        BigInteger right_reg = accum.mod(new BigInteger("4537077"));
        accum = left_reg.divide(new BigInteger("1597"));
        data_character[0] = accum.intValue();
        accum = left_reg.mod(new BigInteger("1597"));
        data_character[1] = accum.intValue();
        accum = right_reg.divide(new BigInteger("1597"));
        data_character[2] = accum.intValue();
        accum = right_reg.mod(new BigInteger("1597"));
        data_character[3] = accum.intValue();
        this.info("Data Characters: ");
        for (i = 0; i < 4; ++i) {
            this.infoSpace(data_character[i]);
        }
        this.infoLine();
        if (data_character[0] >= 0 && data_character[0] <= 160) {
            data_group[0] = 0;
        }
        if (data_character[0] >= 161 && data_character[0] <= 960) {
            data_group[0] = 1;
        }
        if (data_character[0] >= 961 && data_character[0] <= 2014) {
            data_group[0] = 2;
        }
        if (data_character[0] >= 2015 && data_character[0] <= 2714) {
            data_group[0] = 3;
        }
        if (data_character[0] >= 2715 && data_character[0] <= 2840) {
            data_group[0] = 4;
        }
        if (data_character[1] >= 0 && data_character[1] <= 335) {
            data_group[1] = 5;
        }
        if (data_character[1] >= 336 && data_character[1] <= 1035) {
            data_group[1] = 6;
        }
        if (data_character[1] >= 1036 && data_character[1] <= 1515) {
            data_group[1] = 7;
        }
        if (data_character[1] >= 1516 && data_character[1] <= 1596) {
            data_group[1] = 8;
        }
        if (data_character[3] >= 0 && data_character[3] <= 335) {
            data_group[3] = 5;
        }
        if (data_character[3] >= 336 && data_character[3] <= 1035) {
            data_group[3] = 6;
        }
        if (data_character[3] >= 1036 && data_character[3] <= 1515) {
            data_group[3] = 7;
        }
        if (data_character[3] >= 1516 && data_character[3] <= 1596) {
            data_group[3] = 8;
        }
        if (data_character[2] >= 0 && data_character[2] <= 160) {
            data_group[2] = 0;
        }
        if (data_character[2] >= 161 && data_character[2] <= 960) {
            data_group[2] = 1;
        }
        if (data_character[2] >= 961 && data_character[2] <= 2014) {
            data_group[2] = 2;
        }
        if (data_character[2] >= 2015 && data_character[2] <= 2714) {
            data_group[2] = 3;
        }
        if (data_character[2] >= 2715 && data_character[2] <= 2840) {
            data_group[2] = 4;
        }
        v_odd[0] = (data_character[0] - G_SUM_TABLE[data_group[0]]) / T_TABLE[data_group[0]];
        v_even[0] = (data_character[0] - G_SUM_TABLE[data_group[0]]) % T_TABLE[data_group[0]];
        v_odd[1] = (data_character[1] - G_SUM_TABLE[data_group[1]]) % T_TABLE[data_group[1]];
        v_even[1] = (data_character[1] - G_SUM_TABLE[data_group[1]]) / T_TABLE[data_group[1]];
        v_odd[3] = (data_character[3] - G_SUM_TABLE[data_group[3]]) % T_TABLE[data_group[3]];
        v_even[3] = (data_character[3] - G_SUM_TABLE[data_group[3]]) / T_TABLE[data_group[3]];
        v_odd[2] = (data_character[2] - G_SUM_TABLE[data_group[2]]) / T_TABLE[data_group[2]];
        v_even[2] = (data_character[2] - G_SUM_TABLE[data_group[2]]) % T_TABLE[data_group[2]];
        for (i = 0; i < 4; ++i) {
            int[] widths;
            if (i == 0 || i == 2) {
                widths = DataBarLimited.getWidths(v_odd[i], MODULES_ODD[data_group[i]], 4, WIDEST_ODD[data_group[i]], 1);
                data_widths[0][i] = widths[0];
                data_widths[2][i] = widths[1];
                data_widths[4][i] = widths[2];
                data_widths[6][i] = widths[3];
                widths = DataBarLimited.getWidths(v_even[i], MODULES_EVEN[data_group[i]], 4, WIDEST_EVEN[data_group[i]], 0);
                data_widths[1][i] = widths[0];
                data_widths[3][i] = widths[1];
                data_widths[5][i] = widths[2];
                data_widths[7][i] = widths[3];
                continue;
            }
            widths = DataBarLimited.getWidths(v_odd[i], MODULES_ODD[data_group[i]], 4, WIDEST_ODD[data_group[i]], 0);
            data_widths[0][i] = widths[0];
            data_widths[2][i] = widths[1];
            data_widths[4][i] = widths[2];
            data_widths[6][i] = widths[3];
            widths = DataBarLimited.getWidths(v_even[i], MODULES_EVEN[data_group[i]], 4, WIDEST_EVEN[data_group[i]], 1);
            data_widths[1][i] = widths[0];
            data_widths[3][i] = widths[1];
            data_widths[5][i] = widths[2];
            data_widths[7][i] = widths[3];
        }
        int checksum = 0;
        for (i = 0; i < 8; ++i) {
            checksum += CHECKSUM_WEIGHT[i] * data_widths[i][0];
            checksum += CHECKSUM_WEIGHT[i + 8] * data_widths[i][1];
            checksum += CHECKSUM_WEIGHT[i + 16] * data_widths[i][2];
            checksum += CHECKSUM_WEIGHT[i + 24] * data_widths[i][3];
        }
        if ((checksum %= 79) >= 8) {
            ++checksum;
        }
        if (checksum >= 72) {
            ++checksum;
        }
        int c_left = checksum / 9;
        int c_right = checksum % 9;
        this.infoLine("Checksum: " + checksum);
        total_widths[0] = 1;
        total_widths[1] = 1;
        total_widths[44] = 1;
        total_widths[45] = 1;
        for (i = 0; i < 8; ++i) {
            total_widths[i + 2] = data_widths[i][0];
            total_widths[i + 15] = data_widths[7 - i][1];
            total_widths[i + 23] = data_widths[i][3];
            total_widths[i + 36] = data_widths[7 - i][2];
        }
        for (i = 0; i < 5; ++i) {
            total_widths[i + 10] = FINDER_PATTERN[i + 5 * c_left];
            total_widths[i + 31] = FINDER_PATTERN[4 - i + 5 * c_right];
        }
        this.row_count = 0;
        boolean[] separator = new boolean[100];
        for (i = 0; i < separator.length; ++i) {
            separator[i] = false;
        }
        if (this.mode == Mode.LINEAR) {
            writer = 0;
            latch = 48;
            for (i = 0; i < 46; ++i) {
                for (j = 0; j < total_widths[i]; ++j) {
                    if (latch == 49) {
                        grid[this.row_count][writer] = true;
                    }
                    ++writer;
                }
                latch = latch == 49 ? 48 : 49;
            }
            if (this.symbol_width < writer) {
                this.symbol_width = writer;
            }
            if (this.linkageFlag) {
                for (i = 4; i < 92; ++i) {
                    separator[i] = !grid[0][i];
                }
                latch = 49;
                for (i = 16; i < 32; ++i) {
                    if (!grid[0][i]) {
                        if (latch == 49) {
                            separator[i] = true;
                            latch = 48;
                            continue;
                        }
                        separator[i] = false;
                        latch = 49;
                        continue;
                    }
                    separator[i] = false;
                    latch = 49;
                }
                latch = 49;
                for (i = 63; i < 78; ++i) {
                    if (!grid[0][i]) {
                        if (latch == 49) {
                            separator[i] = true;
                            latch = 48;
                            continue;
                        }
                        separator[i] = false;
                        latch = 49;
                        continue;
                    }
                    separator[i] = false;
                    latch = 49;
                }
            }
            ++this.row_count;
            int count = 0;
            int check_digit = 0;
            StringBuilder hrt = new StringBuilder(14);
            for (i = this.content.length(); i < 13; ++i) {
                hrt.append('0');
            }
            hrt.append(this.content);
            for (i = 0; i < 13; ++i) {
                count += hrt.charAt(i) - 48;
                if ((i & 1) != 0) continue;
                count += 2 * (hrt.charAt(i) - 48);
            }
            check_digit = 10 - count % 10;
            if (check_digit == 10) {
                check_digit = 0;
            }
            this.infoLine("Check Digit: " + check_digit);
            hrt.append((char)(check_digit + 48));
            this.readable = "(01)" + hrt;
        }
        if (this.mode == Mode.STACKED) {
            writer = 0;
            latch = 48;
            for (i = 0; i < 23; ++i) {
                for (j = 0; j < total_widths[i]; ++j) {
                    grid[this.row_count][writer] = latch == 49;
                    ++writer;
                }
                latch = latch == 49 ? 48 : 49;
            }
            grid[this.row_count][writer] = true;
            grid[this.row_count][writer + 1] = false;
            this.row_count += 2;
            grid[this.row_count][0] = true;
            grid[this.row_count][1] = false;
            writer = 0;
            latch = 49;
            for (i = 23; i < 46; ++i) {
                for (j = 0; j < total_widths[i]; ++j) {
                    grid[this.row_count][writer + 2] = latch == 49;
                    ++writer;
                }
                latch = latch == 49 ? 48 : 49;
            }
            for (i = 1; i < 46; ++i) {
                if (grid[this.row_count - 2][i] == grid[this.row_count][i]) {
                    if (grid[this.row_count - 2][i]) continue;
                    grid[this.row_count - 1][i] = true;
                    continue;
                }
                if (grid[this.row_count - 1][i - 1]) continue;
                grid[this.row_count - 1][i] = true;
            }
            for (i = 0; i < 4; ++i) {
                grid[this.row_count - 1][i] = false;
            }
            if (this.linkageFlag) {
                for (i = 4; i < 46; ++i) {
                    separator[i] = !grid[0][i];
                }
                latch = 49;
                for (i = 16; i < 32; ++i) {
                    if (!grid[0][i]) {
                        if (latch == 49) {
                            separator[i] = true;
                            latch = 48;
                            continue;
                        }
                        separator[i] = false;
                        latch = 49;
                        continue;
                    }
                    separator[i] = false;
                    latch = 49;
                }
            }
            ++this.row_count;
            if (this.symbol_width < 50) {
                this.symbol_width = 50;
            }
        }
        if (this.mode == Mode.OMNI) {
            writer = 0;
            latch = 48;
            for (i = 0; i < 23; ++i) {
                for (j = 0; j < total_widths[i]; ++j) {
                    grid[this.row_count][writer] = latch == 49;
                    ++writer;
                }
                latch = latch == 49 ? 48 : 49;
            }
            grid[this.row_count][writer] = true;
            grid[this.row_count][writer + 1] = false;
            this.row_count += 4;
            grid[this.row_count][0] = true;
            grid[this.row_count][1] = false;
            writer = 0;
            latch = 49;
            for (i = 23; i < 46; ++i) {
                for (j = 0; j < total_widths[i]; ++j) {
                    grid[this.row_count][writer + 2] = latch == 49;
                    ++writer;
                }
                latch = latch == 49 ? 48 : 49;
            }
            for (i = 5; i < 46; i += 2) {
                grid[this.row_count - 2][i] = true;
            }
            for (i = 4; i < 46; ++i) {
                if (grid[this.row_count - 4][i]) continue;
                grid[this.row_count - 3][i] = true;
            }
            latch = 49;
            for (i = 17; i < 33; ++i) {
                if (!grid[this.row_count - 4][i]) {
                    if (latch == 49) {
                        grid[this.row_count - 3][i] = true;
                        latch = 48;
                        continue;
                    }
                    grid[this.row_count - 3][i] = false;
                    latch = 49;
                    continue;
                }
                grid[this.row_count - 3][i] = false;
                latch = 49;
            }
            for (i = 4; i < 46; ++i) {
                if (grid[this.row_count][i]) continue;
                grid[this.row_count - 1][i] = true;
            }
            latch = 49;
            for (i = 16; i < 32; ++i) {
                if (!grid[this.row_count][i]) {
                    if (latch == 49) {
                        grid[this.row_count - 1][i] = true;
                        latch = 48;
                        continue;
                    }
                    grid[this.row_count - 1][i] = false;
                    latch = 49;
                    continue;
                }
                grid[this.row_count - 1][i] = false;
                latch = 49;
            }
            if (this.symbol_width < 50) {
                this.symbol_width = 50;
            }
            if (this.linkageFlag) {
                for (i = 4; i < 46; ++i) {
                    separator[i] = !grid[0][i];
                }
                latch = 49;
                for (i = 16; i < 32; ++i) {
                    if (!grid[0][i]) {
                        if (latch == 49) {
                            separator[i] = true;
                            latch = 48;
                            continue;
                        }
                        separator[i] = false;
                        latch = 49;
                        continue;
                    }
                    separator[i] = false;
                    latch = 49;
                }
            }
            ++this.row_count;
        }
        this.pattern = new String[this.row_count + compositeOffset];
        this.row_height = new int[this.row_count + compositeOffset];
        if (this.linkageFlag) {
            bin.setLength(0);
            for (j = 0; j < this.symbol_width; ++j) {
                if (separator[j]) {
                    bin.append('1');
                    continue;
                }
                bin.append('0');
            }
            this.pattern[0] = DataBar14.bin2pat(bin);
            this.row_height[0] = 1;
        }
        for (i = 0; i < this.row_count; ++i) {
            bin.setLength(0);
            for (j = 0; j < this.symbol_width; ++j) {
                if (grid[i][j]) {
                    bin.append('1');
                    continue;
                }
                bin.append('0');
            }
            this.pattern[i + compositeOffset] = DataBar14.bin2pat(bin);
        }
        if (this.mode == Mode.LINEAR) {
            this.row_height[0 + compositeOffset] = -1;
        }
        if (this.mode == Mode.STACKED) {
            this.row_height[0 + compositeOffset] = 5;
            this.row_height[1 + compositeOffset] = this.separatorHeight;
            this.row_height[2 + compositeOffset] = 7;
        }
        if (this.mode == Mode.OMNI) {
            this.row_height[0 + compositeOffset] = -1;
            this.row_height[1 + compositeOffset] = this.separatorHeight;
            this.row_height[2 + compositeOffset] = this.separatorHeight;
            this.row_height[3 + compositeOffset] = this.separatorHeight;
            this.row_height[4 + compositeOffset] = -1;
        }
        if (this.linkageFlag) {
            ++this.row_count;
        }
    }

    public static enum Mode {
        LINEAR,
        OMNI,
        STACKED;

    }
}

