/*
 * Decompiled with CFR 0.152.
 */
package uk.org.okapibarcode.backend;

import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import uk.org.okapibarcode.backend.HumanReadableLocation;
import uk.org.okapibarcode.backend.OkapiInputException;
import uk.org.okapibarcode.backend.ReedSolomon;
import uk.org.okapibarcode.backend.Symbol;

public class CodeOne
extends Symbol {
    private static final int[] C40_SHIFT = new int[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 2, 2, 2, 2, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3};
    private static final int[] C40_VALUE = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 3, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 15, 16, 17, 18, 19, 20, 21, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 22, 23, 24, 25, 26, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31};
    private static final int[] TEXT_SHIFT = new int[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 2, 2, 2, 2, 2, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 3, 3, 3, 3};
    private static final int[] TEXT_VALUE = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 3, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 15, 16, 17, 18, 19, 20, 21, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 22, 23, 24, 25, 26, 0, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 27, 28, 29, 30, 31};
    private static final int[] C1_HEIGHT = new int[]{16, 22, 28, 40, 52, 70, 104, 148};
    private static final int[] C1_WIDTH = new int[]{18, 22, 32, 42, 54, 76, 98, 134};
    private static final int[] C1_DATA_LENGTH = new int[]{10, 19, 44, 91, 182, 370, 732, 1480};
    private static final int[] C1_ECC_LENGTH = new int[]{10, 16, 26, 44, 70, 140, 280, 560};
    private static final int[] C1_BLOCKS = new int[]{1, 1, 1, 1, 1, 2, 4, 8};
    private static final int[] C1_DATA_BLOCKS = new int[]{10, 19, 44, 91, 182, 185, 183, 185};
    private static final int[] C1_ECC_BLOCKS = new int[]{10, 16, 26, 44, 70, 70, 70, 70};
    private static final int[] C1_GRID_WIDTH = new int[]{4, 5, 7, 9, 12, 17, 22, 30};
    private static final int[] C1_GRID_HEIGHT = new int[]{5, 7, 10, 15, 21, 30, 46, 68};
    private Version preferredVersion = Version.NONE;
    private int[] data = new int[1500];
    private int[][] datagrid = new int[136][120];
    private boolean[][] outputGrid = new boolean[148][134];

    public CodeOne() {
        this.humanReadableLocation = HumanReadableLocation.NONE;
    }

    public void setPreferredVersion(Version version) {
        this.preferredVersion = version;
    }

    public Version getPreferredVersion() {
        return this.preferredVersion;
    }

    @Override
    public boolean supportsGs1() {
        return true;
    }

    @Override
    protected void encode() {
        int data_length;
        int col;
        int row;
        int j;
        int i;
        int block_width;
        int size = 1;
        int sub_version = 0;
        int[] ecc = new int[600];
        int[] stream = new int[2100];
        int length = this.content.length();
        ReedSolomon rs = new ReedSolomon();
        int[] sub_data = new int[190];
        StringBuilder bin = new StringBuilder();
        if (!this.content.matches("[\u0000-\u00ff]+")) {
            throw OkapiInputException.invalidCharactersInInput();
        }
        if (this.preferredVersion == Version.S) {
            this.infoLine("Version: S");
            if (length > 18) {
                throw OkapiInputException.inputTooLong();
            }
            if (!this.content.matches("[0-9]+?")) {
                throw OkapiInputException.invalidCharactersInInput();
            }
            sub_version = 3;
            int codewords = 12;
            block_width = 6;
            if (length <= 12) {
                sub_version = 2;
                codewords = 8;
                block_width = 4;
            }
            if (length <= 6) {
                sub_version = 1;
                codewords = 4;
                block_width = 2;
            }
            BigInteger elreg = new BigInteger(this.content);
            for (i = 0; i < codewords; ++i) {
                BigInteger codewordValue = elreg.shiftRight(5 * i);
                codewordValue = codewordValue.and(BigInteger.valueOf(31L));
                this.data[codewords - i - 1] = codewordValue.intValue();
            }
            this.logCodewords(codewords);
            rs.init_gf(37);
            rs.init_code(codewords, 1);
            rs.encode(codewords, this.data);
            this.infoLine("ECC Codeword Count: " + codewords);
            for (i = 0; i < codewords; ++i) {
                stream[i] = this.data[i];
                stream[i + codewords] = rs.getResult(codewords - i - 1);
            }
            for (i = 0; i < 136; ++i) {
                for (j = 0; j < 120; ++j) {
                    this.datagrid[i][j] = 48;
                }
            }
            i = 0;
            for (row = 0; row < 2; ++row) {
                for (col = 0; col < block_width; ++col) {
                    if ((stream[i] & 0x10) != 0) {
                        this.datagrid[row * 2][col * 5] = 49;
                    }
                    if ((stream[i] & 8) != 0) {
                        this.datagrid[row * 2][col * 5 + 1] = 49;
                    }
                    if ((stream[i] & 4) != 0) {
                        this.datagrid[row * 2][col * 5 + 2] = 49;
                    }
                    if ((stream[i] & 2) != 0) {
                        this.datagrid[row * 2 + 1][col * 5] = 49;
                    }
                    if ((stream[i] & 1) != 0) {
                        this.datagrid[row * 2 + 1][col * 5 + 1] = 49;
                    }
                    if ((stream[i + 1] & 0x10) != 0) {
                        this.datagrid[row * 2][col * 5 + 3] = 49;
                    }
                    if ((stream[i + 1] & 8) != 0) {
                        this.datagrid[row * 2][col * 5 + 4] = 49;
                    }
                    if ((stream[i + 1] & 4) != 0) {
                        this.datagrid[row * 2 + 1][col * 5 + 2] = 49;
                    }
                    if ((stream[i + 1] & 2) != 0) {
                        this.datagrid[row * 2 + 1][col * 5 + 3] = 49;
                    }
                    if ((stream[i + 1] & 1) != 0) {
                        this.datagrid[row * 2 + 1][col * 5 + 4] = 49;
                    }
                    i += 2;
                }
            }
            this.infoLine("Grid Size: " + block_width + " X " + 2);
            size = 9;
            this.row_count = 8;
            this.symbol_width = 10 * sub_version + 1;
        }
        if (this.preferredVersion == Version.T) {
            this.infoLine("Version: T");
            for (i = 0; i < 40; ++i) {
                this.data[i] = 0;
            }
            data_length = this.encodeAsCode1Data();
            if (data_length > 38) {
                throw OkapiInputException.inputTooLong();
            }
            size = 10;
            sub_version = 3;
            int data_cw = 38;
            int ecc_cw = 22;
            block_width = 12;
            if (data_length <= 24) {
                sub_version = 2;
                data_cw = 24;
                ecc_cw = 16;
                block_width = 8;
            }
            if (data_length <= 10) {
                sub_version = 1;
                data_cw = 10;
                ecc_cw = 10;
                block_width = 4;
            }
            this.logCodewords(data_length);
            for (i = data_length; i < data_cw; ++i) {
                this.data[i] = 129;
            }
            rs.init_gf(301);
            rs.init_code(ecc_cw, 1);
            rs.encode(data_cw, this.data);
            this.infoLine("ECC Codeword Count: " + ecc_cw);
            for (i = 0; i < data_cw; ++i) {
                stream[i] = this.data[i];
            }
            for (i = 0; i < ecc_cw; ++i) {
                stream[data_cw + i] = rs.getResult(ecc_cw - i - 1);
            }
            for (i = 0; i < 136; ++i) {
                for (j = 0; j < 120; ++j) {
                    this.datagrid[i][j] = 48;
                }
            }
            i = 0;
            for (row = 0; row < 5; ++row) {
                for (col = 0; col < block_width; ++col) {
                    if ((stream[i] & 0x80) != 0) {
                        this.datagrid[row * 2][col * 4] = 49;
                    }
                    if ((stream[i] & 0x40) != 0) {
                        this.datagrid[row * 2][col * 4 + 1] = 49;
                    }
                    if ((stream[i] & 0x20) != 0) {
                        this.datagrid[row * 2][col * 4 + 2] = 49;
                    }
                    if ((stream[i] & 0x10) != 0) {
                        this.datagrid[row * 2][col * 4 + 3] = 49;
                    }
                    if ((stream[i] & 8) != 0) {
                        this.datagrid[row * 2 + 1][col * 4] = 49;
                    }
                    if ((stream[i] & 4) != 0) {
                        this.datagrid[row * 2 + 1][col * 4 + 1] = 49;
                    }
                    if ((stream[i] & 2) != 0) {
                        this.datagrid[row * 2 + 1][col * 4 + 2] = 49;
                    }
                    if ((stream[i] & 1) != 0) {
                        this.datagrid[row * 2 + 1][col * 4 + 3] = 49;
                    }
                    ++i;
                }
            }
            this.infoLine("Grid Size: " + block_width + " X " + 5);
            this.row_count = 16;
            this.symbol_width = sub_version * 16 + 1;
        }
        if (this.preferredVersion != Version.S && this.preferredVersion != Version.T) {
            for (i = 0; i < 1500; ++i) {
                this.data[i] = 0;
            }
            data_length = this.encodeAsCode1Data();
            for (i = 7; i >= 0; --i) {
                if (C1_DATA_LENGTH[i] < data_length) continue;
                size = i + 1;
            }
            if (CodeOne.getSize(this.preferredVersion) > size) {
                size = CodeOne.getSize(this.preferredVersion);
            }
            char version = (char)(size - 1 + 65);
            this.infoLine("Version: " + version);
            this.logCodewords(data_length);
            for (i = data_length; i < C1_DATA_LENGTH[size - 1]; ++i) {
                this.data[i] = 129;
            }
            data_length = C1_DATA_LENGTH[size - 1];
            int data_blocks = C1_BLOCKS[size - 1];
            rs.init_gf(301);
            rs.init_code(C1_ECC_BLOCKS[size - 1], 0);
            for (i = 0; i < data_blocks; ++i) {
                for (j = 0; j < C1_DATA_BLOCKS[size - 1]; ++j) {
                    sub_data[j] = this.data[j * data_blocks + i];
                }
                rs.encode(C1_DATA_BLOCKS[size - 1], sub_data);
                for (j = 0; j < C1_ECC_BLOCKS[size - 1]; ++j) {
                    ecc[CodeOne.C1_ECC_LENGTH[size - 1] - (j * data_blocks + i) - 1] = rs.getResult(j);
                }
            }
            this.infoLine("ECC Codeword Count: " + C1_ECC_LENGTH[size - 1]);
            for (i = 0; i < data_length; ++i) {
                stream[i] = this.data[i];
            }
            for (i = 0; i < C1_ECC_LENGTH[size - 1]; ++i) {
                stream[data_length + i] = ecc[i];
            }
            for (i = 0; i < 136; ++i) {
                for (j = 0; j < 120; ++j) {
                    this.datagrid[i][j] = 48;
                }
            }
            i = 0;
            for (row = 0; row < C1_GRID_HEIGHT[size - 1]; ++row) {
                for (col = 0; col < C1_GRID_WIDTH[size - 1]; ++col) {
                    if ((stream[i] & 0x80) != 0) {
                        this.datagrid[row * 2][col * 4] = 49;
                    }
                    if ((stream[i] & 0x40) != 0) {
                        this.datagrid[row * 2][col * 4 + 1] = 49;
                    }
                    if ((stream[i] & 0x20) != 0) {
                        this.datagrid[row * 2][col * 4 + 2] = 49;
                    }
                    if ((stream[i] & 0x10) != 0) {
                        this.datagrid[row * 2][col * 4 + 3] = 49;
                    }
                    if ((stream[i] & 8) != 0) {
                        this.datagrid[row * 2 + 1][col * 4] = 49;
                    }
                    if ((stream[i] & 4) != 0) {
                        this.datagrid[row * 2 + 1][col * 4 + 1] = 49;
                    }
                    if ((stream[i] & 2) != 0) {
                        this.datagrid[row * 2 + 1][col * 4 + 2] = 49;
                    }
                    if ((stream[i] & 1) != 0) {
                        this.datagrid[row * 2 + 1][col * 4 + 3] = 49;
                    }
                    ++i;
                }
            }
            this.infoLine("Grid Size: " + C1_GRID_WIDTH[size - 1] + " X " + C1_GRID_HEIGHT[size - 1]);
            this.row_count = C1_HEIGHT[size - 1];
            this.symbol_width = C1_WIDTH[size - 1];
        }
        for (i = 0; i < 148; ++i) {
            for (j = 0; j < 134; ++j) {
                this.outputGrid[i][j] = false;
            }
        }
        block0 : switch (size) {
            case 1: {
                this.plotCentralFinder(6, 3, 1);
                this.plotVerticalBar(4, 6, 1);
                this.plotVerticalBar(12, 5, 0);
                this.setGridModule(5, 12);
                this.plotSpigot(0);
                this.plotSpigot(15);
                this.plotDataBlock(0, 0, 5, 4, 0, 0);
                this.plotDataBlock(0, 4, 5, 12, 0, 2);
                this.plotDataBlock(5, 0, 5, 12, 6, 0);
                this.plotDataBlock(5, 12, 5, 4, 6, 2);
                break;
            }
            case 2: {
                this.plotCentralFinder(8, 4, 1);
                this.plotVerticalBar(4, 8, 1);
                this.plotVerticalBar(16, 7, 0);
                this.setGridModule(7, 16);
                this.plotSpigot(0);
                this.plotSpigot(21);
                this.plotDataBlock(0, 0, 7, 4, 0, 0);
                this.plotDataBlock(0, 4, 7, 16, 0, 2);
                this.plotDataBlock(7, 0, 7, 16, 8, 0);
                this.plotDataBlock(7, 16, 7, 4, 8, 2);
                break;
            }
            case 3: {
                this.plotCentralFinder(11, 4, 2);
                this.plotVerticalBar(4, 11, 1);
                this.plotVerticalBar(26, 13, 1);
                this.plotVerticalBar(4, 10, 0);
                this.plotVerticalBar(26, 10, 0);
                this.plotSpigot(0);
                this.plotSpigot(27);
                this.plotDataBlock(0, 0, 10, 4, 0, 0);
                this.plotDataBlock(0, 4, 10, 20, 0, 2);
                this.plotDataBlock(0, 24, 10, 4, 0, 4);
                this.plotDataBlock(10, 0, 10, 4, 8, 0);
                this.plotDataBlock(10, 4, 10, 20, 8, 2);
                this.plotDataBlock(10, 24, 10, 4, 8, 4);
                break;
            }
            case 4: {
                this.plotCentralFinder(16, 5, 1);
                this.plotVerticalBar(4, 16, 1);
                this.plotVerticalBar(20, 16, 1);
                this.plotVerticalBar(36, 16, 1);
                this.plotVerticalBar(4, 15, 0);
                this.plotVerticalBar(20, 15, 0);
                this.plotVerticalBar(36, 15, 0);
                this.plotSpigot(0);
                this.plotSpigot(12);
                this.plotSpigot(27);
                this.plotSpigot(39);
                this.plotDataBlock(0, 0, 15, 4, 0, 0);
                this.plotDataBlock(0, 4, 15, 14, 0, 2);
                this.plotDataBlock(0, 18, 15, 14, 0, 4);
                this.plotDataBlock(0, 32, 15, 4, 0, 6);
                this.plotDataBlock(15, 0, 15, 4, 10, 0);
                this.plotDataBlock(15, 4, 15, 14, 10, 2);
                this.plotDataBlock(15, 18, 15, 14, 10, 4);
                this.plotDataBlock(15, 32, 15, 4, 10, 6);
                break;
            }
            case 5: {
                this.plotCentralFinder(22, 5, 2);
                this.plotVerticalBar(4, 22, 1);
                this.plotVerticalBar(26, 24, 1);
                this.plotVerticalBar(48, 22, 1);
                this.plotVerticalBar(4, 21, 0);
                this.plotVerticalBar(26, 21, 0);
                this.plotVerticalBar(48, 21, 0);
                this.plotSpigot(0);
                this.plotSpigot(12);
                this.plotSpigot(39);
                this.plotSpigot(51);
                this.plotDataBlock(0, 0, 21, 4, 0, 0);
                this.plotDataBlock(0, 4, 21, 20, 0, 2);
                this.plotDataBlock(0, 24, 21, 20, 0, 4);
                this.plotDataBlock(0, 44, 21, 4, 0, 6);
                this.plotDataBlock(21, 0, 21, 4, 10, 0);
                this.plotDataBlock(21, 4, 21, 20, 10, 2);
                this.plotDataBlock(21, 24, 21, 20, 10, 4);
                this.plotDataBlock(21, 44, 21, 4, 10, 6);
                break;
            }
            case 6: {
                this.plotCentralFinder(31, 5, 3);
                this.plotVerticalBar(4, 31, 1);
                this.plotVerticalBar(26, 35, 1);
                this.plotVerticalBar(48, 31, 1);
                this.plotVerticalBar(70, 35, 1);
                this.plotVerticalBar(4, 30, 0);
                this.plotVerticalBar(26, 30, 0);
                this.plotVerticalBar(48, 30, 0);
                this.plotVerticalBar(70, 30, 0);
                this.plotSpigot(0);
                this.plotSpigot(12);
                this.plotSpigot(24);
                this.plotSpigot(45);
                this.plotSpigot(57);
                this.plotSpigot(69);
                this.plotDataBlock(0, 0, 30, 4, 0, 0);
                this.plotDataBlock(0, 4, 30, 20, 0, 2);
                this.plotDataBlock(0, 24, 30, 20, 0, 4);
                this.plotDataBlock(0, 44, 30, 20, 0, 6);
                this.plotDataBlock(0, 64, 30, 4, 0, 8);
                this.plotDataBlock(30, 0, 30, 4, 10, 0);
                this.plotDataBlock(30, 4, 30, 20, 10, 2);
                this.plotDataBlock(30, 24, 30, 20, 10, 4);
                this.plotDataBlock(30, 44, 30, 20, 10, 6);
                this.plotDataBlock(30, 64, 30, 4, 10, 8);
                break;
            }
            case 7: {
                this.plotCentralFinder(47, 6, 2);
                this.plotVerticalBar(6, 47, 1);
                this.plotVerticalBar(27, 49, 1);
                this.plotVerticalBar(48, 47, 1);
                this.plotVerticalBar(69, 49, 1);
                this.plotVerticalBar(90, 47, 1);
                this.plotVerticalBar(6, 46, 0);
                this.plotVerticalBar(27, 46, 0);
                this.plotVerticalBar(48, 46, 0);
                this.plotVerticalBar(69, 46, 0);
                this.plotVerticalBar(90, 46, 0);
                this.plotSpigot(0);
                this.plotSpigot(12);
                this.plotSpigot(24);
                this.plotSpigot(36);
                this.plotSpigot(67);
                this.plotSpigot(79);
                this.plotSpigot(91);
                this.plotSpigot(103);
                this.plotDataBlock(0, 0, 46, 6, 0, 0);
                this.plotDataBlock(0, 6, 46, 19, 0, 2);
                this.plotDataBlock(0, 25, 46, 19, 0, 4);
                this.plotDataBlock(0, 44, 46, 19, 0, 6);
                this.plotDataBlock(0, 63, 46, 19, 0, 8);
                this.plotDataBlock(0, 82, 46, 6, 0, 10);
                this.plotDataBlock(46, 0, 46, 6, 12, 0);
                this.plotDataBlock(46, 6, 46, 19, 12, 2);
                this.plotDataBlock(46, 25, 46, 19, 12, 4);
                this.plotDataBlock(46, 44, 46, 19, 12, 6);
                this.plotDataBlock(46, 63, 46, 19, 12, 8);
                this.plotDataBlock(46, 82, 46, 6, 12, 10);
                break;
            }
            case 8: {
                this.plotCentralFinder(69, 6, 3);
                this.plotVerticalBar(6, 69, 1);
                this.plotVerticalBar(26, 73, 1);
                this.plotVerticalBar(46, 69, 1);
                this.plotVerticalBar(66, 73, 1);
                this.plotVerticalBar(86, 69, 1);
                this.plotVerticalBar(106, 73, 1);
                this.plotVerticalBar(126, 69, 1);
                this.plotVerticalBar(6, 68, 0);
                this.plotVerticalBar(26, 68, 0);
                this.plotVerticalBar(46, 68, 0);
                this.plotVerticalBar(66, 68, 0);
                this.plotVerticalBar(86, 68, 0);
                this.plotVerticalBar(106, 68, 0);
                this.plotVerticalBar(126, 68, 0);
                this.plotSpigot(0);
                this.plotSpigot(12);
                this.plotSpigot(24);
                this.plotSpigot(36);
                this.plotSpigot(48);
                this.plotSpigot(60);
                this.plotSpigot(87);
                this.plotSpigot(99);
                this.plotSpigot(111);
                this.plotSpigot(123);
                this.plotSpigot(135);
                this.plotSpigot(147);
                this.plotDataBlock(0, 0, 68, 6, 0, 0);
                this.plotDataBlock(0, 6, 68, 18, 0, 2);
                this.plotDataBlock(0, 24, 68, 18, 0, 4);
                this.plotDataBlock(0, 42, 68, 18, 0, 6);
                this.plotDataBlock(0, 60, 68, 18, 0, 8);
                this.plotDataBlock(0, 78, 68, 18, 0, 10);
                this.plotDataBlock(0, 96, 68, 18, 0, 12);
                this.plotDataBlock(0, 114, 68, 6, 0, 14);
                this.plotDataBlock(68, 0, 68, 6, 12, 0);
                this.plotDataBlock(68, 6, 68, 18, 12, 2);
                this.plotDataBlock(68, 24, 68, 18, 12, 4);
                this.plotDataBlock(68, 42, 68, 18, 12, 6);
                this.plotDataBlock(68, 60, 68, 18, 12, 8);
                this.plotDataBlock(68, 78, 68, 18, 12, 10);
                this.plotDataBlock(68, 96, 68, 18, 12, 12);
                this.plotDataBlock(68, 114, 68, 6, 12, 14);
                break;
            }
            case 9: {
                this.plotHorizontalBar(5, 1);
                this.plotHorizontalBar(7, 1);
                this.setGridModule(6, 0);
                this.setGridModule(6, this.symbol_width - 1);
                this.resetGridModule(7, 1);
                this.resetGridModule(7, this.symbol_width - 2);
                switch (sub_version) {
                    case 1: {
                        this.setGridModule(0, 5);
                        this.plotDataBlock(0, 0, 4, 5, 0, 0);
                        this.plotDataBlock(0, 5, 4, 5, 0, 1);
                        break;
                    }
                    case 2: {
                        this.setGridModule(0, 10);
                        this.setGridModule(4, 10);
                        this.plotDataBlock(0, 0, 4, 10, 0, 0);
                        this.plotDataBlock(0, 10, 4, 10, 0, 1);
                        break;
                    }
                    case 3: {
                        this.setGridModule(0, 15);
                        this.setGridModule(4, 15);
                        this.setGridModule(6, 15);
                        this.plotDataBlock(0, 0, 4, 15, 0, 0);
                        this.plotDataBlock(0, 15, 4, 15, 0, 1);
                    }
                }
                break;
            }
            case 10: {
                this.plotHorizontalBar(11, 1);
                this.plotHorizontalBar(13, 1);
                this.plotHorizontalBar(15, 1);
                this.setGridModule(12, 0);
                this.setGridModule(12, this.symbol_width - 1);
                this.setGridModule(14, 0);
                this.setGridModule(14, this.symbol_width - 1);
                this.resetGridModule(13, 1);
                this.resetGridModule(13, this.symbol_width - 2);
                this.resetGridModule(15, 1);
                this.resetGridModule(15, this.symbol_width - 2);
                switch (sub_version) {
                    case 1: {
                        this.setGridModule(0, 8);
                        this.setGridModule(10, 8);
                        this.plotDataBlock(0, 0, 10, 8, 0, 0);
                        this.plotDataBlock(0, 8, 10, 8, 0, 1);
                        break block0;
                    }
                    case 2: {
                        this.setGridModule(0, 16);
                        this.setGridModule(10, 16);
                        this.setGridModule(12, 16);
                        this.plotDataBlock(0, 0, 10, 16, 0, 0);
                        this.plotDataBlock(0, 16, 10, 16, 0, 1);
                        break block0;
                    }
                    case 3: {
                        this.setGridModule(0, 24);
                        this.setGridModule(10, 24);
                        this.setGridModule(12, 24);
                        this.setGridModule(14, 24);
                        this.plotDataBlock(0, 0, 10, 24, 0, 0);
                        this.plotDataBlock(0, 24, 10, 24, 0, 1);
                    }
                }
            }
        }
        this.readable = "";
        this.pattern = new String[this.row_count];
        this.row_height = new int[this.row_count];
        for (i = 0; i < this.row_count; ++i) {
            bin.setLength(0);
            for (j = 0; j < this.symbol_width; ++j) {
                if (this.outputGrid[i][j]) {
                    bin.append('1');
                    continue;
                }
                bin.append('0');
            }
            this.pattern[i] = CodeOne.bin2pat(bin);
            this.row_height[i] = this.moduleWidth;
        }
    }

    private void logCodewords(int count) {
        this.info("Codewords: ");
        for (int i = 0; i < count; ++i) {
            this.infoSpace(this.data[i]);
        }
        this.infoLine();
    }

    private int encodeAsCode1Data() {
        int bits_left_in_byte;
        int target_count;
        int iv;
        int i;
        int byte_start = 0;
        int[] c40_buffer = new int[6];
        int[] text_buffer = new int[6];
        int[] edi_buffer = new int[6];
        String decimal_binary = "";
        this.inputData = CodeOne.toBytes(this.content, StandardCharsets.ISO_8859_1, new int[0]);
        int length = this.inputData.length;
        int sourcePoint = 0;
        int targetPoint = 0;
        int c40_p = 0;
        int text_p = 0;
        int edi_p = 0;
        if (this.inputDataType == Symbol.DataType.GS1) {
            this.data[targetPoint] = 232;
            ++targetPoint;
        }
        Mode current_mode = Mode.C1_ASCII;
        Mode next_mode = Mode.C1_ASCII;
        do {
            int value;
            int shift_set;
            boolean done;
            boolean latch;
            int j;
            if (current_mode != next_mode) {
                switch (next_mode.ordinal()) {
                    case 1: {
                        this.data[targetPoint] = 230;
                        ++targetPoint;
                        break;
                    }
                    case 3: {
                        this.data[targetPoint] = 239;
                        ++targetPoint;
                        break;
                    }
                    case 4: {
                        this.data[targetPoint] = 238;
                        ++targetPoint;
                        break;
                    }
                    case 5: {
                        this.data[targetPoint] = 231;
                        ++targetPoint;
                    }
                }
            }
            if (current_mode != Mode.C1_BYTE && next_mode == Mode.C1_BYTE) {
                byte_start = targetPoint;
            }
            if ((current_mode = next_mode) == Mode.C1_ASCII) {
                next_mode = Mode.C1_ASCII;
                if (length - sourcePoint >= 21) {
                    j = 0;
                    for (i = 0; i < 21; ++i) {
                        if (this.inputData[sourcePoint + i] < 48 || this.inputData[sourcePoint + i] > 57) continue;
                        ++j;
                    }
                    if (j == 21) {
                        next_mode = Mode.C1_DECIMAL;
                        decimal_binary = decimal_binary + "1111";
                    }
                }
                if (next_mode == Mode.C1_ASCII && length - sourcePoint >= 13) {
                    j = 0;
                    for (i = 0; i < 13; ++i) {
                        if (this.inputData[sourcePoint + i] < 48 || this.inputData[sourcePoint + i] > 57) continue;
                        ++j;
                    }
                    if (j == 13) {
                        latch = false;
                        for (i = sourcePoint + 13; i < length; ++i) {
                            if (this.inputData[i] >= 48 && this.inputData[i] <= 57) continue;
                            latch = true;
                        }
                        if (!latch) {
                            next_mode = Mode.C1_DECIMAL;
                            decimal_binary = decimal_binary + "1111";
                        }
                    }
                }
                if (next_mode == Mode.C1_ASCII) {
                    boolean isTwoDigits = false;
                    if (sourcePoint + 1 != length && this.inputData[sourcePoint] >= 48 && this.inputData[sourcePoint] <= 57 && this.inputData[sourcePoint + 1] >= 48 && this.inputData[sourcePoint + 1] <= 57) {
                        this.data[targetPoint] = 10 * (this.inputData[sourcePoint] - 48) + (this.inputData[sourcePoint + 1] - 48) + 130;
                        ++targetPoint;
                        sourcePoint += 2;
                        isTwoDigits = true;
                    }
                    if (!isTwoDigits) {
                        if (this.inputData[sourcePoint] == -1) {
                            if (length - sourcePoint >= 15) {
                                j = 0;
                                for (i = 0; i < 15; ++i) {
                                    if (this.inputData[sourcePoint + i] < 48 || this.inputData[sourcePoint + i] > 57) continue;
                                    ++j;
                                }
                                if (j == 15) {
                                    this.data[targetPoint] = 236;
                                    ++targetPoint;
                                    ++sourcePoint;
                                    next_mode = Mode.C1_DECIMAL;
                                }
                            }
                            if (length - sourcePoint >= 7) {
                                j = 0;
                                for (i = 0; i < 7; ++i) {
                                    if (this.inputData[sourcePoint + i] < 48 || this.inputData[sourcePoint + i] > 57) continue;
                                    ++j;
                                }
                                if (j == 7) {
                                    latch = false;
                                    for (i = sourcePoint + 7; i < length; ++i) {
                                        if (this.inputData[sourcePoint + i] >= 48 && this.inputData[sourcePoint + i] <= 57) continue;
                                        latch = true;
                                    }
                                    if (!latch) {
                                        this.data[targetPoint] = 236;
                                        ++targetPoint;
                                        ++sourcePoint;
                                        next_mode = Mode.C1_DECIMAL;
                                    }
                                }
                            }
                        }
                        if (next_mode == Mode.C1_ASCII && (next_mode = this.lookAheadTest(length, sourcePoint, current_mode)) == Mode.C1_ASCII) {
                            if (this.inputData[sourcePoint] > 127) {
                                this.data[targetPoint] = 235;
                                this.data[++targetPoint] = this.inputData[sourcePoint] - 128 + 1;
                                ++targetPoint;
                                ++sourcePoint;
                            } else if (this.inputData[sourcePoint] == -1) {
                                this.data[targetPoint] = 232;
                                ++targetPoint;
                                ++sourcePoint;
                            } else {
                                this.data[targetPoint] = this.inputData[sourcePoint] + 1;
                                ++targetPoint;
                                ++sourcePoint;
                            }
                        }
                    }
                }
            }
            if (current_mode == Mode.C1_C40) {
                done = false;
                next_mode = Mode.C1_C40;
                if (c40_p == 0) {
                    if (length - sourcePoint >= 12) {
                        j = 0;
                        for (i = 0; i < 12; ++i) {
                            if (this.inputData[sourcePoint + i] < 48 || this.inputData[sourcePoint + i] > 57) continue;
                            ++j;
                        }
                        if (j == 12) {
                            next_mode = Mode.C1_ASCII;
                            done = true;
                        }
                    }
                    if (length - sourcePoint >= 8) {
                        j = 0;
                        for (i = 0; i < 8; ++i) {
                            if (this.inputData[sourcePoint + i] < 48 || this.inputData[sourcePoint + i] > 57) continue;
                            ++j;
                        }
                        if (length - sourcePoint == 8) {
                            latch = true;
                        } else {
                            latch = true;
                            for (j = sourcePoint + 8; j < length; ++j) {
                                if (this.inputData[j] > 48 && this.inputData[j] < 57) continue;
                                latch = false;
                            }
                        }
                        if (j == 8 && latch) {
                            next_mode = Mode.C1_ASCII;
                            done = true;
                        }
                    }
                    if (!done) {
                        next_mode = this.lookAheadTest(length, sourcePoint, current_mode);
                    }
                }
                if (next_mode != Mode.C1_C40) {
                    this.data[targetPoint] = 255;
                    ++targetPoint;
                } else {
                    if (this.inputData[sourcePoint] > 127) {
                        c40_buffer[c40_p] = 1;
                        c40_buffer[++c40_p] = 30;
                        ++c40_p;
                        shift_set = C40_SHIFT[this.inputData[sourcePoint] - 128];
                        value = C40_VALUE[this.inputData[sourcePoint] - 128];
                    } else {
                        shift_set = C40_SHIFT[this.inputData[sourcePoint]];
                        value = C40_VALUE[this.inputData[sourcePoint]];
                    }
                    if (this.inputData[sourcePoint] == -1) {
                        shift_set = 2;
                        value = 27;
                    }
                    if (shift_set != 0) {
                        c40_buffer[c40_p] = shift_set - 1;
                        ++c40_p;
                    }
                    c40_buffer[c40_p] = value;
                    if (++c40_p >= 3) {
                        iv = 1600 * c40_buffer[0] + 40 * c40_buffer[1] + c40_buffer[2] + 1;
                        this.data[targetPoint] = iv / 256;
                        this.data[++targetPoint] = iv % 256;
                        ++targetPoint;
                        c40_buffer[0] = c40_buffer[3];
                        c40_buffer[1] = c40_buffer[4];
                        c40_buffer[2] = c40_buffer[5];
                        c40_buffer[3] = 0;
                        c40_buffer[4] = 0;
                        c40_buffer[5] = 0;
                        c40_p -= 3;
                    }
                    ++sourcePoint;
                }
            }
            if (current_mode == Mode.C1_TEXT) {
                done = false;
                next_mode = Mode.C1_TEXT;
                if (text_p == 0) {
                    if (length - sourcePoint >= 12) {
                        j = 0;
                        for (i = 0; i < 12; ++i) {
                            if (this.inputData[sourcePoint + i] < 48 || this.inputData[sourcePoint + i] > 57) continue;
                            ++j;
                        }
                        if (j == 12) {
                            next_mode = Mode.C1_ASCII;
                            done = true;
                        }
                    }
                    if (length - sourcePoint >= 8) {
                        j = 0;
                        for (i = 0; i < 8; ++i) {
                            if (this.inputData[sourcePoint + i] < 48 || this.inputData[sourcePoint + i] > 57) continue;
                            ++j;
                        }
                        if (length - sourcePoint == 8) {
                            latch = true;
                        } else {
                            latch = true;
                            for (j = sourcePoint + 8; j < length; ++j) {
                                if (this.inputData[j] > 48 && this.inputData[j] < 57) continue;
                                latch = false;
                            }
                        }
                        if (j == 8 && latch) {
                            next_mode = Mode.C1_ASCII;
                            done = true;
                        }
                    }
                    if (!done) {
                        next_mode = this.lookAheadTest(length, sourcePoint, current_mode);
                    }
                }
                if (next_mode != Mode.C1_TEXT) {
                    this.data[targetPoint] = 255;
                    ++targetPoint;
                } else {
                    if (this.inputData[sourcePoint] > 127) {
                        text_buffer[text_p] = 1;
                        text_buffer[++text_p] = 30;
                        ++text_p;
                        shift_set = TEXT_SHIFT[this.inputData[sourcePoint] - 128];
                        value = TEXT_VALUE[this.inputData[sourcePoint] - 128];
                    } else {
                        shift_set = TEXT_SHIFT[this.inputData[sourcePoint]];
                        value = TEXT_VALUE[this.inputData[sourcePoint]];
                    }
                    if (this.inputData[sourcePoint] == -1) {
                        shift_set = 2;
                        value = 27;
                    }
                    if (shift_set != 0) {
                        text_buffer[text_p] = shift_set - 1;
                        ++text_p;
                    }
                    text_buffer[text_p] = value;
                    if (++text_p >= 3) {
                        iv = 1600 * text_buffer[0] + 40 * text_buffer[1] + text_buffer[2] + 1;
                        this.data[targetPoint] = iv / 256;
                        this.data[++targetPoint] = iv % 256;
                        ++targetPoint;
                        text_buffer[0] = text_buffer[3];
                        text_buffer[1] = text_buffer[4];
                        text_buffer[2] = text_buffer[5];
                        text_buffer[3] = 0;
                        text_buffer[4] = 0;
                        text_buffer[5] = 0;
                        text_p -= 3;
                    }
                    ++sourcePoint;
                }
            }
            if (current_mode == Mode.C1_EDI) {
                value = 0;
                next_mode = Mode.C1_EDI;
                if (edi_p == 0) {
                    if (length - sourcePoint >= 12) {
                        j = 0;
                        for (i = 0; i < 12; ++i) {
                            if (this.inputData[sourcePoint + i] < 48 || this.inputData[sourcePoint + i] > 57) continue;
                            ++j;
                        }
                        if (j == 12) {
                            next_mode = Mode.C1_ASCII;
                        }
                    }
                    if (length - sourcePoint >= 8) {
                        j = 0;
                        for (i = 0; i < 8; ++i) {
                            if (this.inputData[sourcePoint + i] < 48 || this.inputData[sourcePoint + i] > 57) continue;
                            ++j;
                        }
                        if (length - sourcePoint == 8) {
                            latch = true;
                        } else {
                            latch = true;
                            for (j = sourcePoint + 8; j < length; ++j) {
                                if (this.inputData[j] > 48 && this.inputData[j] < 57) continue;
                                latch = false;
                            }
                        }
                        if (j == 8 && latch) {
                            next_mode = Mode.C1_ASCII;
                        }
                    }
                    if (!(this.isEdiEncodable(this.inputData[sourcePoint]) && this.isEdiEncodable(this.inputData[sourcePoint + 1]) && this.isEdiEncodable(this.inputData[sourcePoint + 2]))) {
                        next_mode = Mode.C1_ASCII;
                    }
                }
                if (next_mode != Mode.C1_EDI) {
                    this.data[targetPoint] = 255;
                    ++targetPoint;
                } else {
                    if (this.inputData[sourcePoint] == 13) {
                        value = 0;
                    }
                    if (this.inputData[sourcePoint] == 42) {
                        value = 1;
                    }
                    if (this.inputData[sourcePoint] == 62) {
                        value = 2;
                    }
                    if (this.inputData[sourcePoint] == 32) {
                        value = 3;
                    }
                    if (this.inputData[sourcePoint] >= 48 && this.inputData[sourcePoint] <= 57) {
                        value = this.inputData[sourcePoint] - 48 + 4;
                    }
                    if (this.inputData[sourcePoint] >= 65 && this.inputData[sourcePoint] <= 90) {
                        value = this.inputData[sourcePoint] - 65 + 14;
                    }
                    edi_buffer[edi_p] = value;
                    if (++edi_p >= 3) {
                        iv = 1600 * edi_buffer[0] + 40 * edi_buffer[1] + edi_buffer[2] + 1;
                        this.data[targetPoint] = iv / 256;
                        this.data[++targetPoint] = iv % 256;
                        ++targetPoint;
                        edi_buffer[0] = edi_buffer[3];
                        edi_buffer[1] = edi_buffer[4];
                        edi_buffer[2] = edi_buffer[5];
                        edi_buffer[3] = 0;
                        edi_buffer[4] = 0;
                        edi_buffer[5] = 0;
                        edi_p -= 3;
                    }
                    ++sourcePoint;
                }
            }
            if (current_mode == Mode.C1_DECIMAL) {
                next_mode = Mode.C1_DECIMAL;
                int data_left = length - sourcePoint;
                int decimal_count = 0;
                if (data_left >= 1 && this.inputData[sourcePoint] >= 48 && this.inputData[sourcePoint] <= 57) {
                    decimal_count = 1;
                }
                if (data_left >= 2 && decimal_count == 1 && this.inputData[sourcePoint + 1] >= 48 && this.inputData[sourcePoint + 1] <= 57) {
                    decimal_count = 2;
                }
                if (data_left >= 3 && decimal_count == 2 && this.inputData[sourcePoint + 2] >= 48 && this.inputData[sourcePoint + 2] <= 57) {
                    decimal_count = 3;
                }
                if (decimal_count != 3) {
                    decimal_binary = decimal_binary + "111111";
                    target_count = 3;
                    if (decimal_binary.length() <= 16) {
                        target_count = 2;
                    }
                    if (decimal_binary.length() <= 8) {
                        target_count = 1;
                    }
                    if ((bits_left_in_byte = 8 * target_count - decimal_binary.length()) == 8) {
                        bits_left_in_byte = 0;
                    }
                    if (bits_left_in_byte == 2) {
                        decimal_binary = decimal_binary + "01";
                    }
                    if (bits_left_in_byte == 4 || bits_left_in_byte == 6) {
                        if (decimal_count >= 1) {
                            int sub_value = this.inputData[sourcePoint] - 48 + 1;
                            for (i = 8; i > 0; i >>= 1) {
                                decimal_binary = (sub_value & i) != 0 ? decimal_binary + "1" : decimal_binary + "0";
                            }
                            ++sourcePoint;
                        } else {
                            decimal_binary = decimal_binary + "1111";
                        }
                    }
                    if (bits_left_in_byte == 6) {
                        decimal_binary = decimal_binary + "01";
                    }
                    if (target_count >= 1) {
                        for (i = 0; i < 8; ++i) {
                            if (decimal_binary.charAt(i) != '1') continue;
                            int n = targetPoint;
                            this.data[n] = this.data[n] + (128 >> i);
                        }
                        ++targetPoint;
                    }
                    if (target_count >= 2) {
                        for (i = 0; i < 8; ++i) {
                            if (decimal_binary.charAt(8 + i) != '1') continue;
                            int n = targetPoint;
                            this.data[n] = this.data[n] + (128 >> i);
                        }
                        ++targetPoint;
                    }
                    if (target_count == 3) {
                        for (i = 0; i < 8; ++i) {
                            if (decimal_binary.charAt(16 + i) != '1') continue;
                            int n = targetPoint;
                            this.data[n] = this.data[n] + (128 >> i);
                        }
                        ++targetPoint;
                    }
                    next_mode = Mode.C1_ASCII;
                } else {
                    value = 100 * (this.inputData[sourcePoint] - 48) + 10 * (this.inputData[sourcePoint + 1] - 48) + (this.inputData[sourcePoint + 2] - 48) + 1;
                    for (i = 512; i > 0; i >>= 1) {
                        decimal_binary = (value & i) != 0 ? decimal_binary + "1" : decimal_binary + "0";
                    }
                    sourcePoint += 3;
                }
                if (decimal_binary.length() >= 24) {
                    for (i = 0; i < 8; ++i) {
                        if (decimal_binary.charAt(i) == '1') {
                            int n = targetPoint;
                            this.data[n] = this.data[n] + (128 >> i);
                        }
                        if (decimal_binary.charAt(8 + i) == '1') {
                            int n = targetPoint + 1;
                            this.data[n] = this.data[n] + (128 >> i);
                        }
                        if (decimal_binary.charAt(16 + i) != '1') continue;
                        int n = targetPoint + 2;
                        this.data[n] = this.data[n] + (128 >> i);
                    }
                    targetPoint += 3;
                    if (decimal_binary.length() > 24) {
                        decimal_binary = decimal_binary.substring(24);
                    }
                }
            }
            if (current_mode == Mode.C1_BYTE) {
                next_mode = Mode.C1_BYTE;
                if (this.inputData[sourcePoint] == -1) {
                    next_mode = Mode.C1_ASCII;
                } else if (this.inputData[sourcePoint] <= 127) {
                    next_mode = this.lookAheadTest(length, sourcePoint, current_mode);
                }
                if (next_mode != Mode.C1_BYTE) {
                    if (targetPoint - byte_start <= 249) {
                        for (i = targetPoint; i >= byte_start; --i) {
                            this.data[i + 1] = this.data[i];
                        }
                        this.data[byte_start] = targetPoint - byte_start;
                        ++targetPoint;
                    } else {
                        for (i = targetPoint; i >= byte_start; --i) {
                            this.data[i + 2] = this.data[i];
                        }
                        this.data[byte_start] = 249 + (targetPoint - byte_start) / 250;
                        this.data[byte_start + 1] = (targetPoint - byte_start) % 250;
                        targetPoint += 2;
                    }
                } else {
                    this.data[targetPoint] = this.inputData[sourcePoint];
                    ++targetPoint;
                    ++sourcePoint;
                }
            }
            if (targetPoint <= 1480) continue;
            throw OkapiInputException.inputTooLong();
        } while (sourcePoint < length);
        if (c40_p == 2) {
            c40_buffer[2] = 1;
            iv = 1600 * c40_buffer[0] + 40 * c40_buffer[1] + c40_buffer[2] + 1;
            this.data[targetPoint] = iv / 256;
            this.data[++targetPoint] = iv % 256;
            this.data[++targetPoint] = 255;
            ++targetPoint;
        }
        if (c40_p == 1) {
            c40_buffer[1] = 1;
            c40_buffer[2] = 31;
            iv = 1600 * c40_buffer[0] + 40 * c40_buffer[1] + c40_buffer[2] + 1;
            this.data[targetPoint] = iv / 256;
            this.data[++targetPoint] = iv % 256;
            this.data[++targetPoint] = 255;
            ++targetPoint;
        }
        if (text_p == 2) {
            text_buffer[2] = 1;
            iv = 1600 * text_buffer[0] + 40 * text_buffer[1] + text_buffer[2] + 1;
            this.data[targetPoint] = iv / 256;
            this.data[++targetPoint] = iv % 256;
            this.data[++targetPoint] = 255;
            ++targetPoint;
        }
        if (text_p == 1) {
            text_buffer[1] = 1;
            text_buffer[2] = 31;
            iv = 1600 * text_buffer[0] + 40 * text_buffer[1] + text_buffer[2] + 1;
            this.data[targetPoint] = iv / 256;
            this.data[++targetPoint] = iv % 256;
            this.data[++targetPoint] = 255;
            ++targetPoint;
        }
        if (current_mode == Mode.C1_DECIMAL) {
            decimal_binary = decimal_binary + "111111";
            target_count = 3;
            if (decimal_binary.length() <= 16) {
                target_count = 2;
            }
            if (decimal_binary.length() <= 8) {
                target_count = 1;
            }
            if ((bits_left_in_byte = 8 * target_count - decimal_binary.length()) == 8) {
                bits_left_in_byte = 0;
            }
            if (bits_left_in_byte == 2) {
                decimal_binary = decimal_binary + "01";
            }
            if (bits_left_in_byte == 4 || bits_left_in_byte == 6) {
                decimal_binary = decimal_binary + "1111";
            }
            if (bits_left_in_byte == 6) {
                decimal_binary = decimal_binary + "01";
            }
            if (target_count >= 1) {
                for (i = 0; i < 8; ++i) {
                    if (decimal_binary.charAt(i) != '1') continue;
                    int n = targetPoint;
                    this.data[n] = this.data[n] + (128 >> i);
                }
                ++targetPoint;
            }
            if (target_count >= 2) {
                for (i = 0; i < 8; ++i) {
                    if (decimal_binary.charAt(8 + i) != '1') continue;
                    int n = targetPoint;
                    this.data[n] = this.data[n] + (128 >> i);
                }
                ++targetPoint;
            }
            if (target_count == 3) {
                for (i = 0; i < 8; ++i) {
                    if (decimal_binary.charAt(16 + i) != '1') continue;
                    int n = targetPoint;
                    this.data[n] = this.data[n] + (128 >> i);
                }
                ++targetPoint;
            }
        }
        if (current_mode == Mode.C1_BYTE) {
            if (targetPoint - byte_start <= 249) {
                for (i = targetPoint; i >= byte_start; --i) {
                    this.data[i + 1] = this.data[i];
                }
                this.data[byte_start] = targetPoint - byte_start;
                ++targetPoint;
            } else {
                for (i = targetPoint; i >= byte_start; --i) {
                    this.data[i + 2] = this.data[i];
                }
                this.data[byte_start] = 249 + (targetPoint - byte_start) / 250;
                this.data[byte_start + 1] = (targetPoint - byte_start) % 250;
                targetPoint += 2;
            }
        }
        if (targetPoint > 1480) {
            throw OkapiInputException.inputTooLong();
        }
        return targetPoint;
    }

    private Mode lookAheadTest(int sourcelen, int position, Mode current_mode) {
        int sp;
        double byte_count;
        double edi_count;
        double text_count;
        double c40_count;
        double ascii_count;
        if (current_mode == Mode.C1_ASCII) {
            ascii_count = 0.0;
            c40_count = 1.0;
            text_count = 1.0;
            edi_count = 1.0;
            byte_count = 2.0;
        } else {
            ascii_count = 1.0;
            c40_count = 2.0;
            text_count = 2.0;
            edi_count = 2.0;
            byte_count = 3.0;
        }
        switch (current_mode.ordinal()) {
            case 1: {
                c40_count = 0.0;
                break;
            }
            case 3: {
                text_count = 0.0;
                break;
            }
            case 5: {
                byte_count = 0.0;
                break;
            }
            case 4: {
                edi_count = 0.0;
            }
        }
        for (sp = position; sp < sourcelen && sp <= position + 8; ++sp) {
            int reduced_char = this.inputData[sp] <= 127 ? this.inputData[sp] : this.inputData[sp] - 127;
            if (this.inputData[sp] >= 48 && this.inputData[sp] <= 57) {
                ascii_count += 0.5;
            } else {
                ascii_count = this.roundUpToNextInteger(ascii_count);
                ascii_count = this.inputData[sp] > 127 ? (ascii_count += 2.0) : (ascii_count += 1.0);
            }
            boolean done = false;
            if (reduced_char == 32) {
                c40_count += 0.6666666666666666;
                done = true;
            }
            if (reduced_char >= 48 && reduced_char <= 57) {
                c40_count += 0.6666666666666666;
                done = true;
            }
            if (reduced_char >= 65 && reduced_char <= 90) {
                c40_count += 0.6666666666666666;
                done = true;
            }
            if (this.inputData[sp] > 127) {
                c40_count += 1.3333333333333333;
            }
            if (!done) {
                c40_count += 1.3333333333333333;
            }
            done = false;
            if (reduced_char == 32) {
                text_count += 0.6666666666666666;
                done = true;
            }
            if (reduced_char >= 48 && reduced_char <= 57) {
                text_count += 0.6666666666666666;
                done = true;
            }
            if (reduced_char >= 97 && reduced_char <= 122) {
                text_count += 0.6666666666666666;
                done = true;
            }
            if (this.inputData[sp] > 127) {
                text_count += 1.3333333333333333;
            }
            if (!done) {
                text_count += 1.3333333333333333;
            }
            done = false;
            if (this.inputData[sp] == 13) {
                edi_count += 0.6666666666666666;
                done = true;
            }
            if (this.inputData[sp] == 42) {
                edi_count += 0.6666666666666666;
                done = true;
            }
            if (this.inputData[sp] == 62) {
                edi_count += 0.6666666666666666;
                done = true;
            }
            if (this.inputData[sp] == 32) {
                edi_count += 0.6666666666666666;
                done = true;
            }
            if (this.inputData[sp] >= 48 && this.inputData[sp] <= 57) {
                edi_count += 0.6666666666666666;
                done = true;
            }
            if (this.inputData[sp] >= 65 && this.inputData[sp] <= 90) {
                edi_count += 0.6666666666666666;
                done = true;
            }
            if (this.inputData[sp] > 127) {
                edi_count += 4.333333333333333;
            } else if (!done) {
                edi_count += 3.3333333333333335;
            }
            if (this.inputData[sp] == -1) {
                byte_count += 3.0;
                continue;
            }
            byte_count += 1.0;
        }
        ascii_count = this.roundUpToNextInteger(ascii_count);
        c40_count = this.roundUpToNextInteger(c40_count);
        text_count = this.roundUpToNextInteger(text_count);
        edi_count = this.roundUpToNextInteger(edi_count);
        byte_count = this.roundUpToNextInteger(byte_count);
        Mode best_scheme = Mode.C1_ASCII;
        if (sp == sourcelen) {
            int best_count = (int)edi_count;
            if (text_count <= (double)best_count) {
                best_count = (int)text_count;
                best_scheme = Mode.C1_TEXT;
            }
            if (c40_count <= (double)best_count) {
                best_count = (int)c40_count;
                best_scheme = Mode.C1_C40;
            }
            if (ascii_count <= (double)best_count) {
                best_count = (int)ascii_count;
                best_scheme = Mode.C1_ASCII;
            }
            if (byte_count <= (double)best_count) {
                best_scheme = Mode.C1_BYTE;
            }
        } else {
            if (edi_count + 1.0 <= ascii_count && edi_count + 1.0 <= c40_count && edi_count + 1.0 <= byte_count && edi_count + 1.0 <= text_count) {
                best_scheme = Mode.C1_EDI;
            }
            if (c40_count + 1.0 <= ascii_count && c40_count + 1.0 <= text_count) {
                if (c40_count < edi_count) {
                    best_scheme = Mode.C1_C40;
                } else if (c40_count == edi_count) {
                    best_scheme = this.preferEdi(sourcelen, position) ? Mode.C1_EDI : Mode.C1_C40;
                }
            }
            if (text_count + 1.0 <= ascii_count && text_count + 1.0 <= c40_count && text_count + 1.0 <= byte_count && text_count + 1.0 <= edi_count) {
                best_scheme = Mode.C1_TEXT;
            }
            if (ascii_count + 1.0 <= byte_count && ascii_count + 1.0 <= c40_count && ascii_count + 1.0 <= text_count && ascii_count + 1.0 <= edi_count) {
                best_scheme = Mode.C1_ASCII;
            }
            if (byte_count + 1.0 <= ascii_count && byte_count + 1.0 <= c40_count && byte_count + 1.0 <= text_count && byte_count + 1.0 <= edi_count) {
                best_scheme = Mode.C1_BYTE;
            }
        }
        return best_scheme;
    }

    private double roundUpToNextInteger(double input) {
        double fraction = input - (double)((int)input);
        double output = fraction > 0.01 ? input - fraction + 1.0 : input;
        return output;
    }

    private boolean preferEdi(int sourcelen, int position) {
        int i = position;
        while (this.isEdiEncodable(this.inputData[position + i]) && position + i < sourcelen) {
            ++i;
        }
        if (position + i == sourcelen) {
            return false;
        }
        if (this.inputData[position + i - 1] == 13) {
            return true;
        }
        if (this.inputData[position + i - 1] == 42) {
            return true;
        }
        return this.inputData[position + i - 1] == 62;
    }

    private boolean isEdiEncodable(int input) {
        boolean result = false;
        if (input == 13) {
            result = true;
        }
        if (input == 42) {
            result = true;
        }
        if (input == 62) {
            result = true;
        }
        if (input == 32) {
            result = true;
        }
        if (input >= 48 && input <= 57) {
            result = true;
        }
        if (input >= 65 && input <= 90) {
            result = true;
        }
        return result;
    }

    private void plotCentralFinder(int start_row, int row_count, int full_rows) {
        for (int i = 0; i < row_count; ++i) {
            if (i < full_rows) {
                this.plotHorizontalBar(start_row + i * 2, 1);
                continue;
            }
            this.plotHorizontalBar(start_row + i * 2, 0);
            if (i == row_count - 1) continue;
            this.setGridModule(start_row + i * 2 + 1, 1);
            this.setGridModule(start_row + i * 2 + 1, this.symbol_width - 2);
        }
    }

    private void plotHorizontalBar(int row_no, int full) {
        if (full != 0) {
            for (int i = 0; i < this.symbol_width; ++i) {
                this.setGridModule(row_no, i);
            }
        } else {
            for (int i = 1; i < this.symbol_width - 1; ++i) {
                this.setGridModule(row_no, i);
            }
        }
    }

    private void plotVerticalBar(int column, int height, int top) {
        if (top != 0) {
            for (int i = 0; i < height; ++i) {
                this.setGridModule(i, column);
            }
        } else {
            for (int i = 0; i < height; ++i) {
                this.setGridModule(this.row_count - i - 1, column);
            }
        }
    }

    private void plotSpigot(int row_no) {
        for (int i = this.symbol_width - 1; i > 0; --i) {
            if (!this.outputGrid[row_no][i - 1]) continue;
            this.setGridModule(row_no, i);
        }
    }

    private void plotDataBlock(int start_row, int start_col, int height, int width, int row_offset, int col_offset) {
        for (int i = start_row; i < start_row + height; ++i) {
            for (int j = start_col; j < start_col + width; ++j) {
                if (this.datagrid[i][j] != 49) continue;
                this.setGridModule(i + row_offset, j + col_offset);
            }
        }
    }

    private void setGridModule(int row, int column) {
        this.outputGrid[row][column] = true;
    }

    private void resetGridModule(int row, int column) {
        this.outputGrid[row][column] = false;
    }

    private static int getSize(Version version) {
        switch (version.ordinal()) {
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return 4;
            }
            case 5: {
                return 5;
            }
            case 6: {
                return 6;
            }
            case 7: {
                return 7;
            }
            case 8: {
                return 8;
            }
        }
        return 0;
    }

    public static enum Version {
        NONE,
        A,
        B,
        C,
        D,
        E,
        F,
        G,
        H,
        S,
        T;

    }

    private static enum Mode {
        C1_ASCII,
        C1_C40,
        C1_DECIMAL,
        C1_TEXT,
        C1_EDI,
        C1_BYTE;

    }
}

