/*
 * Decompiled with CFR 0.152.
 */
package uk.org.okapibarcode.backend;

import uk.org.okapibarcode.backend.HumanReadableLocation;
import uk.org.okapibarcode.backend.OkapiInputException;
import uk.org.okapibarcode.backend.Symbol;
import uk.org.okapibarcode.graphics.Rectangle;
import uk.org.okapibarcode.graphics.TextBox;

public class Code2Of5
extends Symbol {
    private static final String[] C25_MATRIX_TABLE = new String[]{"113311", "311131", "131131", "331111", "113131", "313111", "133111", "111331", "311311", "131311"};
    private static final String[] C25_INDUSTRIAL_TABLE = new String[]{"1111313111", "3111111131", "1131111131", "3131111111", "1111311131", "3111311111", "1131311111", "1111113131", "3111113111", "1131113111"};
    private static final String[] C25_INTERLEAVED_TABLE = new String[]{"11331", "31113", "13113", "33111", "11313", "31311", "13311", "11133", "31131", "13131"};
    private ToFMode mode;
    private double moduleWidthRatio = 3.0;

    public Code2Of5() {
        this(ToFMode.MATRIX);
    }

    public Code2Of5(ToFMode mode) {
        this.mode = mode;
    }

    public void setMode(ToFMode mode) {
        this.mode = mode;
    }

    public ToFMode getMode() {
        return this.mode;
    }

    public void setModuleWidthRatio(double moduleWidthRatio) {
        this.moduleWidthRatio = moduleWidthRatio;
    }

    public double getModuleWidthRatio() {
        return this.moduleWidthRatio;
    }

    @Override
    protected void encode() {
        switch (this.mode.ordinal()) {
            case 0: {
                this.dataMatrix();
                break;
            }
            case 1: {
                this.industrial();
                break;
            }
            case 2: {
                this.iata();
                break;
            }
            case 4: {
                this.interleaved(false);
                break;
            }
            case 5: {
                this.interleaved(true);
                break;
            }
            case 3: {
                this.dataLogic();
                break;
            }
            case 6: {
                this.itf14();
                break;
            }
            case 7: {
                this.deutschePostLeitcode();
                break;
            }
            case 8: {
                this.deutschePostIdentcode();
            }
        }
    }

    private void dataMatrix() {
        if (!this.content.matches("[0-9]*")) {
            throw OkapiInputException.invalidCharactersInInput();
        }
        String dest = "311111";
        for (int i = 0; i < this.content.length(); ++i) {
            dest = dest + C25_MATRIX_TABLE[Character.getNumericValue(this.content.charAt(i))];
        }
        dest = dest + "31111";
        this.readable = this.content;
        this.pattern = new String[]{dest};
        this.row_count = 1;
        this.row_height = new int[]{-1};
    }

    private void industrial() {
        if (!this.content.matches("[0-9]*")) {
            throw OkapiInputException.invalidCharactersInInput();
        }
        String dest = "313111";
        for (int i = 0; i < this.content.length(); ++i) {
            dest = dest + C25_INDUSTRIAL_TABLE[Character.getNumericValue(this.content.charAt(i))];
        }
        dest = dest + "31113";
        this.readable = this.content;
        this.pattern = new String[]{dest};
        this.row_count = 1;
        this.row_height = new int[]{-1};
    }

    private void iata() {
        if (!this.content.matches("[0-9]*")) {
            throw OkapiInputException.invalidCharactersInInput();
        }
        String dest = "1111";
        for (int i = 0; i < this.content.length(); ++i) {
            dest = dest + C25_INDUSTRIAL_TABLE[Character.getNumericValue(this.content.charAt(i))];
        }
        dest = dest + "311";
        this.readable = this.content;
        this.pattern = new String[]{dest};
        this.row_count = 1;
        this.row_height = new int[]{-1};
    }

    private void dataLogic() {
        if (!this.content.matches("[0-9]*")) {
            throw OkapiInputException.invalidCharactersInInput();
        }
        String dest = "1111";
        for (int i = 0; i < this.content.length(); ++i) {
            dest = dest + C25_MATRIX_TABLE[Character.getNumericValue(this.content.charAt(i))];
        }
        dest = dest + "311";
        this.readable = this.content;
        this.pattern = new String[]{dest};
        this.row_count = 1;
        this.row_height = new int[]{-1};
    }

    private void interleaved(boolean addCheckDigit) {
        this.readable = this.content;
        if (!this.readable.matches("[0-9]*")) {
            throw OkapiInputException.invalidCharactersInInput();
        }
        if (addCheckDigit) {
            char checkDigit = Code2Of5.checkDigit(this.readable, 1, 3);
            this.readable = this.readable + checkDigit;
            this.infoLine("Check Digit: " + checkDigit);
        }
        if ((this.readable.length() & 1) != 0) {
            this.readable = "0" + this.readable;
        }
        String dest = "1111";
        for (int i = 0; i < this.readable.length(); i += 2) {
            dest = dest + this.interlace(i, i + 1);
        }
        dest = dest + "311";
        this.pattern = new String[]{dest};
        this.row_count = 1;
        this.row_height = new int[]{-1};
    }

    private String interlace(int x, int y) {
        char a = this.readable.charAt(x);
        char b = this.readable.charAt(y);
        String one = C25_INTERLEAVED_TABLE[Character.getNumericValue(a)];
        String two = C25_INTERLEAVED_TABLE[Character.getNumericValue(b)];
        StringBuilder f = new StringBuilder(10);
        for (int i = 0; i < 5; ++i) {
            f.append(one.charAt(i));
            f.append(two.charAt(i));
        }
        return f.toString();
    }

    private void itf14() {
        int i;
        int input_length = this.content.length();
        if (!this.content.matches("[0-9]*")) {
            throw OkapiInputException.invalidCharactersInInput();
        }
        if (input_length > 13) {
            throw OkapiInputException.inputTooLong();
        }
        this.readable = "";
        for (i = input_length; i < 13; ++i) {
            this.readable = this.readable + "0";
        }
        this.readable = this.readable + this.content;
        char checkDigit = Code2Of5.checkDigit(this.readable, 1, 3);
        this.readable = this.readable + checkDigit;
        this.infoLine("Check Digit: " + checkDigit);
        String dest = "1111";
        for (i = 0; i < this.readable.length(); i += 2) {
            dest = dest + this.interlace(i, i + 1);
        }
        dest = dest + "311";
        this.pattern = new String[]{dest};
        this.row_count = 1;
        this.row_height = new int[]{-1};
    }

    private void deutschePostLeitcode() {
        int i;
        int input_length = this.content.length();
        if (!this.content.matches("[0-9]*")) {
            throw OkapiInputException.invalidCharactersInInput();
        }
        if (input_length > 13) {
            throw OkapiInputException.inputTooLong();
        }
        this.readable = "";
        for (i = input_length; i < 13; ++i) {
            this.readable = this.readable + "0";
        }
        this.readable = this.readable + this.content;
        char checkDigit = Code2Of5.checkDigit(this.readable, 9, 4);
        this.readable = this.readable + checkDigit;
        this.infoLine("Check digit: " + checkDigit);
        String dest = "1111";
        for (i = 0; i < this.readable.length(); i += 2) {
            dest = dest + this.interlace(i, i + 1);
        }
        dest = dest + "311";
        this.pattern = new String[]{dest};
        this.row_count = 1;
        this.row_height = new int[]{-1};
    }

    private void deutschePostIdentcode() {
        int i;
        int input_length = this.content.length();
        if (!this.content.matches("[0-9]*")) {
            throw OkapiInputException.invalidCharactersInInput();
        }
        if (input_length > 11) {
            throw OkapiInputException.inputTooLong();
        }
        this.readable = "";
        for (i = input_length; i < 11; ++i) {
            this.readable = this.readable + "0";
        }
        this.readable = this.readable + this.content;
        char checkDigit = Code2Of5.checkDigit(this.readable, 9, 4);
        this.readable = this.readable + checkDigit;
        this.infoLine("Check Digit: " + checkDigit);
        String dest = "1111";
        for (i = 0; i < this.readable.length(); i += 2) {
            dest = dest + this.interlace(i, i + 1);
        }
        dest = dest + "311";
        this.pattern = new String[]{dest};
        this.row_count = 1;
        this.row_height = new int[]{-1};
    }

    private static char checkDigit(String s, int multiplier1, int multiplier2) {
        int count = 0;
        for (int i = s.length() - 1; i >= 0; --i) {
            if ((i & 1) != 0) {
                count += multiplier1 * (s.charAt(i) - 48);
                continue;
            }
            count += multiplier2 * (s.charAt(i) - 48);
        }
        return (char)((10 - count % 10) % 10 + 48);
    }

    @Override
    protected void plotSymbol() {
        this.resetPlotElements();
        int baseY = this.humanReadableLocation == HumanReadableLocation.TOP ? this.getTheoreticalHumanReadableHeight() : 0;
        double x = 0.0;
        int y = baseY;
        int h = 0;
        boolean black = true;
        int offset = 0;
        if (this.mode == ToFMode.ITF14) {
            offset = 20;
        }
        for (int xBlock = 0; xBlock < this.pattern[0].length(); ++xBlock) {
            char c = this.pattern[0].charAt(xBlock);
            double w = this.getModuleWidth(c - 48) * (double)this.moduleWidth;
            if (black) {
                h = this.row_height[0] == -1 ? this.default_height : this.row_height[0];
                if (w != 0.0 && h != 0) {
                    Rectangle rect = new Rectangle(x + (double)offset, y, w, h);
                    this.rectangles.add(rect);
                }
                this.symbol_width = (int)Math.ceil(x + w + (double)(2 * offset));
            }
            black = !black;
            x += w;
        }
        this.symbol_height = h;
        if (this.mode == ToFMode.ITF14) {
            Rectangle topBar = new Rectangle(0.0, baseY, this.symbol_width, 4.0);
            Rectangle bottomBar = new Rectangle(0.0, baseY + this.symbol_height - 4, this.symbol_width, 4.0);
            Rectangle leftBar = new Rectangle(0.0, baseY, 4.0, this.symbol_height);
            Rectangle rightBar = new Rectangle(this.symbol_width - 4, baseY, 4.0, this.symbol_height);
            this.rectangles.add(topBar);
            this.rectangles.add(bottomBar);
            this.rectangles.add(leftBar);
            this.rectangles.add(rightBar);
        }
        if (this.humanReadableLocation != HumanReadableLocation.NONE && !this.readable.isEmpty()) {
            double baseline = this.humanReadableLocation == HumanReadableLocation.TOP ? (double)this.fontSize : (double)(this.symbol_height + this.fontSize);
            this.texts.add(new TextBox(0.0, baseline, this.symbol_width, this.readable, this.humanReadableAlignment));
        }
    }

    @Override
    protected double getModuleWidth(int originalWidth) {
        if (originalWidth == 1) {
            return 1.0;
        }
        return this.moduleWidthRatio;
    }

    public static enum ToFMode {
        MATRIX,
        INDUSTRIAL,
        IATA,
        DATA_LOGIC,
        INTERLEAVED,
        INTERLEAVED_WITH_CHECK_DIGIT,
        ITF14,
        DP_LEITCODE,
        DP_IDENTCODE;

    }
}

