/*
 * Decompiled with CFR 0.152.
 */
package uk.org.okapibarcode.backend;

import uk.org.okapibarcode.backend.OkapiInputException;
import uk.org.okapibarcode.backend.Symbol;

public class ChannelCode
extends Symbol {
    private int preferredNumberOfChannels = 3;
    private int[] space = new int[11];
    private int[] bar = new int[11];
    private int currentValue;
    private int targetValue;

    public void setPreferredNumberOfChannels(int channels) {
        if (channels < 3 || channels > 8) {
            throw new IllegalArgumentException("Invalid number of channels: " + channels);
        }
        this.preferredNumberOfChannels = channels;
    }

    public int getPreferredNumberOfChannels() {
        return this.preferredNumberOfChannels;
    }

    @Override
    protected void encode() {
        if (this.content.length() > 7) {
            throw OkapiInputException.inputTooLong();
        }
        if (!this.content.matches("[0-9]+")) {
            throw OkapiInputException.invalidCharactersInInput();
        }
        int channels = this.preferredNumberOfChannels;
        this.targetValue = Integer.parseInt(this.content);
        switch (channels) {
            case 3: {
                if (this.targetValue > 26) {
                    ++channels;
                }
            }
            case 4: {
                if (this.targetValue > 292) {
                    ++channels;
                }
            }
            case 5: {
                if (this.targetValue > 3493) {
                    ++channels;
                }
            }
            case 6: {
                if (this.targetValue > 44072) {
                    ++channels;
                }
            }
            case 7: {
                if (this.targetValue > 576688) {
                    ++channels;
                }
            }
            case 8: {
                if (this.targetValue <= 7742862) break;
                ++channels;
            }
        }
        if (channels == 9) {
            throw new OkapiInputException("Value out of range");
        }
        this.infoLine("Channels Used: " + channels);
        for (int i = 0; i < 11; ++i) {
            this.bar[i] = 0;
            this.space[i] = 0;
        }
        this.bar[2] = 1;
        this.space[2] = 1;
        this.bar[1] = 1;
        this.space[1] = 1;
        this.bar[0] = 1;
        this.currentValue = 0;
        this.pattern = new String[1];
        this.nextSpace(channels, 3, channels, channels);
        StringBuilder text = new StringBuilder();
        int leadingZeroCount = channels - 1 - this.content.length();
        for (int i = 0; i < leadingZeroCount; ++i) {
            text.append('0');
        }
        text.append(this.content);
        this.readable = text.toString();
        this.row_count = 1;
        this.row_height = new int[]{-1};
    }

    private void nextSpace(int channels, int i, int maxSpace, int maxBar) {
        int s;
        int n = s = i < channels + 2 ? 1 : maxSpace;
        while (s <= maxSpace) {
            this.space[i] = s;
            this.nextBar(channels, i, maxBar, maxSpace + 1 - s);
            ++s;
        }
    }

    private void nextBar(int channels, int i, int maxBar, int maxSpace) {
        int b;
        int n = b = this.space[i] + this.bar[i - 1] + this.space[i - 1] + this.bar[i - 2] > 4 ? 1 : 2;
        if (i < channels + 2) {
            while (b <= maxBar) {
                this.bar[i] = b;
                this.nextSpace(channels, i + 1, maxSpace, maxBar + 1 - b);
                ++b;
            }
        } else if (b <= maxBar) {
            this.bar[i] = maxBar;
            this.checkIfDone();
            ++this.currentValue;
        }
    }

    private void checkIfDone() {
        if (this.currentValue == this.targetValue) {
            StringBuilder sb = new StringBuilder();
            sb.append("11110");
            for (int i = 0; i < 11; ++i) {
                sb.append((char)(this.space[i] + 48));
                sb.append((char)(this.bar[i] + 48));
            }
            this.pattern[0] = sb.toString();
        }
    }
}

