/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.lib.update.signatures;

import ch.dvbern.lib.cryptutil.DigestEngine;
import ch.dvbern.lib.cryptutil.SignatureEngine;
import ch.dvbern.lib.cryptutil.SignatureFailedException;
import java.io.IOException;
import java.io.InputStream;
import java.security.DigestInputStream;
import java.security.PublicKey;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;

public enum SignMethod {
    SHA256withRSA("SHA-256", is -> new DigestInputStream((InputStream)is, new DigestEngine().configureSHA256(null)), (referenceSignature, publicKey, is) -> new SignatureEngine().verifySHA256RSA(referenceSignature, publicKey, is, null)),
    SHA512withRSA("SHA-512", is -> new DigestInputStream((InputStream)is, new DigestEngine().configureSHA512(null)), (referenceSignature, publicKey, is) -> new SignatureEngine().verifySHA512RSA(referenceSignature, publicKey, is, null));

    @Nonnull
    private final String algorithmName;
    @Nonnull
    private final Function<InputStream, DigestInputStream> digestWrapper;
    @Nonnull
    private final Verifier verifier;

    private SignMethod(String algorithmName, Function<InputStream, DigestInputStream> digestWrapper, Verifier verifier) {
        this.algorithmName = Objects.requireNonNull(algorithmName);
        this.digestWrapper = Objects.requireNonNull(digestWrapper);
        this.verifier = Objects.requireNonNull(verifier);
    }

    @Nonnull
    public String getAlgorithmName() {
        return this.algorithmName;
    }

    @Nonnull
    public DigestInputStream wrapForDigest(@Nonnull InputStream inputStream) {
        return this.digestWrapper.apply(inputStream);
    }

    public boolean isSignatureValid(@Nonnull byte[] referenceSignature, @Nonnull PublicKey publicKey, @Nonnull InputStream dataToVerify) throws SignatureFailedException, IOException {
        return this.verifier.verify(referenceSignature, publicKey, dataToVerify);
    }

    @FunctionalInterface
    private static interface Verifier {
        public boolean verify(@Nonnull byte[] var1, @Nonnull PublicKey var2, @Nonnull InputStream var3) throws IOException, SignatureFailedException;
    }
}

