/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.lib.update.signatures;

import ch.dvbern.lib.update.signatures.JDKTrustManagerProvider;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class PinnedCertificateTrustManagerProvider
extends JDKTrustManagerProvider {
    @Nonnull
    private final ArrayList<X509Certificate> pinnedCertificates;

    public PinnedCertificateTrustManagerProvider(@Nonnull Collection<X509Certificate> pinnedCertificates) {
        this.pinnedCertificates = new ArrayList<X509Certificate>(pinnedCertificates);
    }

    @Override
    @Nonnull
    public TrustManager[] getTrustManagers() {
        TrustManager[] trustManagers = super.getTrustManagers();
        ArrayList<PinnedCertTrustManager> filteredManagers = new ArrayList<PinnedCertTrustManager>(trustManagers.length);
        for (TrustManager trustManager : trustManagers) {
            if (!(trustManager instanceof X509TrustManager)) continue;
            X509TrustManager x509TrustManager = (X509TrustManager)trustManager;
            filteredManagers.add(new PinnedCertTrustManager(x509TrustManager, this.pinnedCertificates));
        }
        return filteredManagers.toArray(new TrustManager[filteredManagers.size()]);
    }

    private static final class PinnedCertTrustManager
    implements X509TrustManager {
        @Nonnull
        private final X509TrustManager trustManager;
        @Nonnull
        private final X509Certificate[] pinnedCertificates;

        public PinnedCertTrustManager(@Nonnull X509TrustManager trustManager, @Nonnull Collection<X509Certificate> pinnedCertificates) {
            this.trustManager = Objects.requireNonNull(trustManager);
            this.pinnedCertificates = Objects.requireNonNull(pinnedCertificates).toArray(new X509Certificate[pinnedCertificates.size()]);
        }

        @Override
        public void checkClientTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
            throw new UnsupportedOperationException("client validation not implemented");
        }

        @Override
        public void checkServerTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
            for (X509Certificate certificate : x509Certificates) {
                for (X509Certificate pinnedCertificate : this.pinnedCertificates) {
                    boolean same = Arrays.equals(pinnedCertificate.getPublicKey().getEncoded(), certificate.getPublicKey().getEncoded());
                    if (!same) continue;
                    return;
                }
            }
            throw new CertificateException("No pinned certificate found");
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return this.pinnedCertificates;
        }
    }
}

