/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.lib.update.elevate.cocoa;

import ch.dvbern.lib.update.elevate.ElevatedCommandBuilder;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class CocoaSudoCommandBuilder
implements ElevatedCommandBuilder {
    private final String prompt;
    private final String icon;
    private final File helperProgram;

    public CocoaSudoCommandBuilder(String prompt, String icon, File helperProgram) {
        this.prompt = prompt;
        this.icon = icon;
        this.helperProgram = helperProgram;
    }

    @Override
    public ProcessBuilder buildCommand(String ... commandAndArgs) {
        ArrayList<String> helperCommand = new ArrayList<String>(3);
        helperCommand.add(this.helperProgram.getAbsolutePath());
        if (this.prompt != null && !this.prompt.trim().isEmpty()) {
            helperCommand.add("--prompt=" + this.prompt);
        }
        if (this.icon != null && !this.icon.trim().isEmpty()) {
            helperCommand.add("--icon=" + this.icon);
        }
        helperCommand.addAll(List.of(commandAndArgs));
        return new ProcessBuilder(helperCommand);
    }
}

