/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.lib.update.elevate;

import ch.dvbern.lib.update.IOUtils;
import ch.dvbern.lib.update.elevate.ElevatedCommandBuilder;
import ch.dvbern.lib.update.elevate.ElevationFailedException;
import ch.dvbern.lib.update.elevate.IPrivilegesElevator;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.MissingResourceException;
import java.util.logging.Logger;

public abstract class PriviligesElevatorBase
implements IPrivilegesElevator {
    private static final Logger LOG = Logger.getLogger(PriviligesElevatorBase.class.getName());

    @Override
    public ProcessBuilder createElevatedProcessBuilder(String[] command, String prompt, String icon) throws ElevationFailedException {
        if (command == null) {
            throw new NullPointerException("command cannot be null");
        }
        if (command.length == 0) {
            throw new IllegalArgumentException("command must be non-empty");
        }
        for (String commandToken : command) {
            if (commandToken != null) continue;
            throw new NullPointerException("invalid null token in command: " + Arrays.toString(command));
        }
        ElevatedCommandBuilder commandBuilder = this.elevatedCommandBuilder(prompt, icon);
        ProcessBuilder pb = commandBuilder.buildCommand(command);
        return pb;
    }

    @Override
    public int getPriority() {
        return 0;
    }

    protected abstract ElevatedCommandBuilder elevatedCommandBuilder(String var1, String var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final File extractHelperResource(String name) throws IOException {
        File helperResource;
        if (name == null) {
            throw new NullPointerException("name cannot be null");
        }
        InputStream helperResourceStream = this.getClass().getResourceAsStream(name);
        if (helperResourceStream == null) {
            throw new MissingResourceException("No resource found with this name", this.getClass().getName(), name);
        }
        FileOutputStream exeOut = null;
        try {
            helperResource = File.createTempFile("tmp_", name);
            helperResource.deleteOnExit();
            exeOut = new FileOutputStream(helperResource);
            IOUtils.copy(helperResourceStream, exeOut);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(exeOut);
            IOUtils.closeQuietly(helperResourceStream);
            throw throwable;
        }
        IOUtils.closeQuietly(exeOut);
        IOUtils.closeQuietly(helperResourceStream);
        return helperResource;
    }
}

