/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.lib.update.elevate;

import ch.dvbern.lib.update.elevate.ElevatedCommandBuilder;
import java.util.Arrays;
import java.util.stream.Collectors;

public class PowershellElevatedCommandBuilder
implements ElevatedCommandBuilder {
    @Override
    public ProcessBuilder buildCommand(String ... commandAndArgs) {
        if (commandAndArgs == null || commandAndArgs.length == 0) {
            throw new IllegalArgumentException("Provide at least an executable");
        }
        String executable = this.quote(commandAndArgs[0]);
        String executableArgs = this.formatAsArgsArray(Arrays.copyOfRange(commandAndArgs, 1, commandAndArgs.length));
        String appDir = System.getProperty("user.dir");
        System.out.println("!!!!!!! workdir: " + appDir);
        String[] command = new String[]{"powershell.exe", "-Command", String.format("\"Start-Process -WorkingDirectory %s -Verb runAs -Wait -FilePath %s -ArgumentList @(%s)\"", this.quote(appDir), executable, executableArgs)};
        return new ProcessBuilder(command);
    }

    private String formatAsArgsArray(String[] arguments) {
        String commaSeparatedAndQuoted = Arrays.stream(arguments).filter(arg -> !arg.startsWith("--targetDir")).filter(arg -> !arg.startsWith("--userHome")).map(this::quote).collect(Collectors.joining(", "));
        return commaSeparatedAndQuoted;
    }

    private String quote(String text) {
        return String.format("'%s'", text);
    }
}

