/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.lib.pdfforms;

import ch.dvbern.lib.pdfforms.PdfField;
import com.lowagie.text.pdf.AcroFields;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.XfaForm;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PdfFormFieldParser {
    private static final Logger LOG = LoggerFactory.getLogger(PdfFormFieldParser.class);
    private static final Pattern ACROFIELD_ID_PATTERN = Pattern.compile("^(topmostSubform\\[\\d+]\\.Page\\d+\\[\\d+]\\.)|(\\[\\d+])$");
    private static final Pattern BACKSLASHES_PATTERN = Pattern.compile("\\\\");

    public static @NonNull String unescapePdfFormItemKey(@NonNull String key) {
        Objects.requireNonNull(key);
        return BACKSLASHES_PATTERN.matcher(key).replaceAll("");
    }

    public @NonNull NavigableSet<PdfField> parsePdfFieldNames(@NonNull File pdfFile) throws FileNotFoundException, IOException {
        try (BufferedInputStream is = new BufferedInputStream(new FileInputStream(pdfFile));){
            NavigableSet<PdfField> navigableSet = this.parsePdfFieldNames(is);
            return navigableSet;
        }
    }

    public @NonNull NavigableSet<PdfField> parsePdfFieldNames(@NonNull URL pdfUrl) throws IOException {
        Objects.requireNonNull(pdfUrl);
        try (InputStream is = pdfUrl.openConnection().getInputStream();){
            NavigableSet<PdfField> navigableSet = this.parsePdfFieldNames(is);
            return navigableSet;
        }
    }

    public @NonNull NavigableSet<PdfField> parsePdfFieldNames(@NonNull InputStream pdfInputStream) throws IOException {
        AcroFields acroFields = new PdfReader(pdfInputStream).getAcroFields();
        return this.parsePdfFieldNames(acroFields);
    }

    public @NonNull NavigableSet<PdfField> parsePdfFieldNames(@NonNull AcroFields acroFields) {
        TreeSet<PdfField> result = new TreeSet<PdfField>();
        HashMap fields = acroFields.getFields();
        for (Object object : fields.keySet()) {
            result.add(new PdfField(PdfField.FieldType.ACROFIELD, PdfFormFieldParser.prettyprintAcroFieldName(PdfFormFieldParser.unescapePdfFormItemKey((String)object)), object.toString()));
        }
        XfaForm xfa = acroFields.getXfa();
        int fieldCount = 0;
        int namedFieldCount = 0;
        if (xfa.isXfaPresent()) {
            Document domDoc = xfa.getDomDocument();
            NodeList nodeList = domDoc.getElementsByTagName("field");
            for (int i = 0; i < nodeList.getLength(); ++i) {
                String fieldName;
                ++fieldCount;
                Node node = nodeList.item(i);
                Node fieldNameNode = node.getAttributes().getNamedItem("name");
                if (fieldNameNode == null || (fieldName = fieldNameNode.getNodeValue()) == null || fieldName.isEmpty()) continue;
                ++namedFieldCount;
                result.add(new PdfField(PdfField.FieldType.XFA_FIELD, fieldName, node.getTextContent()));
            }
        }
        LOG.debug("XFA-Named-Nodes: {}/{}", (Object)namedFieldCount, (Object)fieldCount);
        return result;
    }

    public static @NonNull String prettyprintAcroFieldName(@NonNull String key) {
        Objects.requireNonNull(key);
        return ACROFIELD_ID_PATTERN.matcher(key).replaceAll("");
    }
}

