/*
 * Decompiled with CFR 0.152.
 */
package com.github.markusbernhardt.proxy.selector.pac;

import com.github.markusbernhardt.proxy.selector.pac.PacProxySelector;
import com.github.markusbernhardt.proxy.selector.pac.PacScriptSource;
import java.net.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;

public class SafePacProxySelector
extends PacProxySelector {
    public SafePacProxySelector(PacScriptSource pacSource) {
        super(pacSource);
    }

    @Override
    public List<Proxy> select(URI uri) {
        URI safeUri = SafePacProxySelector.sanitizeURI(uri);
        return super.select(safeUri);
    }

    public static URI sanitizeURI(URI uri) {
        try {
            if ("https".equals(uri.getScheme()) || "wss".equals(uri.getScheme())) {
                return new URI(uri.getScheme(), null, uri.getHost(), uri.getPort(), "/", null, null);
            }
            return new URI(uri.getScheme(), null, uri.getHost(), uri.getPort(), uri.getPath(), uri.getQuery(), null);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }
}

