/*
 * Decompiled with CFR 0.152.
 */
package com.gface.custom;

import ch.dvbern.tax.common.presentation.cd.util.SWTDebugHelper;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.swt.SWT;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleControlListener;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.accessibility.AccessibleTextAdapter;
import org.eclipse.swt.accessibility.AccessibleTextEvent;
import org.eclipse.swt.accessibility.AccessibleTextListener;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.SWTEventListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TypedListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SearchBox
extends Composite {
    private static final Logger LOG = LoggerFactory.getLogger(SearchBox.class);
    private static final boolean isWindows = System.getProperty("os.name").toLowerCase().startsWith("win");
    private static final boolean isLinux = System.getProperty("os.name").toLowerCase().startsWith("linux");
    private Text text;
    private List list;
    private int visibleItemCount = 10;
    private Shell popup;
    private Button arrow;
    private boolean hasFocus;
    private Listener listener;
    private Listener filter;
    private Color foreground;
    private Color background;
    private String[] allItems;
    private String[] listItems;
    private String[] displayedItems;
    private Font font;
    private String selected;
    private int border;
    private Control[] tabList;

    public SearchBox(Composite parent, int style) {
        super(parent, SearchBox.checkStyle(style));
        int[] arrowEvents;
        int[] textEvents;
        int[] comboEvents;
        int textStyle = 4;
        if ((style & 0x800000) != 0) {
            textStyle |= 0x800000;
        }
        if (!isWindows && (style & 0x800) != 0) {
            textStyle |= 0x800;
            this.border = 1;
        }
        this.text = new Text((Composite)this, textStyle);
        this.tabList = new Control[]{this.text};
        int arrowStyle = 1028;
        if ((style & 0x800000) != 0) {
            arrowStyle |= 0x800000;
        }
        this.arrow = new Button(this, arrowStyle){

            protected void checkSubclass() {
            }

            public boolean setFocus() {
                return false;
            }

            public boolean forceFocus() {
                return false;
            }
        };
        this.listener = new Listener(){

            public void handleEvent(Event event) {
                if (SearchBox.this.popup == event.widget) {
                    SearchBox.this.popupEvent(event);
                    return;
                }
                if (SearchBox.this.text == event.widget) {
                    SearchBox.this.textEvent(event);
                    return;
                }
                if (SearchBox.this.list == event.widget) {
                    SearchBox.this.listEvent(event);
                    return;
                }
                if (SearchBox.this.arrow == event.widget) {
                    SearchBox.this.arrowEvent(event);
                    return;
                }
                if (SearchBox.this == event.widget) {
                    SearchBox.this.comboEvent(event);
                    return;
                }
                if (SearchBox.this.getShell() == event.widget) {
                    SearchBox.this.shellEvent(event);
                }
            }
        };
        this.filter = new Listener(){

            public void handleEvent(Event event) {
                Control focusControl;
                if (event.type == 15 && ((focusControl = SearchBox.this.getDisplay().getFocusControl()) == SearchBox.this.arrow || focusControl == SearchBox.this.list || focusControl == SearchBox.this.text)) {
                    return;
                }
                if (event.type == 3 && (event.widget == SearchBox.this.arrow || event.widget == SearchBox.this.list || event.widget == SearchBox.this.text)) {
                    return;
                }
                Shell shell = ((Control)event.widget).getShell();
                if (shell == SearchBox.this.getShell()) {
                    SearchBox.this.handleFocus(16);
                }
            }
        };
        for (int comboEvent : comboEvents = new int[]{12, 10, 11}) {
            this.addListener(comboEvent, this.listener);
        }
        for (int textEvent : textEvents = new int[]{1, 2, 15, 16, 8}) {
            this.text.addListener(textEvent, this.listener);
        }
        for (int arrowEvent : arrowEvents = new int[]{13, 15}) {
            this.arrow.addListener(arrowEvent, this.listener);
        }
        this.createPopup(null, -1);
        this.initAccessible();
    }

    public void addFocusListener(FocusListener arg0) {
        if (this.text != null) {
            this.text.addFocusListener(arg0);
        } else {
            super.addFocusListener(arg0);
        }
    }

    public void removeFocusListener(FocusListener arg0) {
        if (this.text != null) {
            this.text.removeFocusListener(arg0);
        } else {
            super.removeFocusListener(arg0);
        }
    }

    public void addMouseListener(MouseListener arg0) {
        this.text.addMouseListener(arg0);
    }

    public void removeMouseListener(MouseListener arg0) {
        this.text.removeMouseListener(arg0);
    }

    public Control[] getTabList() {
        return this.tabList;
    }

    private static int checkStyle(int style) {
        int styleMask = 0x6800008;
        if (isWindows) {
            styleMask |= 0x800;
        }
        return style & styleMask;
    }

    public void add(String string) {
        this.checkWidget();
        if (string == null) {
            SWT.error((int)4);
        }
        this.list.add(string);
    }

    public void add(String string, int index) {
        this.checkWidget();
        if (string == null) {
            SWT.error((int)4);
        }
        this.list.add(string, index);
    }

    public void addModifyListener(ModifyListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error((int)4);
        }
        TypedListener typedListener = new TypedListener((SWTEventListener)listener);
        this.addListener(24, (Listener)typedListener);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error((int)4);
        }
        TypedListener typedListener = new TypedListener((SWTEventListener)listener);
        this.addListener(13, (Listener)typedListener);
        this.addListener(14, (Listener)typedListener);
    }

    void arrowEvent(Event event) {
        switch (event.type) {
            case 15: {
                this.handleFocus(15);
                break;
            }
            case 13: {
                if (!this.isDropped()) {
                    this.showAllItems();
                }
                this.dropDown(!this.isDropped());
                if (!this.isDropped()) break;
                this.list.setFocus();
            }
        }
    }

    public void clearSelection() {
        this.checkWidget();
        this.text.clearSelection();
        this.list.deselectAll();
    }

    void comboEvent(Event event) {
        LOG.trace("SearchBox.comboEvent(" + SWTDebugHelper.eventTypeToText(event.type) + ")");
        switch (event.type) {
            case 12: {
                if (this.popup != null && !this.popup.isDisposed()) {
                    this.list.removeListener(12, this.listener);
                    this.popup.dispose();
                }
                Shell shell = this.getShell();
                shell.removeListener(27, this.listener);
                Display display = this.getDisplay();
                display.removeFilter(15, this.filter);
                display.removeFilter(3, this.filter);
                this.popup = null;
                this.text = null;
                this.list = null;
                this.arrow = null;
                break;
            }
            case 10: {
                this.dropDown(false);
                break;
            }
            case 11: {
                this.internalLayout(false);
            }
        }
    }

    void shellEvent(Event event) {
        LOG.debug("SearchBox.shellEvent(" + SWTDebugHelper.eventTypeToText(event.type) + ")");
        switch (event.type) {
            case 10: {
                this.dropDown(false);
                break;
            }
            case 11: {
                this.internalLayout(false);
                break;
            }
            case 27: {
                break;
            }
            default: {
                this.handleFocus(16);
            }
        }
    }

    public int getBorderWidth() {
        return super.getBorderWidth() + this.border;
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        int width = 0;
        int height = 0;
        String[] items = this.list.getItems();
        int textWidth = 0;
        GC gc = new GC((Drawable)this.text);
        int spacer = gc.stringExtent((String)" ").x;
        for (String item : items) {
            textWidth = Math.max(gc.stringExtent((String)item).x, textWidth);
        }
        gc.dispose();
        Point textSize = this.text.computeSize(-1, -1, changed);
        Point arrowSize = this.arrow.computeSize(-1, -1, changed);
        Point listSize = this.list.computeSize(wHint, -1, changed);
        int borderWidth = this.getBorderWidth();
        height = Math.max(hHint, Math.max(textSize.y, arrowSize.y) + 2 * borderWidth);
        width = Math.max(wHint, Math.max(textWidth + 2 * spacer + arrowSize.x + 2 * borderWidth, listSize.x));
        return new Point(width, height);
    }

    void createPopup(String[] items, int selectionIndex) {
        int[] listEvents;
        int[] popupEvents;
        this.popup = new Shell(this.getShell(), 8);
        int style = this.getStyle();
        int listStyle = 516;
        if ((style & 0x800000) != 0) {
            listStyle |= 0x800000;
        }
        if ((style & 0x4000000) != 0) {
            listStyle |= 0x4000000;
        }
        if ((style & 0x2000000) != 0) {
            listStyle |= 0x2000000;
        }
        this.list = new List((Composite)this.popup, listStyle);
        if (this.font != null) {
            this.list.setFont(this.font);
        }
        if (this.foreground != null) {
            this.list.setForeground(this.foreground);
        }
        if (this.background != null) {
            this.list.setBackground(this.background);
        }
        for (int popupEvent : popupEvents = new int[]{21, 9, 27}) {
            this.popup.addListener(popupEvent, this.listener);
        }
        for (int listEvent : listEvents = new int[]{4, 13, 31, 1, 2, 15, 12}) {
            this.list.addListener(listEvent, this.listener);
        }
        if (this.allItems != null) {
            this.showFilteredItems();
        }
        if (selectionIndex != -1) {
            this.list.setSelection(selectionIndex);
        }
    }

    public void deselect(int index) {
        this.checkWidget();
        this.list.deselect(index);
    }

    public void deselectAll() {
        this.checkWidget();
        this.list.deselectAll();
    }

    void dropDown(boolean drop) {
        if (drop == this.isDropped()) {
            return;
        }
        if (!drop) {
            this.popup.setVisible(false);
            this.getShell().removeListener(10, this.listener);
            if (!this.isDisposed() && this.selected != null && !this.selected.equals(this.text.getText())) {
                this.text.setText(this.selected);
            }
            return;
        }
        this.getShell().addListener(10, this.listener);
        if (this.getShell() != this.popup.getParent()) {
            String[] items = this.list.getItems();
            int selectionIndex = this.list.getSelectionIndex();
            this.list.removeListener(12, this.listener);
            this.popup.dispose();
            this.popup = null;
            this.list = null;
            this.createPopup(items, selectionIndex);
        }
        this.resizePopup();
    }

    private void resizePopup() {
        Point size = this.getSize();
        int itemCount = this.list.getItemCount();
        itemCount = itemCount == 0 ? this.visibleItemCount : Math.min(this.visibleItemCount, itemCount);
        int itemHeight = this.list.getItemHeight() * itemCount;
        Point listSize = this.list.computeSize(-1, itemHeight, false);
        this.list.setBounds(1, 1, Math.max(size.x - 2, listSize.x), listSize.y);
        int index = this.list.getSelectionIndex();
        if (index != -1) {
            this.list.setTopIndex(index);
        }
        Display display = this.getDisplay();
        Rectangle listRect = this.list.getBounds();
        Rectangle parentRect = display.map((Control)this.getParent(), null, this.getBounds());
        Point comboSize = this.getSize();
        Rectangle displayRect = this.getMonitor().getClientArea();
        int width = Math.max(comboSize.x, listRect.width + 2);
        int height = listRect.height + 2;
        int x = parentRect.x;
        int y = parentRect.y + comboSize.y;
        if (y + height > displayRect.y + displayRect.height) {
            y = parentRect.y - height;
        }
        this.popup.setBounds(x, y, width, height);
        this.popup.setVisible(true);
    }

    Label getAssociatedLabel() {
        Control[] siblings = this.getParent().getChildren();
        for (int i = 0; i < siblings.length; ++i) {
            if (siblings[i] != this || i <= 0 || !(siblings[i - 1] instanceof Label)) continue;
            return (Label)siblings[i - 1];
        }
        return null;
    }

    public Control[] getChildren() {
        this.checkWidget();
        return new Control[0];
    }

    public boolean getEditable() {
        this.checkWidget();
        return this.text.getEditable();
    }

    public String getItem(int index) {
        this.checkWidget();
        return this.listItems[index];
    }

    public int getItemCount() {
        this.checkWidget();
        return this.listItems == null ? 0 : this.listItems.length;
    }

    public int getItemHeight() {
        this.checkWidget();
        return this.list.getItemHeight();
    }

    public String[] getItems() {
        this.checkWidget();
        return this.listItems;
    }

    char getMnemonic(String string) {
        int index = 0;
        int length = string.length();
        while (true) {
            if (index < length && string.charAt(index) != '&') {
                ++index;
                continue;
            }
            if (++index >= length) {
                return '\u0000';
            }
            if (string.charAt(index) != '&') {
                return string.charAt(index);
            }
            if (++index >= length) break;
        }
        return '\u0000';
    }

    public Point getSelection() {
        this.checkWidget();
        return this.text.getSelection();
    }

    public int getSelectionIndex() {
        this.checkWidget();
        if (this.selected != null && this.listItems != null) {
            for (int i = 0; i < this.listItems.length; ++i) {
                if (!this.listItems[i].equals(this.selected)) continue;
                return i;
            }
        }
        return -1;
    }

    public int getStyle() {
        return super.getStyle();
    }

    public String getText() {
        this.checkWidget();
        return this.selected;
    }

    public int getTextHeight() {
        this.checkWidget();
        return this.text.getLineHeight();
    }

    public int getTextLimit() {
        this.checkWidget();
        return this.text.getTextLimit();
    }

    public int getVisibleItemCount() {
        this.checkWidget();
        return this.visibleItemCount;
    }

    void handleFocus(int type) {
        if (this.isDisposed()) {
            return;
        }
        switch (type) {
            case 15: {
                if (this.hasFocus) {
                    return;
                }
                this.hasFocus = true;
                Shell shell = this.getShell();
                shell.removeListener(27, this.listener);
                shell.addListener(27, this.listener);
                Display display = this.getDisplay();
                display.removeFilter(15, this.filter);
                display.removeFilter(3, this.filter);
                display.addFilter(15, this.filter);
                display.addFilter(3, this.filter);
                Event e = new Event();
                this.notifyListeners(15, e);
                break;
            }
            case 16: {
                if (!this.hasFocus) {
                    return;
                }
                this.hasFocus = false;
                this.dropDown(false);
                Shell shell = this.getShell();
                shell.removeListener(27, this.listener);
                Display display = this.getDisplay();
                display.removeFilter(15, this.filter);
                display.removeFilter(3, this.filter);
                Event e = new Event();
                this.notifyListeners(16, e);
                break;
            }
        }
    }

    public int indexOf(String string) {
        this.checkWidget();
        if (string == null) {
            SWT.error((int)4);
        }
        return this.list.indexOf(string);
    }

    public int indexOf(String string, int start) {
        this.checkWidget();
        if (string == null) {
            SWT.error((int)4);
        }
        return this.list.indexOf(string, start);
    }

    void initAccessible() {
        AccessibleAdapter accessibleAdapter = new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                String name = null;
                Label label = SearchBox.this.getAssociatedLabel();
                if (label != null) {
                    name = SearchBox.this.stripMnemonic(label.getText());
                }
                e.result = name;
            }

            public void getKeyboardShortcut(AccessibleEvent e) {
                char mnemonic;
                String text;
                String shortcut = null;
                Label label = SearchBox.this.getAssociatedLabel();
                if (label != null && (text = label.getText()) != null && (mnemonic = SearchBox.this.getMnemonic(text)) != '\u0000') {
                    shortcut = "Alt+" + mnemonic;
                }
                e.result = shortcut;
            }

            public void getHelp(AccessibleEvent e) {
                e.result = SearchBox.this.getToolTipText();
            }
        };
        this.getAccessible().addAccessibleListener((AccessibleListener)accessibleAdapter);
        this.text.getAccessible().addAccessibleListener((AccessibleListener)accessibleAdapter);
        this.list.getAccessible().addAccessibleListener((AccessibleListener)accessibleAdapter);
        this.arrow.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = SearchBox.this.isDropped() ? SWT.getMessage((String)"SWT_Close") : SWT.getMessage((String)"SWT_Open");
            }

            public void getKeyboardShortcut(AccessibleEvent e) {
                e.result = "Alt+Down Arrow";
            }

            public void getHelp(AccessibleEvent e) {
                e.result = SearchBox.this.getToolTipText();
            }
        });
        this.getAccessible().addAccessibleTextListener((AccessibleTextListener)new AccessibleTextAdapter(){

            public void getCaretOffset(AccessibleTextEvent e) {
                e.offset = SearchBox.this.text.getCaretPosition();
            }
        });
        this.getAccessible().addAccessibleControlListener((AccessibleControlListener)new AccessibleControlAdapter(){

            public void getChildAtPoint(AccessibleControlEvent e) {
                Point testPoint = SearchBox.this.toControl(e.x, e.y);
                if (SearchBox.this.getBounds().contains(testPoint)) {
                    e.childID = -1;
                }
            }

            public void getLocation(AccessibleControlEvent e) {
                Rectangle location = SearchBox.this.getBounds();
                Point pt = SearchBox.this.toDisplay(location.x, location.y);
                e.x = pt.x;
                e.y = pt.y;
                e.width = location.width;
                e.height = location.height;
            }

            public void getChildCount(AccessibleControlEvent e) {
                e.detail = 0;
            }

            public void getRole(AccessibleControlEvent e) {
                e.detail = 46;
            }

            public void getState(AccessibleControlEvent e) {
                e.detail = 0;
            }

            public void getValue(AccessibleControlEvent e) {
                e.result = SearchBox.this.getText();
            }
        });
        this.text.getAccessible().addAccessibleControlListener((AccessibleControlListener)new AccessibleControlAdapter(){

            public void getRole(AccessibleControlEvent e) {
                e.detail = SearchBox.this.text.getEditable() ? 42 : 41;
            }
        });
        this.arrow.getAccessible().addAccessibleControlListener((AccessibleControlListener)new AccessibleControlAdapter(){

            public void getDefaultAction(AccessibleControlEvent e) {
                e.result = SearchBox.this.isDropped() ? SWT.getMessage((String)"SWT_Close") : SWT.getMessage((String)"SWT_Open");
            }
        });
    }

    boolean isDropped() {
        return this.popup != null && !this.popup.isDisposed() && this.popup.getVisible();
    }

    public boolean isFocusControl() {
        this.checkWidget();
        if (this.text.isFocusControl() || this.arrow.isFocusControl() || this.list.isFocusControl() || this.popup.isFocusControl()) {
            return true;
        }
        return super.isFocusControl();
    }

    void internalLayout(boolean changed) {
        super.setBackground(this.getParent().getBackground());
        boolean dropped = this.isDisposed();
        if (dropped) {
            this.dropDown(false);
        }
        Rectangle rect = this.getClientArea();
        int border = isWindows ? 0 : this.getBorderWidth();
        int width = rect.width - 2 * border;
        int height = rect.height - 2 * border;
        Point arrowSize = this.arrow.computeSize(-1, height, changed);
        this.text.setBounds(border, border, width - arrowSize.x, height);
        this.arrow.setBounds(border + width - arrowSize.x, border, arrowSize.x, arrowSize.y);
        if (dropped) {
            this.dropDown(true);
        }
    }

    synchronized void listEvent(Event event) {
        LOG.debug("SearchBox.listEvent(" + SWTDebugHelper.eventTypeToText(event.type) + ")");
        switch (event.type) {
            case 12: {
                if (this.getShell() == this.popup.getParent()) break;
                String[] items = this.list.getItems();
                int selectionIndex = this.list.getSelectionIndex();
                this.popup = null;
                this.list = null;
                this.createPopup(items, selectionIndex);
                break;
            }
            case 4: {
                if (event.button != 1 || this.list.getSelectionIndex() <= -1) break;
                this.dropDown(false);
                if (this.text == null) break;
                this.text.setFocus();
                break;
            }
            case 13: {
                int index = this.list.getSelectionIndex();
                if (index <= -1) break;
                this.text.setText(this.list.getItem(index));
                this.text.selectAll();
                this.list.setSelection(index);
                this.handleSelection(event);
                if (this.isDropped() || this.text == null || this.text == null) break;
                this.text.setFocus();
                break;
            }
            case 2: {
                if (this.list.getItemCount() <= 0 || this.list.getSelectionIndex() == -1) break;
                this.text.setText(this.list.getItem(this.list.getSelectionIndex()));
                this.text.selectAll();
                break;
            }
            case 1: {
                if (event.character == '\u001b') {
                    this.dropDown(false);
                }
                if (event.character == '\r') {
                    this.dropDown(false);
                }
                if ((event.stateMask & 0x20000) != 0 && event.keyCode == 0x1000001) {
                    this.dropDown(false);
                }
                if (!this.isDisposed()) break;
                break;
            }
            case 31: {
                if (event.character != '\t') break;
                this.dropDown(false);
                this.text.traverse(16);
                event.doit = false;
            }
        }
    }

    void popupEvent(Event event) {
        switch (event.type) {
            case 9: {
                Rectangle listRect = this.list.getBounds();
                Color black = this.getDisplay().getSystemColor(2);
                event.gc.setForeground(black);
                event.gc.drawRectangle(0, 0, listRect.width + 1, listRect.height + 1);
                break;
            }
            case 21: {
                event.doit = false;
                this.dropDown(false);
                break;
            }
        }
    }

    public void redraw() {
        super.redraw();
        this.text.redraw();
        this.arrow.redraw();
        if (this.popup.isVisible()) {
            this.list.redraw();
        }
    }

    public void redraw(int x, int y, int width, int height, boolean all) {
        super.redraw(x, y, width, height, true);
    }

    public void remove(int index) {
        this.checkWidget();
        this.list.remove(index);
    }

    public void remove(int start, int end) {
        this.checkWidget();
        this.list.remove(start, end);
    }

    public void remove(String string) {
        this.checkWidget();
        if (string == null) {
            SWT.error((int)4);
        }
        this.list.remove(string);
    }

    public void removeAll() {
        this.checkWidget();
        this.text.setText("");
        this.list.removeAll();
    }

    public void removeModifyListener(ModifyListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error((int)4);
        }
        this.removeListener(24, (SWTEventListener)listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error((int)4);
        }
        this.removeListener(13, (SWTEventListener)listener);
        this.removeListener(14, (SWTEventListener)listener);
    }

    public void select(int index) {
        this.checkWidget();
        if (index == -1) {
            this.list.deselectAll();
            this.text.setText("");
            return;
        }
        if (0 <= index && index < this.listItems.length) {
            this.selected = this.listItems[index];
            if (!this.selected.equals(this.text.getText())) {
                this.text.setText(this.selected);
            }
            if (this.isDropped() && this.list.getSelectionIndex() != index) {
                this.list.select(index);
                this.list.showSelection();
            }
        }
    }

    public void setBackground(Color color) {
        this.background = color;
        if (this.text != null) {
            this.text.setBackground(color);
        }
        if (this.list != null) {
            this.list.setBackground(color);
        }
    }

    public Color getBackground() {
        return this.background;
    }

    public void setEditable(boolean editable) {
        this.checkWidget();
        this.text.setEditable(editable);
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (this.popup != null) {
            this.popup.setVisible(false);
        }
        if (this.text != null) {
            this.text.setEnabled(enabled);
        }
        if (this.arrow != null) {
            this.arrow.setEnabled(enabled);
        }
    }

    public boolean setFocus() {
        this.checkWidget();
        if (this.text != null) {
            return this.text.setFocus();
        }
        return false;
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.font = font;
        this.text.setFont(font);
        this.list.setFont(font);
        this.internalLayout(true);
    }

    public void setForeground(Color color) {
        super.setForeground(color);
        this.foreground = color;
        if (this.text != null) {
            this.text.setForeground(color);
        }
        if (this.list != null) {
            this.list.setForeground(color);
        }
    }

    public void setItem(int index, String string) {
        this.checkWidget();
        this.list.setItem(index, string);
    }

    public void setItems(String[] items) {
        this.checkWidget();
        this.allItems = (String[])items.clone();
        this.setListItems(this.allItems, false);
    }

    private void setListItems(String[] items, boolean force) {
        this.listItems = items;
        if ((this.isDropped() || force) && !Arrays.equals(this.displayedItems, items)) {
            this.list.setItems(items);
            if (this.displayedItems != null && this.displayedItems.length < this.visibleItemCount && this.displayedItems.length < items.length) {
                this.resizePopup();
            }
            this.displayedItems = items;
        }
    }

    public void setLayout(Layout layout) {
        this.checkWidget();
    }

    public void setSelection(Point selection) {
        this.checkWidget();
        if (selection == null) {
            SWT.error((int)4);
        } else {
            this.text.setSelection(selection.x, selection.y);
        }
    }

    public void setText(String string) {
        int index;
        this.checkWidget();
        if (string == null) {
            SWT.error((int)4);
        }
        if ((index = this.list.indexOf(string)) == -1) {
            this.text.setText(string);
            this.showFilteredItems();
            return;
        }
        this.text.setText(string);
        this.text.selectAll();
        this.showFilteredItems();
    }

    public void setTextLimit(int limit) {
        this.checkWidget();
        this.text.setTextLimit(limit);
    }

    public void setToolTipText(String string) {
        this.checkWidget();
        super.setToolTipText(string);
        this.arrow.setToolTipText(string);
        this.text.setToolTipText(string);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (!visible) {
            this.popup.setVisible(false);
        }
    }

    public void setVisibleItemCount(int count) {
        this.checkWidget();
        if (count < 0) {
            return;
        }
        this.visibleItemCount = count;
    }

    String stripMnemonic(String string) {
        int index = 0;
        int length = string.length();
        while (true) {
            if (index < length && string.charAt(index) != '&') {
                ++index;
                continue;
            }
            if (++index >= length) {
                return string;
            }
            if (string.charAt(index) != '&') {
                return string.substring(0, index - 1) + string.substring(index, length);
            }
            if (++index >= length) break;
        }
        return string;
    }

    void textEvent(Event event) {
        LOG.debug("SearchBox.textEvent(" + SWTDebugHelper.eventTypeToText(event.type) + ")");
        switch (event.type) {
            case 15: {
                this.handleFocus(15);
                if (this.isDropped()) break;
                this.text.selectAll();
                break;
            }
            case 16: {
                if (isWindows) {
                    this.text.setSelection(0);
                    break;
                }
                this.text.setSelection(this.text.getCaretPosition());
                break;
            }
            case 1: {
                break;
            }
            case 8: {
                this.text.selectAll();
                break;
            }
            case 2: {
                if (event.character == '\u001b' || event.character == '\r' || event.character == '\t') {
                    this.dropDown(false);
                    if (this.selected == null) break;
                    this.text.setText(this.selected);
                    this.text.selectAll();
                    break;
                }
                if (event.character == '\u0000' && event.keyCode != 0x1000002) break;
                if (event.keyCode == 0x1000002) {
                    if (this.isDropped()) {
                        if (this.list.getItemCount() > 0) {
                            this.list.setSelection(1);
                            this.handleSelection(null);
                        }
                    } else {
                        this.showAllItems();
                    }
                } else {
                    this.showFilteredItems();
                    this.list.setSelection(0);
                    this.handleSelection(null);
                }
                boolean wasDropped = this.isDropped();
                this.dropDown(true);
                if (event.keyCode == 0x1000002) {
                    this.list.setFocus();
                    this.list.showSelection();
                } else {
                    final int pos = this.text.getCaretPosition();
                    if (this.text != null) {
                        this.text.setFocus();
                        this.text.setSelection(pos);
                    }
                    if (isLinux && !wasDropped) {
                        this.getDisplay().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                if (SearchBox.this.text != null) {
                                    SearchBox.this.text.setFocus();
                                    SearchBox.this.text.setSelection(pos);
                                }
                            }
                        });
                    }
                }
                this.handleFocus(15);
            }
        }
    }

    private void showFilteredItems() {
        if (this.allItems == null) {
            return;
        }
        ArrayList<String> filteredList = new ArrayList<String>();
        String txt = this.text.getText().toLowerCase();
        for (String item : this.allItems) {
            if (!item.toLowerCase().startsWith(txt)) continue;
            filteredList.add(item);
        }
        String[] current = new String[filteredList.size()];
        filteredList.toArray(current);
        this.setListItems(current, true);
    }

    private void showAllItems() {
        this.setListItems(this.allItems, true);
        if (this.selected != null) {
            for (int i = 0; i < this.allItems.length; ++i) {
                if (!this.allItems[i].equals(this.selected)) continue;
                this.list.select(i);
                break;
            }
        }
    }

    private void handleSelection(Event source) {
        String newSelection;
        int idx = this.list.getSelectionIndex();
        if (idx >= 0 && idx < this.getItemCount() && !(newSelection = this.getItem(idx)).equals(this.selected)) {
            this.selected = newSelection;
            Event ev = new Event();
            if (source != null) {
                ev.doit = source.doit;
                ev.stateMask = source.stateMask;
            }
            this.notifyListeners(13, ev);
            if (source != null) {
                source.doit = ev.doit;
            }
        }
    }
}

