/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.cd.util;

import ch.dvbern.tax.common.presentation.cd.util.OpenException;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class TaxFileConfig {
    public static final String AUTOSAFE_SUFFIX = ".tta";
    public static final String AUTOSAVE_PREFIX = "autosave";
    public static final String EXTENSION = ".tax";
    public static final String FILENAME = "";
    private static volatile TaxFileConfig INSTANCE;

    public static void setInstance(@NonNull TaxFileConfig instance) {
        if (instance == null) {
            throw new NullPointerException("Config instance cannot be null.");
        }
        if (INSTANCE != null) {
            throw new IllegalStateException("Instance already set.");
        }
        INSTANCE = instance;
    }

    public static @NonNull TaxFileConfig getInstance() {
        if (INSTANCE == null) {
            throw new IllegalStateException("Config instance not set.");
        }
        return INSTANCE;
    }

    public static @Nullable TaxFileConfig getExistingInstance() {
        return INSTANCE;
    }

    public String getFileName(Map<String, ModelItemDTO> datamodel) {
        return FILENAME;
    }

    public String getFileNameExtension() {
        return EXTENSION;
    }

    public boolean checkVersion(Map<String, ModelItemDTO> dataModel) throws OpenException {
        return true;
    }

    public String getAutosavePrefix(Map<String, ModelItemDTO> dataModel) {
        return AUTOSAVE_PREFIX;
    }

    public String getAutosaveSuffix() {
        return AUTOSAFE_SUFFIX;
    }
}

