/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.cd.util;

import ch.dvbern.tax.common.presentation.cd.TaxmeController;
import ch.dvbern.tax.common.transfer.dto.ExpertDisplayInfoDTO;
import ch.dvbern.tax.common.transfer.dto.OptionItemsDTO;
import ch.dvbern.tax.common.transfer.dto.WizardDisplayInfoDTO;
import ch.dvbern.tax.common.transfer.dto.convert.AbstractConverter;
import org.checkerframework.checker.nullness.qual.Nullable;

public class OutputRenderer {
    public @Nullable String render(WizardDisplayInfoDTO.ItemItemDTO item) {
        if (item == null || item.getValue() == null) {
            return "";
        }
        return this.render(item.getRendererAndInputValidator(), item.getDataModelKey(), item.getValue(), item.getReadonly(), item.getOptionItems());
    }

    public @Nullable String render(ExpertDisplayInfoDTO.ValueItemDTO item) {
        if (item == null) {
            return "";
        }
        Object value = item.getModelItem() != null ? item.getModelItem().getValue() : null;
        return this.render(item.getRendererAndInputValidator(), item.getDataModelKey(), value, item.isReadonly(), item.getOptionItems());
    }

    public @Nullable String render(ExpertDisplayInfoDTO.TableDTO.ColumnDTO col, ExpertDisplayInfoDTO.TableDTO.ValueCellDTO item) {
        if (item == null) {
            return "";
        }
        Object value = item.getModelItem() != null ? item.getModelItem().getValue() : null;
        return this.render(col.getRendererAndInputValidator(), item.getDataModelKey(), value, col.isReadonly(), item.getOptionItems());
    }

    private @Nullable String render(@Nullable AbstractConverter<?> converter, @Nullable String dmk, @Nullable Object value, boolean readonly, @Nullable OptionItemsDTO optionItems) {
        String result = "";
        if (converter != null) {
            TaxmeController ctrl = TaxmeController.getInstance();
            AbstractConverter.ConverterContext ctx = new AbstractConverter.ConverterContext(ctrl.getLocalizationHelper(), ctrl.getTmoCdSession().getDataModel(), dmk);
            result = converter.getRenderedValue(value, readonly, optionItems, ctx);
        } else if (value != null) {
            result = value.toString();
        }
        return result;
    }
}

