/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.cd.util;

import ch.dvbern.tax.common.engine.wizarddisplay.DisplayItemUniqueID;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.swt.custom.ControlEditor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Widget;

public final class ControlReuseUtil {
    private LinkedHashMap<DisplayItemUniqueID, Object> newControls = new LinkedHashMap();
    private LinkedHashMap<DisplayItemUniqueID, Object> prevControls = null;

    public void start() {
        this.prevControls = this.newControls;
        this.newControls = new LinkedHashMap();
    }

    public void end() {
        for (Map.Entry<DisplayItemUniqueID, Object> me : this.prevControls.entrySet()) {
            this.dispose(me.getValue());
        }
        this.prevControls.clear();
    }

    private void dispose(Object obj) {
        if (obj instanceof Control) {
            Control c = (Control)obj;
            if (!c.isDisposed()) {
                if (c.getLayoutData() instanceof GridData) {
                    ((GridData)c.getLayoutData()).exclude = true;
                }
                c.dispose();
            }
        } else if (obj instanceof Widget) {
            Widget c = (Widget)obj;
            if (!c.isDisposed()) {
                c.dispose();
            }
        } else if (obj instanceof ControlEditor) {
            ControlEditor c = (ControlEditor)obj;
            c.dispose();
        } else if (obj instanceof CompositeAndControlReuseUtil) {
            CompositeAndControlReuseUtil c = (CompositeAndControlReuseUtil)obj;
            this.dispose(c.composite);
        } else assert (false) : "Unknown component type: " + String.valueOf(obj.getClass());
    }

    public Control getControl(DisplayItemUniqueID uid) {
        Object result = this.get(uid);
        if (result instanceof Control) {
            return (Control)result;
        }
        return null;
    }

    public Widget getWidget(DisplayItemUniqueID uid) {
        Object result = this.get(uid);
        if (result instanceof Widget) {
            return (Widget)result;
        }
        return null;
    }

    public ControlEditor getControlEditor(DisplayItemUniqueID uid) {
        Object result = this.get(uid);
        if (result instanceof ControlEditor) {
            return (ControlEditor)result;
        }
        return null;
    }

    public CompositeAndControlReuseUtil getCompositeAndControlReuseUtil(DisplayItemUniqueID uid) {
        Object result = this.get(uid);
        if (result instanceof CompositeAndControlReuseUtil) {
            return (CompositeAndControlReuseUtil)result;
        }
        return null;
    }

    private Object get(DisplayItemUniqueID uid) {
        if (!this.prevControls.containsKey(uid)) {
            return null;
        }
        Iterator<Map.Entry<DisplayItemUniqueID, Object>> i = this.prevControls.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry<DisplayItemUniqueID, Object> me = i.next();
            if (me.getKey().equals((Object)uid)) {
                i.remove();
                this.newControls.put(me.getKey(), me.getValue());
                return me.getValue();
            }
            i.remove();
            this.dispose(me.getValue());
        }
        return null;
    }

    public void addControl(DisplayItemUniqueID uid, Control control) {
        if (uid == null) {
            throw new NullPointerException("uid must not be null. control:" + String.valueOf(control));
        }
        this.moveAboveNextControl(control);
        this.newControls.put(uid, control);
    }

    public void addWidget(DisplayItemUniqueID uid, Widget control) {
        this.newControls.put(uid, control);
    }

    public void addControlEditor(DisplayItemUniqueID uid, ControlEditor control) {
        this.newControls.put(uid, control);
    }

    public CompositeAndControlReuseUtil addComposite(DisplayItemUniqueID uid, Composite composite, ControlReuseUtil controlReuseUtil) {
        this.moveAboveNextControl((Control)composite);
        CompositeAndControlReuseUtil cacru = new CompositeAndControlReuseUtil(composite, controlReuseUtil);
        this.newControls.put(uid, cacru);
        return cacru;
    }

    private void moveAboveNextControl(Control control) {
        if (!this.prevControls.isEmpty()) {
            Map.Entry<DisplayItemUniqueID, Object> me = this.prevControls.entrySet().iterator().next();
            if (me.getValue() instanceof CompositeAndControlReuseUtil) {
                CompositeAndControlReuseUtil cacru = (CompositeAndControlReuseUtil)me.getValue();
                control.moveAbove((Control)cacru.getComposite());
            } else if (me.getValue() instanceof Control) {
                control.moveAbove((Control)me.getValue());
            }
        }
    }

    public static final class CompositeAndControlReuseUtil {
        private final Composite composite;
        private final ControlReuseUtil controlReuseUtil;

        private CompositeAndControlReuseUtil(Composite composite, ControlReuseUtil controlReuseUtil) {
            this.composite = composite;
            this.controlReuseUtil = controlReuseUtil;
        }

        public Composite getComposite() {
            return this.composite;
        }

        public ControlReuseUtil getControlReuseUtil() {
            return this.controlReuseUtil;
        }
    }
}

