/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.cd.resourcetools.manager;

import ch.dvbern.tax.common.presentation.cd.resourcetools.IToolCommunicationGui;
import ch.dvbern.tax.common.presentation.cd.resourcetools.html.HTMLEditorPathGui;
import ch.dvbern.tax.common.presentation.cd.resourcetools.index.IndexGui;
import ch.dvbern.tax.common.presentation.cd.resourcetools.mapping.HelpMappingGui;
import ch.dvbern.tax.common.presentation.cd.resourcetools.mapping.ShortHelpMappingOnControlsGui;
import ch.dvbern.tax.common.presentation.cd.resourcetools.treestructure.TreeStructureGui;
import java.io.File;
import java.io.IOException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ToolCommunication {
    private static final Logger LOG = LoggerFactory.getLogger(ToolCommunication.class);
    private static ToolCommunication current = null;

    public static ToolCommunication getInstance() {
        if (current == null) {
            current = new ToolCommunication();
        }
        return current;
    }

    private ToolCommunication() {
    }

    public void manageHelpIndex(IToolCommunicationGui callback) {
        if (callback == null || !callback.toolIsHelpIndexEnabled()) {
            return;
        }
        IndexGui index = new IndexGui(null, callback);
        index.setBlockOnOpen(true);
        index.create();
        index.open();
        index.close();
        callback.toolRefreshTreeSructures();
    }

    public void manageHelpMapping(IToolCommunicationGui callback) {
        if (callback == null || !callback.toolIsHelpMappingEnabled()) {
            return;
        }
        HelpMappingGui helpMappingGui = new HelpMappingGui(callback);
        helpMappingGui.setBlockOnOpen(true);
        helpMappingGui.create();
        helpMappingGui.open();
        helpMappingGui.close();
    }

    public void manageShortHelpMappingOnControls(IToolCommunicationGui callback, String key) {
        if (callback == null || !callback.toolIsHelpMappingEnabled()) {
            return;
        }
        ShortHelpMappingOnControlsGui shortHelpMappingOnControlsGui = new ShortHelpMappingOnControlsGui(callback, key);
        shortHelpMappingOnControlsGui.setBlockOnOpen(true);
        shortHelpMappingOnControlsGui.create();
        shortHelpMappingOnControlsGui.open();
        shortHelpMappingOnControlsGui.close();
    }

    public void manageHelpTreestructure(IToolCommunicationGui callback) {
        if (callback == null || !callback.toolIsHelpTreestructureEnabled()) {
            return;
        }
        TreeStructureGui helpTreeStructure = new TreeStructureGui(null, callback);
        helpTreeStructure.setBlockOnOpen(true);
        helpTreeStructure.create();
        helpTreeStructure.open();
        helpTreeStructure.close();
        callback.toolRefreshTreeSructures();
    }

    public void manageHtmlEditOnMainHelp(IToolCommunicationGui callback) {
        if (callback == null || !callback.toolIsHtmlEditOnMainHelpEnabled()) {
            return;
        }
        if (callback.toolGetFullHtmlEditorName() == null || callback.toolGetCurrentMainHelpFileName() == null) {
            MessageDialog.openInformation((Shell)callback.getCallBackShell(), (String)"Error", (String)"Please make sure a valid HTML editor has been defined and the HTML-Document you wish to edit is visible");
            return;
        }
        if (callback.toolGetCurrentMainHelpFileName().equals("")) {
            return;
        }
        try {
            Object command = callback.toolGetFullHtmlEditorName() + " \"" + callback.toolGetCurrentMainHelpDirectory() + callback.toolGetCurrentLanguage() + "/" + callback.toolGetCurrentMainHelpFileName() + "\"";
            command = ((String)command).replace('/', File.separatorChar);
            Process process = Runtime.getRuntime().exec((String)command);
            process.waitFor();
        }
        catch (IOException e) {
            LOG.error("Error on mainHelp HTML edit: ", (Throwable)e);
        }
        catch (InterruptedException e) {
            LOG.error("Error on mainHelp HTML edit: ", (Throwable)e);
        }
        callback.toolRefreshCurrentHTML();
    }

    public void manageHtmlEditOnShortHelp(IToolCommunicationGui callback) {
        if (callback == null || !callback.toolIsHtmlEditOnShortHelpEnabled()) {
            return;
        }
        if (callback.toolGetFullHtmlEditorName() == null || callback.toolGetCurrentFullHTMLFileName() == null) {
            MessageDialog.openInformation((Shell)callback.getCallBackShell(), (String)"Error", (String)"Please make sure a valid HTML editor has been defined and the HTML-Document you wish to edit is visible");
            return;
        }
        try {
            Object str = callback.toolGetFullHtmlEditorName() + " \"" + callback.toolGetCurrentFullHTMLFileName() + "\"";
            str = ((String)str).replace('/', File.separatorChar);
            Process process = Runtime.getRuntime().exec((String)str);
            process.waitFor();
        }
        catch (IOException e) {
            LOG.error("Error on shortHelp HTML edit: ", (Throwable)e);
        }
        catch (InterruptedException e) {
            LOG.error("Error on shortHelp HTML edit: ", (Throwable)e);
        }
        callback.toolRefreshCurrentHTML();
    }

    public void manageHtmlEditorSet(IToolCommunicationGui callback) {
        HTMLEditorPathGui htmlEditorPathGui = new HTMLEditorPathGui(callback);
        htmlEditorPathGui.setBlockOnOpen(true);
        htmlEditorPathGui.create();
        htmlEditorPathGui.open();
        htmlEditorPathGui.close();
    }
}

