/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.cd.parts;

import ch.dvbern.tax.common.presentation.cd.Messages;
import ch.dvbern.tax.common.presentation.cd.TaxmeController;
import ch.dvbern.tax.common.presentation.cd.resourcetools.TranslationManager;
import ch.dvbern.tax.common.presentation.cd.widgets.TaxmeComposite;
import java.text.Collator;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class TranslationPart
extends TaxmeComposite {
    private final TaxmeComposite c;
    private final Table table;
    private final TableColumn column1;
    private final TableColumn column2;

    public TranslationPart(Composite parent) {
        super(parent, 2048);
        this.setLayout((Layout)new FillLayout());
        this.c = new TaxmeComposite(this, 0);
        this.c.setLayout((Layout)new GridLayout(1, true));
        this.table = new Table((Composite)this.c, 65536);
        this.table.setLayoutData((Object)new GridData(1808));
        this.table.addSelectionListener((SelectionListener)new TranslationSelectionListener());
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        this.column1 = new TableColumn(this.table, 0);
        this.column1.setText(Messages.configurableTranslate("label.translation.key", new Object[0]));
        this.column2 = new TableColumn(this.table, 0);
        this.column2.setText(Messages.configurableTranslate("label.translation.textdefault", new Object[0]));
        this.column1.addSelectionListener((SelectionListener)new SortListener());
        this.column2.addSelectionListener((SelectionListener)new SortListener());
    }

    public void setContent(Set<String> translations) {
        String selectedKey = null;
        if (this.table.getItemCount() > 0) {
            int selection = this.table.getSelectionIndex();
            if (selection >= 0) {
                TableItem ti = this.table.getItem(selection);
                selectedKey = ti.getText(0);
            }
            this.table.removeAll();
        }
        for (String key : translations) {
            if (key == null) continue;
            TableItem tableItem = new TableItem(this.table, 65536);
            String language = TaxmeController.getInstance().getLanguage();
            Map<String, Properties> resources = TranslationManager.getInstance().getResourceMap();
            Properties properties = resources.get(language);
            String value = "";
            if (properties.containsKey(key)) {
                value = (String)properties.get(key);
            }
            tableItem.setText(new String[]{key, value});
        }
        this.sortTable();
        this.column1.pack();
        this.column2.pack();
        this.table.pack();
        this.table.redraw();
        this.c.layout();
        if (selectedKey != null) {
            TableItem[] items = this.table.getItems();
            for (int i = 1; i < items.length; ++i) {
                if (!selectedKey.equals(items[i].getText(0))) continue;
                this.table.setSelection(items[i]);
                this.table.showSelection();
                break;
            }
        }
    }

    private void sortTable() {
        if (this.table.getSortColumn() == null || this.table.getSortDirection() == 0) {
            return;
        }
        TableItem[] items = this.table.getItems();
        Collator collator = Collator.getInstance(Locale.getDefault());
        TableColumn column = this.table.getSortColumn();
        int index = column == this.column1 ? 0 : 1;
        boolean ascending = this.table.getSortDirection() != 128;
        block0: for (int i = 1; i < items.length; ++i) {
            String value1 = items[i].getText(index);
            for (int j = 0; j < i; ++j) {
                String value2 = items[j].getText(index);
                if (collator.compare(value1, value2) >= 0 && ascending) continue;
                String[] values = new String[]{items[i].getText(0), items[i].getText(1)};
                items[i].dispose();
                TableItem item = new TableItem(this.table, 0, j);
                item.setText(values);
                items = this.table.getItems();
                continue block0;
            }
        }
    }

    private class SortListener
    extends SelectionAdapter {
        private SortListener() {
        }

        public void widgetSelected(SelectionEvent ev) {
            TableColumn column = (TableColumn)ev.widget;
            if (column != TranslationPart.this.table.getSortColumn()) {
                TranslationPart.this.table.setSortDirection(0);
            }
            TranslationPart.this.table.setSortColumn(column);
            if (TranslationPart.this.table.getSortDirection() == 1024) {
                TranslationPart.this.table.setSortDirection(128);
            } else {
                TranslationPart.this.table.setSortDirection(1024);
            }
            TranslationPart.this.sortTable();
        }
    }

    private class TranslationSelectionListener
    extends SelectionAdapter {
        private TranslationSelectionListener() {
        }

        public void widgetSelected(SelectionEvent arg0) {
            TableItem item = TranslationPart.this.table.getSelection()[0];
            TranslationManager.getInstance().translate(item.getText(0));
        }
    }
}

