/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.cd.parts;

import ch.dvbern.tax.common.presentation.cd.Messages;
import ch.dvbern.tax.common.presentation.cd.items.IButtonItem;
import ch.dvbern.tax.common.presentation.cd.items.wizard.WButtonItem;
import ch.dvbern.tax.common.presentation.cd.parts.IButtonPart;
import ch.dvbern.tax.common.presentation.cd.util.ButtonCommand;
import ch.dvbern.tax.common.presentation.cd.util.ButtonCommands;
import ch.dvbern.tax.common.presentation.cd.util.GuiUtil;
import ch.dvbern.tax.common.presentation.cd.widgets.TaxmeButton;
import ch.dvbern.tax.common.presentation.cd.widgets.TaxmeComposite;
import ch.dvbern.tax.common.transfer.dto.FontDTO;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ButtonPart
extends TaxmeComposite
implements IButtonPart {
    private static final Logger LOG = LoggerFactory.getLogger(ButtonPart.class);
    private TaxmeButton button;
    private Label label;
    private ButtonCommand cmd;
    private IButtonItem buttonDTO;

    public ButtonPart(Composite parent) {
        super(parent, 0);
        this.setLayoutData(new GridData());
        GridLayout gl = new GridLayout(1, false);
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        this.setLayout((Layout)gl);
    }

    @Override
    public void init(IButtonItem item) {
        boolean restrictedMode;
        this.buttonDTO = item;
        boolean bl = restrictedMode = !(item instanceof WButtonItem);
        if (restrictedMode && item.getIcon() != null) {
            if (this.button != null) {
                this.button.dispose();
                this.button = null;
            }
            this.initLabel();
        } else {
            if (this.label != null) {
                this.label.dispose();
                this.label = null;
            }
            this.initButton(restrictedMode);
        }
        GridData gd = (GridData)this.getLayoutData();
        gd.horizontalSpan = this.buttonDTO.getColspan();
        this.setBackground(this.buttonDTO.getBackgroundColor());
        this.cmd = ButtonCommands.get(this.buttonDTO.getUri());
        if (this.cmd != null) {
            this.cmd.init(this.buttonDTO);
        } else {
            LOG.warn("Not registered ButtonCommand: " + this.buttonDTO.getUri());
        }
    }

    private void initButton(boolean restrictedMode) {
        if (this.button == null) {
            this.button = new TaxmeButton(this, 64);
            this.button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    ButtonPart.this.cmd.execute(ButtonPart.this.buttonDTO);
                }
            });
            FontDTO fontDTO = null;
            if (this.buttonDTO instanceof WButtonItem) {
                fontDTO = ((WButtonItem)this.buttonDTO).getItem().getFontDTO();
            }
            Font font = fontDTO != null ? GuiUtil.toFont(fontDTO) : GuiUtil.getFontRegistry().get("font.normal");
            this.button.setFont(font);
            this.button.setBackground(GuiUtil.getColorRegistry().get(GuiUtil.COLOR_GREY_LIGHT));
            GridData gridData = new GridData(68);
            Integer width = this.buttonDTO.getWidth();
            Integer height = this.buttonDTO.getHeight();
            if (!restrictedMode) {
                if (width != null) {
                    gridData.widthHint = width;
                }
                if (height != null) {
                    gridData.heightHint = height;
                }
            }
            this.button.setLayoutData(gridData);
        }
        this.button.setText(Messages.configurableTranslate(this.buttonDTO.getNameKey(), (Control)this.button, new Object[0]));
        this.button.setEnabled(this.buttonDTO.isEnabled());
        this.button.setImage(this.buttonDTO.getIcon());
    }

    private void initLabel() {
        if (this.label == null) {
            this.label = new Label((Composite)this, 0);
            this.label.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDown(MouseEvent ev) {
                    if (ButtonPart.this.buttonDTO.isEnabled()) {
                        ButtonPart.this.getParent().traverse(16);
                        ButtonPart.this.cmd.execute(ButtonPart.this.buttonDTO);
                    }
                }
            });
            this.label.setFont(GuiUtil.getFontRegistry().get("font.normal"));
            this.label.setLayoutData((Object)new GridData(68));
        }
        this.label.setImage(this.buttonDTO.getIcon());
        if (this.buttonDTO.getNameKey() != null) {
            this.label.setToolTipText(Messages.configurableTranslate(this.buttonDTO.getNameKey(), (Control)this.label, new Object[0]));
        }
        this.label.setEnabled(this.buttonDTO.isEnabled());
        this.label.setBackground(this.buttonDTO.getBackgroundColor());
    }
}

