/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.cd.items.expert;

import ch.dvbern.tax.common.engine.wizarddisplay.DisplayItemUniqueID;
import ch.dvbern.tax.common.presentation.cd.TaxmeController;
import ch.dvbern.tax.common.presentation.cd.action.ValidateAction;
import ch.dvbern.tax.common.presentation.cd.expertdisplay.ExpertGuiUtil;
import ch.dvbern.tax.common.presentation.cd.items.IValueItem;
import ch.dvbern.tax.common.presentation.cd.items.expert.AExpertItem;
import ch.dvbern.tax.common.presentation.cd.util.OsSupport;
import ch.dvbern.tax.common.transfer.dto.ExpertDisplayInfoDTO;
import ch.dvbern.tax.common.transfer.dto.FontDTO;
import ch.dvbern.tax.common.transfer.dto.MessageItemDTO;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import ch.dvbern.tax.common.transfer.dto.OptionItemsDTO;
import ch.dvbern.tax.common.transfer.dto.convert.AbstractConverter;
import java.util.Collection;
import java.util.Collections;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Rectangle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EValueItem
extends AExpertItem<ExpertDisplayInfoDTO.ValueItemDTO, ExpertDisplayInfoDTO.TableDTO.CellDTO>
implements IValueItem {
    private static final Logger LOG = LoggerFactory.getLogger(EValueItem.class);
    private static boolean readOnlyPaddingEnabled = true;
    private final ExpertDisplayInfoDTO.ValuePositionDTO valuePos;
    private final Object valuePosValue;
    private int style;
    private int state;
    private final boolean validateIfLeftEmpty;

    public static void setReadOnlyPaddingEnabled(boolean readOnlyPaddingEnabled) {
        EValueItem.readOnlyPaddingEnabled = readOnlyPaddingEnabled;
    }

    public static boolean isReadOnlyPaddingEnabled() {
        return readOnlyPaddingEnabled;
    }

    public EValueItem(ExpertDisplayInfoDTO.ValueItemDTO item, ExpertDisplayInfoDTO.ValuePositionDTO valuePos, Object valuePosValue, float zoom, boolean validateIfLeftEmpty) {
        super(item, zoom);
        this.valuePos = valuePos;
        this.valuePosValue = valuePosValue;
        this.validateIfLeftEmpty = validateIfLeftEmpty;
        ModelItemDTO mi = item.getModelItem();
        this.style = 0;
        if (item.isReadonly()) {
            this.style = 3;
        }
        this.state = 3;
        if (mi != null) {
            this.state = mi.getState();
        }
    }

    @Override
    public @Nullable Object getValue() {
        return this.getItem().getModelItem() != null ? this.getItem().getModelItem().getValue() : null;
    }

    @Override
    public String getRenderedValue() {
        return EValueItem.render(this.getItem());
    }

    @Override
    public AbstractConverter<?> getRendererAndInputValidator() {
        return this.getItem().getRendererAndInputValidator();
    }

    @Override
    public int getStyle() {
        return this.style;
    }

    @Override
    public String getAlign() {
        return this.getItem().getAlignmentString();
    }

    @Override
    public int getMaxLength() {
        if (this.getItem().getRendererAndInputValidator() != null) {
            return this.getItem().getRendererAndInputValidator().getMaxLength();
        }
        return 100;
    }

    @Override
    public @Nullable String getRegularExpression() {
        if (this.getItem().getRendererAndInputValidator() != null) {
            return this.getItem().getRendererAndInputValidator().getUserInputRegExpPattern();
        }
        return null;
    }

    @Override
    public int calcLength(String input) {
        if (this.getItem().getRendererAndInputValidator() != null) {
            return this.getItem().getRendererAndInputValidator().calcLength(input);
        }
        return input == null ? 0 : input.length();
    }

    @Override
    public boolean isValidateIfLeftEmpty() {
        return this.validateIfLeftEmpty;
    }

    @Override
    public int getState() {
        if (this.getItem().getModelItem() != null) {
            return this.getItem().getModelItem().getState();
        }
        return 3;
    }

    @Override
    public @Nullable OptionItemsDTO getOptionItems() {
        return this.getItem().getOptionItems();
    }

    @Override
    public @Nullable Object getOptionValue() {
        return this.valuePosValue;
    }

    @Override
    public void setDefaultValue(String value) {
        if (this.getItem().getValuePositions() == null || this.getItem().getValuePositions().isEmpty()) {
            try {
                Object convertedValue;
                AbstractConverter conv = this.getItem().getRendererAndInputValidator();
                if (conv != null) {
                    TaxmeController ctrl = TaxmeController.getInstance();
                    AbstractConverter.ConverterContext ctx = new AbstractConverter.ConverterContext(ctrl.getLocalizationHelper(), ctrl.getTmoCdSession().getDataModel(), this.getItem().getDataModelKey());
                    convertedValue = conv.getObject(value, this.getItem().getOptionItems(), ctx);
                } else {
                    convertedValue = value;
                }
                if (this.getItem().getModelItem() != null) {
                    this.getItem().setModelItem(this.getItem().getModelItem().clone(convertedValue));
                } else {
                    this.getItem().setModelItem(new ModelItemDTO(convertedValue));
                }
            }
            catch (AbstractConverter.ConvertException e) {
                LOG.error("Error setting default value: ", (Throwable)e);
            }
        }
    }

    @Override
    public @NonNull DisplayItemUniqueID getUID() {
        return this.valuePos == null ? this.getItem().getUniqueItemIdentifier() : this.getItem().getUniqueItemIdentifier().appendLocal("." + this.valuePos.getValue());
    }

    @Override
    public int getType() {
        if (this.getItem().getType() == 1) {
            return 3;
        }
        return this.getItem().getType();
    }

    @Override
    public @Nullable Color getBackgroundColor() {
        if (this.getItem().isReadonly()) {
            return this.getColor(this.getItem().getBgColor());
        }
        switch (this.state) {
            case 4: {
                return RED;
            }
            case 2: {
                return YELLOW;
            }
        }
        return this.getColor(this.getItem().getBgColor());
    }

    @Override
    public Font getFont() {
        FontDTO fontDTO = this.getItem().getFont();
        if (fontDTO != null && this.getItem().isReadonly() && (this.getItem().getType() == 1 || this.getItem().getType() == 3)) {
            fontDTO = new FontDTO(fontDTO.getName(), fontDTO.getSize(), fontDTO.getStyle() | 1, fontDTO.getColor(), fontDTO.getCharSpace());
        }
        return ExpertGuiUtil.getFont(fontDTO, this.getZoom());
    }

    @Override
    public void update(String newValue) {
        ValidateAction validateAction = new ValidateAction();
        validateAction.execute(newValue, this.getItem());
    }

    @Override
    public @Nullable Rectangle getBounds() {
        int height;
        int x = this.valuePos == null ? this.getItem().getX(this.getZoom()) : this.getItem().getX(this.getZoom()) + this.valuePos.getX(this.getZoom());
        int y = this.valuePos == null ? this.getItem().getY(this.getZoom()) : this.getItem().getY(this.getZoom()) + this.valuePos.getY(this.getZoom());
        int width = this.valuePos == null ? this.getItem().getWidth(this.getZoom()) : this.valuePos.getWidth(this.getZoom());
        int n = height = this.valuePos == null ? this.getItem().getHeight(this.getZoom()) : this.valuePos.getHeight(this.getZoom());
        if (readOnlyPaddingEnabled && this.getStyle() == 3) {
            if (OsSupport.isWindowsOs()) {
                x += 7;
                width -= 14;
                y += 2;
                height -= 3;
            } else if (OsSupport.isLinuxOs()) {
                x += 5;
                width -= 10;
                y += 2;
                height -= 4;
            } else if (OsSupport.isMacOs()) {
                x += 5;
                width -= 10;
                y += 5;
                height -= 8;
            }
        }
        if (OsSupport.isMacOs()) {
            y -= 2;
            height += 5;
            x -= 3;
            width += 6;
        }
        return new Rectangle(x, y, width, height);
    }

    @Override
    public Collection<MessageItemDTO> getMessages() {
        if (this.getItem().getModelItem() != null) {
            return this.getItem().getModelItem().getMessages();
        }
        return Collections.emptyList();
    }

    @Override
    public boolean isMoveToForeground() {
        return true;
    }

    @Override
    public boolean hasBorder() {
        return this.style == 0;
    }

    public ExpertDisplayInfoDTO.ValueItemDTO getItem() {
        return (ExpertDisplayInfoDTO.ValueItemDTO)super.getItemRef();
    }

    @Override
    public @Nullable String getShortHelpKey() {
        return this.getItem().getShortHelpKey();
    }

    @Override
    public boolean isDynamicWidth() {
        return this.getItem().isAutoWidthOnFocus();
    }

    @Override
    public // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable Item.Layout getLayout() {
        return null;
    }

    @Override
    public @NonNull String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).appendSuper(super.toString()).append(this.state).build();
    }
}

