/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.cd.items.expert;

import ch.dvbern.tax.common.engine.wizarddisplay.DisplayItemUniqueID;
import ch.dvbern.tax.common.presentation.cd.items.ITableItem;
import ch.dvbern.tax.common.presentation.cd.items.ITableRow;
import ch.dvbern.tax.common.presentation.cd.items.common.AItem;
import ch.dvbern.tax.common.presentation.cd.items.expert.EButtonCell;
import ch.dvbern.tax.common.presentation.cd.items.expert.ELabelCellItem;
import ch.dvbern.tax.common.presentation.cd.items.expert.ELabelItem;
import ch.dvbern.tax.common.presentation.cd.items.expert.ETableItem;
import ch.dvbern.tax.common.presentation.cd.items.expert.EValueCell;
import ch.dvbern.tax.common.presentation.cd.items.expert.EValueItem;
import ch.dvbern.tax.common.transfer.dto.ExpertDisplayInfoDTO;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.graphics.Image;

public class ETableRow
extends AItem
implements ITableRow {
    private final ExpertDisplayInfoDTO.TableDTO.RowDTO row;
    private final List<Object> cols;
    private final ETableItem table;

    public ETableRow(ExpertDisplayInfoDTO.TableDTO.RowDTO row, List<ExpertDisplayInfoDTO.TableDTO.ColumnDTO> coldefs, float zoom, ETableItem table) {
        this.row = row;
        this.table = table;
        this.cols = new ArrayList<Object>();
        int i = 0;
        ExpertDisplayInfoDTO.TableDTO.ColumnDTO col = null;
        for (Object element : row.getValues()) {
            if (i < coldefs.size()) {
                col = coldefs.get(i);
            }
            if (col != null && col.isInputColumn()) {
                if (element instanceof ExpertDisplayInfoDTO.TableDTO.ValueCellDTO) {
                    this.cols.add(new EValueCell((ExpertDisplayInfoDTO.TableDTO.ValueCellDTO)element, col, zoom, row));
                } else if (element instanceof ExpertDisplayInfoDTO.TableDTO.ButtonCellDTO) {
                    if (row.isEmptyRow()) {
                        this.cols.add(null);
                    } else {
                        this.cols.add(new EButtonCell((ExpertDisplayInfoDTO.TableDTO.ButtonCellDTO)element, col, zoom, row));
                    }
                } else if (element instanceof ExpertDisplayInfoDTO.TableDTO.LabelCellDTO) {
                    this.cols.add(new ELabelCellItem((ExpertDisplayInfoDTO.TableDTO.LabelCellDTO)element, col, zoom, row));
                } else if (element instanceof ExpertDisplayInfoDTO.ValueItemDTO) {
                    this.cols.add(new EValueItem((ExpertDisplayInfoDTO.ValueItemDTO)element, null, null, zoom, !row.isEmptyRow()));
                } else if (element instanceof ExpertDisplayInfoDTO.LabelDTO) {
                    this.cols.add(new ELabelItem((ExpertDisplayInfoDTO.LabelDTO)element, zoom));
                } else {
                    this.cols.add(element);
                }
            }
            ++i;
        }
    }

    @Override
    public DisplayItemUniqueID getUID() {
        return this.row.getUniqueItemIdentifier();
    }

    @Override
    public boolean isDeletable() {
        return !this.row.isEmptyRow();
    }

    @Override
    public String getDmkTableEntry() {
        return this.row.getDataModelKey();
    }

    @Override
    public List<Object> getCells() {
        return this.cols;
    }

    @Override
    public Image getStateIcon() {
        return this.getStateImage(this.row.getState());
    }

    @Override
    public boolean isEmpty() {
        return this.row.isEmptyRow();
    }

    @Override
    public ITableItem getTable() {
        return this.table;
    }
}

