/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.cd.items.expert;

import ch.dvbern.tax.common.engine.wizarddisplay.DisplayItemUniqueID;
import ch.dvbern.tax.common.presentation.cd.TaxmeController;
import ch.dvbern.tax.common.presentation.cd.items.ITableItem;
import ch.dvbern.tax.common.presentation.cd.items.ITableRow;
import ch.dvbern.tax.common.presentation.cd.items.expert.AExpertItem;
import ch.dvbern.tax.common.presentation.cd.items.expert.ETableColumn;
import ch.dvbern.tax.common.presentation.cd.items.expert.ETableRow;
import ch.dvbern.tax.common.presentation.cd.util.OsSupport;
import ch.dvbern.tax.common.presentation.common.util.TableSort;
import ch.dvbern.tax.common.presentation.common.util.TableSortHelper;
import ch.dvbern.tax.common.transfer.dto.ExpertDisplayInfoDTO;
import ch.dvbern.tax.common.transfer.dto.WizardDisplayInfoDTO;
import ch.dvbern.tax.common.transfer.dto.convert.AbstractConverter;
import ch.dvbern.tax.common.transfer.failure.NotYetImplementedException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.eclipse.swt.graphics.Rectangle;

public class ETableItem
extends AExpertItem<ExpertDisplayInfoDTO.TableDTO, ExpertDisplayInfoDTO.TableDTO.CellDTO>
implements ITableItem {
    private final ExpertDisplayInfoDTO.TableDTO table;
    private final List<ETableColumn> coldefs;
    private List<ETableRow> rows;
    private ETableRow emptyRow = null;
    private List<ExpertDisplayInfoDTO.TableDTO.ColumnDTO> allCols;

    public ETableItem(ExpertDisplayInfoDTO.TableDTO table, float zoom) {
        super(table, zoom);
        this.table = table;
        List<ExpertDisplayInfoDTO.TableDTO.ColumnDTO> inputCols = table.getInputColumns();
        this.allCols = table.getAllColumns();
        if (table.isEnhanced()) {
            ExpertDisplayInfoDTO.TableDTO.ColumnDTO dummy = new ExpertDisplayInfoDTO.TableDTO.ColumnDTO("", 0, table.getWidth(), 0, table.isReadonly(), table.getTitleFont(), table.getBgColor(), null, null, false, null, 0, true, null, false, false, table.getUniqueItemIdentifier().appendLocal(".dummycolumn"), null, table.getTitleFont());
            inputCols = Collections.singletonList(dummy);
            this.allCols = inputCols;
        }
        this.coldefs = new ArrayList<ETableColumn>();
        for (ExpertDisplayInfoDTO.TableDTO.ColumnDTO element : inputCols) {
            this.coldefs.add(new ETableColumn(element, zoom));
        }
        this.initRows();
    }

    private void initRows() {
        this.rows = new ArrayList<ETableRow>();
        if (this.table.getInputRows() != null) {
            for (Object element2 : this.table.getInputRows()) {
                ExpertDisplayInfoDTO.TableDTO.RowDTO element = (ExpertDisplayInfoDTO.TableDTO.RowDTO)element2;
                if (element.isEmptyRow()) {
                    this.emptyRow = new ETableRow(element, this.allCols, this.getZoom(), this);
                    continue;
                }
                this.rows.add(new ETableRow(element, this.allCols, this.getZoom(), this));
            }
        }
    }

    @Override
    public @Nullable String getTitleKey() {
        return null;
    }

    @Override
    public String getAlign() {
        return "left";
    }

    @Override
    public boolean isEditable() {
        return this.table.isEditable();
    }

    @Override
    public @NonNull DisplayItemUniqueID getUID() {
        return this.table.getUniqueItemIdentifier();
    }

    public List<ETableColumn> getColdefs() {
        return this.coldefs;
    }

    public List<ETableRow> getRows() {
        return this.rows;
    }

    @Override
    public ITableRow getEmptyRow() {
        return this.emptyRow;
    }

    @Override
    public @Nullable Rectangle getBounds() {
        Rectangle bounds = super.getBounds();
        assert (bounds != null);
        bounds.x -= 22;
        bounds.width += 44;
        return bounds;
    }

    @Override
    public boolean isFirstColumnStatus() {
        return false;
    }

    @Override
    public int getRowHeigth() {
        if (this.table.isEnhanced()) {
            return Math.round(this.table.getRowHeight() * this.getZoom());
        }
        if (OsSupport.isMaxOsPpc()) {
            return 23;
        }
        if (OsSupport.isMaxOsIntel()) {
            return 24;
        }
        return 0;
    }

    @Override
    public boolean isVariableHeight() {
        return false;
    }

    @Override
    public boolean isHeaderVisible() {
        if (this.table.isEnhanced()) {
            return false;
        }
        return this.table.isHeaderVisible();
    }

    @Override
    public boolean isMoveToForeground() {
        return true;
    }

    @Override
    public boolean isVisible() {
        return true;
    }

    public ExpertDisplayInfoDTO.TableDTO getItem() {
        return this.table;
    }

    @Override
    public boolean isEnhanced() {
        return this.table.isEnhanced();
    }

    @Override
    public String getTableDmk() {
        return this.table.getDataModelKey();
    }

    @Override
    public void applySorts(Map<String, TableSort> tableSorts) {
        TaxmeController ctrl = TaxmeController.getInstance();
        AbstractConverter.ConverterContext ctx = new AbstractConverter.ConverterContext(ctrl.getLocalizationHelper(), ctrl.getTmoCdSession().getDataModel(), this.getTableDmk());
        TableSortHelper.sortTable((ExpertDisplayInfoDTO.TableDTO)this.table, (AbstractConverter.ConverterContext)ctx, tableSorts);
        this.initRows();
    }

    @Override
    public boolean isReadOnly() {
        return this.table.isReadonly();
    }

    @Override
    public @Nullable List<// Could not load outer class - annotation placement on inner may be incorrect
    WizardDisplayInfoDTO.LabelAddOnDTO> getLabelAddOns() {
        return null;
    }

    @Override
    public boolean getOnlyShowVisualizeButton() {
        throw new NotYetImplementedException("This is not implemented for expert tables ");
    }
}

