/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.cd.items.expert;

import ch.dvbern.tax.common.presentation.cd.expertdisplay.ExpertGuiUtil;
import ch.dvbern.tax.common.presentation.cd.items.expert.AExpertItem;
import ch.dvbern.tax.common.transfer.dto.ColorDTO;
import ch.dvbern.tax.common.transfer.dto.ExpertDisplayInfoDTO;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;

public abstract class ETableCell<CDTO extends ExpertDisplayInfoDTO.TableDTO.CellDTO>
extends AExpertItem<ExpertDisplayInfoDTO.ItemDTO, CDTO> {
    private final ExpertDisplayInfoDTO.TableDTO.ColumnDTO col;
    private final ExpertDisplayInfoDTO.TableDTO.RowDTO row;
    private final ExpertDisplayInfoDTO.TableDTO.CellDTO cell;

    protected ETableCell(CDTO cell, ExpertDisplayInfoDTO.TableDTO.ColumnDTO col, float zoom, ExpertDisplayInfoDTO.TableDTO.RowDTO row) {
        super(cell, zoom);
        this.cell = cell;
        this.col = col;
        this.row = row;
    }

    public String getAlign() {
        return this.col.getAlignmentString();
    }

    public int getMaxLength() {
        if (this.col.getRendererAndInputValidator() != null) {
            return this.col.getRendererAndInputValidator().getMaxLength();
        }
        return 100;
    }

    public int calcLength(String input) {
        if (this.col.getRendererAndInputValidator() != null) {
            return this.col.getRendererAndInputValidator().calcLength(input);
        }
        return input == null ? 0 : input.length();
    }

    public @Nullable String getRegularExpression() {
        if (this.col.getRendererAndInputValidator() != null) {
            return this.col.getRendererAndInputValidator().getUserInputRegExpPattern();
        }
        return null;
    }

    public boolean isValidateIfLeftEmpty() {
        return !this.row.isEmptyRow();
    }

    public @Nullable Object getOptionValue() {
        return null;
    }

    public int getType() {
        return this.col.getType();
    }

    public Font getFont() {
        return ExpertGuiUtil.getFont(this.cell.getFont(), this.getZoom());
    }

    @Override
    public @Nullable Color getBackgroundColor() {
        return this.getColor(this.getColumn().getBackground());
    }

    @Override
    public @Nullable Color getForegroundColor() {
        return BLACK;
    }

    protected ExpertDisplayInfoDTO.TableDTO.ColumnDTO getColumn() {
        return this.col;
    }

    protected ExpertDisplayInfoDTO.TableDTO.RowDTO getRow() {
        return this.row;
    }

    @Override
    public boolean isMoveToForeground() {
        return false;
    }

    @Override
    protected @Nullable Color getColor(ColorDTO color) {
        if (color == null) {
            return WHITE;
        }
        return super.getColor(color);
    }

    @Override
    public @NonNull String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append((Object)this.col).append((Object)this.row).append((Object)this.cell).build();
    }
}

