/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.cd.help.parser;

import ch.dvbern.tax.common.presentation.cd.help.parser.HelpContentHandler;
import java.io.File;
import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public final class HelpParser {
    private static final Logger LOG = LoggerFactory.getLogger(HelpParser.class);
    private static XMLReader saxReader = null;

    private HelpParser() {
    }

    public static void parse(File xmlFile) {
        try {
            if (saxReader == null) {
                SAXParserFactory spf = SAXParserFactory.newInstance();
                SAXParser saxParser = spf.newSAXParser();
                saxReader = saxParser.getXMLReader();
            }
            saxReader.setContentHandler(HelpContentHandler.getInstance());
            saxReader.parse(xmlFile.getPath());
        }
        catch (ParserConfigurationException e) {
            LOG.error("Error parsing XML help file: ", (Throwable)e);
        }
        catch (SAXException e) {
            LOG.error("Error parsing XML help file: ", (Throwable)e);
        }
        catch (IOException e) {
            LOG.error("Error parsing XML help file: ", (Throwable)e);
        }
    }
}

