/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.cd.help.parser;

import ch.dvbern.tax.common.presentation.cd.TaxmeConfig;
import ch.dvbern.tax.common.presentation.cd.help.model.HelpItem;
import ch.dvbern.tax.common.presentation.cd.help.model.HelpModel;
import ch.dvbern.tax.common.presentation.cd.help.model.HelpRoot;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HelpModelBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(HelpModelBuilder.class);
    private static HelpModelBuilder current = null;
    private Element rootElement;

    public static HelpModelBuilder singleton() {
        if (current == null) {
            return new HelpModelBuilder();
        }
        return current;
    }

    public void createRootElement(HelpModel model) {
        if (model != null) {
            this.rootElement = new Element("help");
            String id = model.getId();
            String nameFr = model.getNameFR();
            String nameDe = model.getNameDE();
            if (!HelpModelBuilder.isBlank(id)) {
                this.rootElement.setAttribute("id", id);
            }
            if (!HelpModelBuilder.isBlank(nameFr)) {
                this.rootElement.setAttribute("nameFR", nameFr);
            }
            if (!HelpModelBuilder.isBlank(nameDe)) {
                this.rootElement.setAttribute("nameDE", nameDe);
            }
            for (int i = 0; i < model.getRoots().size(); ++i) {
                this.addHelpRoot(model.getRoots().get(i));
            }
            this.saveXMLFile();
        }
    }

    public void addHelpRoot(HelpRoot helpRoot) {
        Element helpRootElement = new Element("helpRoot");
        String id = helpRoot.getId();
        String nameFr = helpRoot.getNameFR();
        String nameDe = helpRoot.getNameDE();
        if (!HelpModelBuilder.isBlank(id)) {
            helpRootElement.setAttribute("id", id);
        }
        if (!HelpModelBuilder.isBlank(nameFr)) {
            helpRootElement.setAttribute("nameFR", nameFr);
        }
        if (!HelpModelBuilder.isBlank(nameDe)) {
            helpRootElement.setAttribute("nameDE", nameDe);
        }
        for (int i = 0; i < helpRoot.getItems().size(); ++i) {
            this.addHelpItem(helpRootElement, helpRoot.getItems().get(i));
        }
        this.rootElement.addContent((Content)helpRootElement);
    }

    public void addHelpItem(Element parentItem, HelpItem item) {
        Element helpItemElement = new Element("helpItem");
        String id = item.getId();
        String nameFr = item.getNameFR();
        String nameDe = item.getNameDE();
        String topic = item.getTopic();
        if (!HelpModelBuilder.isBlank(id)) {
            helpItemElement.setAttribute("id", id);
        }
        if (!HelpModelBuilder.isBlank(nameFr)) {
            helpItemElement.setAttribute("nameFR", nameFr);
        }
        if (!HelpModelBuilder.isBlank(nameDe)) {
            helpItemElement.setAttribute("nameDE", nameDe);
        }
        helpItemElement.setAttribute("topic", topic);
        for (int i = 0; i < item.getItems().size(); ++i) {
            this.addHelpItem(helpItemElement, item.getItems().get(i));
        }
        parentItem.addContent((Content)helpItemElement);
    }

    public void saveXMLFile() {
        Document doc = new Document(this.rootElement);
        XMLOutputter outputter = new XMLOutputter(Format.getPrettyFormat());
        File model = new File(TaxmeConfig.getMainhelpDir() + "help.xml");
        if (model.exists()) {
            model.delete();
        }
        try {
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(model));
            outputter.output(doc, (OutputStream)out);
            ((OutputStream)out).flush();
            ((OutputStream)out).close();
        }
        catch (FileNotFoundException e) {
            LOG.error("Error saving XML help file: ", (Throwable)e);
        }
        catch (IOException e) {
            LOG.error("Error saving XML help file: ", (Throwable)e);
        }
    }

    private static boolean isBlank(String value) {
        return value == null || value.trim().isEmpty();
    }
}

