/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.cd.help.model;

import ch.dvbern.tax.common.presentation.cd.TaxmeController;
import ch.dvbern.tax.common.presentation.cd.help.event.IModelChangedListener;
import ch.dvbern.tax.common.presentation.cd.help.model.HelpItem;
import ch.dvbern.tax.common.presentation.cd.help.model.IHelpTopic;
import java.util.ArrayList;
import java.util.List;

public class HelpRoot
implements IHelpTopic {
    private String id = null;
    private String nameFR = null;
    private String nameDE = null;
    private final ArrayList<IModelChangedListener> listeners;
    private List<HelpItem> items = new ArrayList<HelpItem>();

    public HelpRoot() {
        this.listeners = new ArrayList();
    }

    public String getNameDE() {
        return this.nameDE;
    }

    public void setNameDE(String nameDE) {
        this.nameDE = nameDE;
    }

    public String getNameFR() {
        return this.nameFR;
    }

    public void setNameFR(String nameFR) {
        this.nameFR = nameFR;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Override
    public List<HelpItem> getItems() {
        return this.items;
    }

    public void setItems(List<HelpItem> items) {
        this.items = items;
    }

    public void addItem(HelpItem item) {
        this.items.add(item);
        this.fireModelChanged("add");
    }

    public String getName() {
        if (TaxmeController.getInstance().getLanguage().equals("fr")) {
            return this.getNameFR();
        }
        return this.getNameDE();
    }

    public void newRoot(HelpItem item) {
        this.addItem(item);
    }

    public void addModelChangedListener(IModelChangedListener listener) {
        this.listeners.add(listener);
    }

    public void removeModelChangedListener(IModelChangedListener listener) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            if (this.listeners.get(i) != listener) continue;
            this.listeners.remove(listener);
        }
    }

    private void fireModelChanged(String action) {
        for (IModelChangedListener listener : this.listeners) {
            listener.refreshView(this, action);
        }
    }

    @Override
    public IHelpTopic getParent() {
        return null;
    }
}

