/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.cd.help.gui;

import ch.dvbern.tax.common.presentation.cd.Messages;
import ch.dvbern.tax.common.presentation.cd.TaxmeConfig;
import ch.dvbern.tax.common.presentation.cd.TaxmeController;
import ch.dvbern.tax.common.presentation.cd.action.menu.HelpAboutAction;
import ch.dvbern.tax.common.presentation.cd.help.action.BackAction;
import ch.dvbern.tax.common.presentation.cd.help.action.ExitAction;
import ch.dvbern.tax.common.presentation.cd.help.action.ForwardAction;
import ch.dvbern.tax.common.presentation.cd.help.action.HelpIndexAction;
import ch.dvbern.tax.common.presentation.cd.help.action.HelpTaxmeAction;
import ch.dvbern.tax.common.presentation.cd.help.action.HelpWegleitungAction;
import ch.dvbern.tax.common.presentation.cd.help.gui.model.HelpTreeContentProvider;
import ch.dvbern.tax.common.presentation.cd.help.gui.model.HelpTreeLabelProvider;
import ch.dvbern.tax.common.presentation.cd.help.model.HelpItem;
import ch.dvbern.tax.common.presentation.cd.help.model.HelpModel;
import ch.dvbern.tax.common.presentation.cd.help.model.HelpRoot;
import ch.dvbern.tax.common.presentation.cd.help.parser.HelpContentHandler;
import ch.dvbern.tax.common.presentation.cd.resourcetools.IToolCommunicationGui;
import ch.dvbern.tax.common.presentation.cd.resourcetools.action.ToolEditOnMainHelpAction;
import ch.dvbern.tax.common.presentation.cd.resourcetools.action.ToolHelpIndexAction;
import ch.dvbern.tax.common.presentation.cd.resourcetools.action.ToolHelpTreeStructureAction;
import ch.dvbern.tax.common.presentation.cd.resourcetools.action.ToolHtmlEditorSetAction;
import ch.dvbern.tax.common.presentation.cd.util.BrowserNotSupportedException;
import ch.dvbern.tax.common.presentation.cd.util.BrowserUtil;
import ch.dvbern.tax.common.transfer.failure.ApplicationException;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.action.CoolBarManager;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.StatusLineManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.window.ApplicationWindow;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationAdapter;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Sash;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HelpApplication
extends ApplicationWindow
implements SelectionListener,
ISelectionChangedListener,
IToolCommunicationGui {
    private static final Logger LOG = LoggerFactory.getLogger(HelpApplication.class);
    private final ExitAction exitAction;
    private final HelpAboutAction helpAction;
    private final BackAction backAction = new BackAction(this);
    private final ForwardAction forwardAction = new ForwardAction(this);
    private final HelpIndexAction helpIndexAction;
    private final HelpTaxmeAction helpTaxmeAction;
    private final HelpWegleitungAction helpWegleitungAction;
    private final HelpModel helpModel;
    private Browser browser;
    private TabFolder tabFolder;
    private TreeViewer viewer;
    private final ArrayList<TreeViewer> viewers;
    private boolean helpIndexEnable;
    private final Object[] selections = new Object[]{"", "", "", "", "", "", "", "", ""};
    private ExplicitHelpItem explicitHelpItem = null;

    public HelpApplication(Shell shell, String initialHelpItemId) {
        super(shell);
        String indexEnable = TaxmeConfig.getString("HelpIndexEnabled");
        this.helpIndexEnable = indexEnable == null || !indexEnable.equals("false");
        this.helpModel = HelpContentHandler.getInstance().getHelpModel();
        this.exitAction = new ExitAction(this);
        this.helpAction = new HelpAboutAction();
        this.helpIndexAction = new HelpIndexAction(this);
        this.helpTaxmeAction = new HelpTaxmeAction(this);
        this.helpWegleitungAction = new HelpWegleitungAction(this);
        this.viewers = new ArrayList();
        this.addMenuBar();
        this.addCoolBar(0);
        this.addStatusLine();
        this.explicitHelpItem = initialHelpItemId != null && !"".equals(initialHelpItemId) ? new ExplicitHelpItem(initialHelpItemId) : null;
    }

    public HelpApplication(Shell shell) {
        this(shell, null);
    }

    @Override
    public String toolGetCurrentShortHelpFileNameOnField(String sKey) {
        return null;
    }

    protected Control createContents(Composite parent) {
        this.getShell().setText(Messages.configurableTranslate("taxme.cd.help.title", new Object[0]));
        this.getShell().setSize(800, 600);
        int size = this.helpModel.getRoots().size();
        if (!this.helpIndexEnable) {
            --size;
        }
        Composite main = new Composite(parent, 0);
        main.setLayout((Layout)new FormLayout());
        Sash sash = new Sash(main, 512);
        sash.addSelectionListener((SelectionListener)this);
        FormData data = new FormData();
        data.top = new FormAttachment(0, 0);
        data.bottom = new FormAttachment(100, 0);
        data.left = new FormAttachment(30, 0);
        sash.setLayoutData((Object)data);
        Composite navigationPart = new Composite(main, 2048);
        data = new FormData();
        data.top = new FormAttachment(0, 0);
        data.bottom = new FormAttachment(100, 0);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)sash, 0);
        navigationPart.setLayoutData((Object)data);
        Composite viewPart = new Composite(main, 2048);
        data = new FormData();
        data.top = new FormAttachment(0, 0);
        data.bottom = new FormAttachment(100, 0);
        data.left = new FormAttachment((Control)sash, 0);
        data.right = new FormAttachment(100, 0);
        viewPart.setLayoutData((Object)data);
        viewPart.setLayout((Layout)new FillLayout());
        this.tabFolder = new TabFolder(navigationPart, 128);
        navigationPart.setLayout((Layout)new FillLayout());
        try {
            this.browser = BrowserUtil.createBrowser(viewPart, false);
        }
        catch (BrowserNotSupportedException e) {
            throw new ApplicationException("Failed to create browser window.", (Throwable)e);
        }
        this.browser.addLocationListener((LocationListener)new LocationAdapter(){

            public void changed(LocationEvent arg0) {
                HelpApplication.this.backAction.setEnabled(HelpApplication.this.browser.isBackEnabled());
                HelpApplication.this.forwardAction.setEnabled(HelpApplication.this.browser.isForwardEnabled());
            }
        });
        for (int i = 0; i < size; ++i) {
            HelpRoot root = this.helpModel.getRoots().get(i);
            TabItem item = new TabItem(this.tabFolder, 0);
            item.setText(root.getName());
            Composite composite = new Composite((Composite)this.tabFolder, 2048);
            composite.setLayout((Layout)new FillLayout());
            item.setControl((Control)composite);
            this.createViewer((Composite)item.getControl(), root);
            if (this.explicitHelpItem == null || root != this.explicitHelpItem.root) continue;
            this.tabFolder.setSelection(item);
        }
        parent.layout();
        return main;
    }

    public void widgetSelected(SelectionEvent e) {
        Sash sash = (Sash)e.getSource();
        ((FormData)sash.getLayoutData()).left = new FormAttachment(0, e.x);
        sash.getParent().layout();
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    protected MenuManager createMenuManager() {
        String sToolsEnabled;
        MenuManager menuBar = new MenuManager("");
        MenuManager menuFile = new MenuManager(Messages.configurableTranslate("menu.file", new Object[0]), "menu.file");
        MenuManager menuHelp = new MenuManager(Messages.configurableTranslate("menu.help", new Object[0]), "menu.help");
        MenuManager menuNavigate = new MenuManager(Messages.configurableTranslate("menu.navigate", new Object[0]), "menu.navigate");
        MenuManager menuTools = null;
        menuBar.add((IContributionItem)menuFile);
        menuBar.add((IContributionItem)menuNavigate);
        menuBar.add((IContributionItem)menuHelp);
        menuFile.add((IAction)this.exitAction);
        menuFile.add((IContributionItem)new Separator());
        menuHelp.add((IAction)this.helpAction);
        menuNavigate.add((IAction)this.backAction);
        menuNavigate.add((IAction)this.forwardAction);
        menuNavigate.add((IContributionItem)new Separator());
        menuNavigate.add((IAction)this.helpWegleitungAction);
        menuNavigate.add((IAction)this.helpTaxmeAction);
        if (this.helpIndexEnable) {
            menuNavigate.add((IAction)this.helpIndexAction);
        }
        if ((sToolsEnabled = TaxmeConfig.getString("ToolsEnabled")) != null && sToolsEnabled.equals("true")) {
            menuTools = new MenuManager(Messages.configurableTranslate("menu.tools", new Object[0]), "menu.tools");
            menuBar.add((IContributionItem)menuTools);
            ToolHelpIndexAction toolHelpIndexAction = new ToolHelpIndexAction(this);
            menuTools.add((IAction)toolHelpIndexAction);
            ToolHelpTreeStructureAction toolHelpTreeStructureAction = new ToolHelpTreeStructureAction(this);
            menuTools.add((IAction)toolHelpTreeStructureAction);
            ToolEditOnMainHelpAction toolEditOnMainHelpAction = new ToolEditOnMainHelpAction(this);
            menuTools.add((IAction)toolEditOnMainHelpAction);
            ToolHtmlEditorSetAction toolHtmlEditorSetAction = new ToolHtmlEditorSetAction(this);
            menuTools.add((IAction)toolHtmlEditorSetAction);
        }
        return menuBar;
    }

    protected CoolBarManager createCoolBarManager(int style) {
        CoolBarManager coolBarManager = new CoolBarManager(style);
        ToolBarManager tbm = new ToolBarManager(0x800040);
        tbm.add((IAction)this.backAction);
        tbm.add((IAction)this.forwardAction);
        this.backAction.setEnabled(false);
        this.forwardAction.setEnabled(false);
        coolBarManager.add((IToolBarManager)tbm);
        return coolBarManager;
    }

    protected StatusLineManager createStatusLineManager() {
        return new StatusLineManager();
    }

    private void createViewer(Composite itemComposite, HelpRoot root) {
        final TreeViewer viewer = new TreeViewer(itemComposite, 770);
        viewer.addTreeListener(new ITreeViewerListener(){

            public void treeExpanded(TreeExpansionEvent evt) {
                ((HelpTreeLabelProvider)viewer.getLabelProvider()).changeSomeState(evt.getElement(), 2);
            }

            public void treeCollapsed(TreeExpansionEvent evt) {
                ((HelpTreeLabelProvider)viewer.getLabelProvider()).changeSomeState(evt.getElement(), 1);
            }
        });
        this.viewer = viewer;
        this.viewers.add(viewer);
        HelpTreeContentProvider contentProvider = new HelpTreeContentProvider();
        viewer.setContentProvider((IContentProvider)contentProvider);
        HelpTreeLabelProvider labelProvider = new HelpTreeLabelProvider();
        viewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        viewer.setInput((Object)root);
        viewer.addSelectionChangedListener((ISelectionChangedListener)this);
        if (this.explicitHelpItem != null && root == this.explicitHelpItem.root) {
            viewer.expandToLevel((Object)this.explicitHelpItem.helpItem, -1);
            StructuredSelection select = new StructuredSelection((Object)this.explicitHelpItem.helpItem);
            viewer.setSelection((ISelection)select, true);
        }
    }

    public TreeViewer getViewer() {
        return this.viewer;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.viewer = (TreeViewer)event.getSource();
        if (this.viewer.getSelection() instanceof StructuredSelection) {
            StructuredSelection selection = (StructuredSelection)this.viewer.getSelection();
            if (this.selections[4].equals("")) {
                this.selections[4] = selection;
            } else {
                this.selections[5] = selection;
                System.arraycopy(this.selections, 1, this.selections, 0, this.selections.length - 1);
            }
            if (!selection.isEmpty()) {
                HelpItem itemSelected = (HelpItem)selection.getFirstElement();
                this.displayHTML(itemSelected);
            }
            this.getShell().forceFocus();
        }
    }

    public Object[] getSelections() {
        return this.selections;
    }

    public void showCurrent() {
        this.displayHTML();
    }

    private void displayHTML(String topicFilename) {
        String mainHelpDir = this.toolGetCurrentMainHelpDirectory() + this.toolGetCurrentLanguage();
        try {
            URL url = new URL("file:" + mainHelpDir + File.separator + topicFilename);
            File file = new File(url.getFile());
            if (file.exists() && !file.isDirectory()) {
                String newUrl = url.toExternalForm();
                if (!newUrl.equals(this.browser.getUrl())) {
                    this.browser.setUrl(newUrl);
                }
            } else {
                this.browser.setUrl("about:blank");
            }
        }
        catch (MalformedURLException e) {
            LOG.error("Errro displaying HTML help: ", (Throwable)e);
        }
    }

    private void displayHTML() {
        if (this.explicitHelpItem != null) {
            this.displayHTML(this.explicitHelpItem.helpItem);
            this.explicitHelpItem = null;
            return;
        }
        String fileName = TaxmeController.getInstance().getApp().toolGetCurrentMainHelpFileName();
        if (fileName == null || fileName.equals("")) {
            fileName = "0001.htm";
        }
        this.displayHTML(fileName);
    }

    private void displayHTML(HelpItem item) {
        this.displayHTML(item.getTopic());
    }

    public Browser getBrowser() {
        return this.browser;
    }

    public TabFolder getTabFolder() {
        return this.tabFolder;
    }

    @Override
    public Map<?, ?> toolGetAllNlsErrorMessages() {
        return null;
    }

    @Override
    public List<?> toolGetAvailableLanguages() {
        return null;
    }

    @Override
    public String toolGetCurrentFullHTMLFileName() {
        if (this.viewer.getSelection() instanceof StructuredSelection) {
            StructuredSelection selection = (StructuredSelection)this.viewer.getSelection();
            HelpItem itemSelected = (HelpItem)selection.getFirstElement();
            String mainHelpDir = this.toolGetCurrentMainHelpDirectory();
            return new File(mainHelpDir + File.separator + itemSelected.getTopic()).getAbsolutePath();
        }
        return null;
    }

    @Override
    public String toolGetCurrentLanguage() {
        return TaxmeController.getInstance().getLanguage();
    }

    @Override
    public String toolGetCurrentMainHelpDirectory() {
        return TaxmeConfig.getMainhelpDir();
    }

    @Override
    public String toolGetCurrentMainHelpFileName() {
        String s = this.browser.getUrl();
        try {
            URL file = new URL(s);
            String fileName = new File(file.getFile()).getName();
            return fileName;
        }
        catch (MalformedURLException e) {
            LOG.error("Errro getting current mainHelp file name: ", (Throwable)e);
            return "";
        }
    }

    @Override
    public String toolGetCurrentMainHelpName() {
        return null;
    }

    @Override
    public List<?> toolGetCurrentScreenErrorIds() {
        return null;
    }

    @Override
    public String toolGetCurrentScreenName() {
        return null;
    }

    @Override
    public String toolGetCurrentShortHelpDirectory() {
        return null;
    }

    @Override
    public String toolGetCurrentShortHelpFileName() {
        return null;
    }

    @Override
    public String toolGetFullHtmlEditorName() {
        return TaxmeConfig.getString("ToolHtmlEditorName");
    }

    @Override
    public List<?> toolGetGuiModelAsVector(String sFileName) {
        return null;
    }

    @Override
    public HashMap<?, ?> toolGetGuiModelConfigEntries() {
        return null;
    }

    @Override
    public HelpRoot toolGetMainHelpIndexModel() {
        return this.helpModel.getRoots().get(2);
    }

    @Override
    public HelpRoot toolGetMainHelpModel() {
        if (this.tabFolder.getSelectionIndex() == 0) {
            return this.helpModel.getRoots().get(0);
        }
        if (this.tabFolder.getSelectionIndex() == 1) {
            return this.helpModel.getRoots().get(1);
        }
        return this.helpModel.getRoots().get(2);
    }

    @Override
    public List<?> toolGetNavigationFromFile() {
        return null;
    }

    @Override
    public HashMap<?, ?> toolGetNavigationNls() {
        return null;
    }

    @Override
    public boolean toolIsErrorsWarningsEnabled() {
        return false;
    }

    @Override
    public boolean toolIsGuiModelsEnabled() {
        return false;
    }

    @Override
    public boolean toolIsHelpIndexEnabled() {
        return true;
    }

    @Override
    public boolean toolIsHelpMappingEnabled() {
        return false;
    }

    @Override
    public boolean toolIsHelpTreestructureEnabled() {
        return true;
    }

    @Override
    public boolean toolIsHtmlEditOnMainHelpEnabled() {
        String sMainHelpEnabled = TaxmeConfig.getString("ToolEditMainHelpEnabled");
        return sMainHelpEnabled != null && sMainHelpEnabled.equals("true");
    }

    @Override
    public boolean toolIsHtmlEditOnMainPanelHelpEnabled() {
        return false;
    }

    @Override
    public boolean toolIsHtmlEditOnShortHelpEnabled() {
        return false;
    }

    @Override
    public boolean toolIsMainNavigationEnabled() {
        return false;
    }

    @Override
    public void toolRefreshCurrentHTML() {
        this.browser.refresh();
    }

    @Override
    public void toolRefreshErrorsWarnings() {
    }

    @Override
    public void toolRefreshGuiModels() {
    }

    @Override
    public void toolRefreshHelpMappings() {
    }

    @Override
    public void toolRefreshNavigation() {
    }

    @Override
    public void toolRefreshTreeSructures() {
        for (TreeViewer viewer : this.viewers) {
            StructuredSelection selection;
            viewer.refresh();
            if (!(viewer.getSelection() instanceof StructuredSelection) || (selection = (StructuredSelection)viewer.getSelection()).isEmpty()) continue;
            HelpItem itemSelected = (HelpItem)selection.getFirstElement();
            this.displayHTML(itemSelected);
        }
        this.getShell().forceFocus();
    }

    @Override
    public void toolSaveAllNlsErrorMessages(Map allNlsErrorMessages) {
    }

    @Override
    public void toolSaveGuiModelFromVector(List vGuiModel, String sFileName) {
    }

    @Override
    public void toolSaveHelpMapping(String mainHelp, String shortHelp) {
    }

    @Override
    public void toolSaveHtmlEditorName(String sFile) {
        TaxmeConfig.setValue("ToolHtmlEditorName", sFile);
    }

    @Override
    public void toolSaveMainHelpIndexTree(HelpItem root) {
    }

    @Override
    public void toolSaveMainHelpTrees(HelpItem root) {
    }

    @Override
    public void toolSaveNavigationNls(HashMap navigationNls) {
    }

    @Override
    public Shell getCallBackShell() {
        return this.getShell();
    }

    public void back() {
        this.browser.back();
    }

    public void forward() {
        this.browser.forward();
    }

    public ExplicitHelpItem getExplicitHelpItem() {
        return this.explicitHelpItem;
    }

    protected void setExplicitHelpItem(ExplicitHelpItem explicitHelpItem) {
        this.explicitHelpItem = explicitHelpItem;
    }

    private class ExplicitHelpItem {
        private final String helpId;
        private final HelpRoot root;
        private final LinkedList<HelpItem> path = new LinkedList();
        private final HelpItem helpItem;

        public ExplicitHelpItem(String helpId) {
            this.helpId = helpId;
            for (HelpRoot searchRoot : HelpApplication.this.helpModel.getRoots()) {
                HelpItem recursiveItem = this.findPath(searchRoot.getItems(), this.path);
                if (recursiveItem == null) continue;
                this.root = searchRoot;
                this.helpItem = recursiveItem;
                return;
            }
            this.root = null;
            this.helpItem = null;
        }

        private HelpItem findPath(List<HelpItem> items, LinkedList<HelpItem> currentPath) {
            for (HelpItem item : items) {
                currentPath.add(item);
                if (this.helpId.equals(item.getId())) {
                    return item;
                }
                HelpItem recursiveItem = this.findPath(item.getItems(), currentPath);
                if (recursiveItem != null) {
                    return recursiveItem;
                }
                currentPath.removeLast();
            }
            return null;
        }
    }
}

