/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.cd.builders.wizard;

import ch.dvbern.tax.common.engine.wizarddisplay.DisplayItemUniqueID;
import ch.dvbern.tax.common.presentation.cd.Messages;
import ch.dvbern.tax.common.presentation.cd.TaxmeController;
import ch.dvbern.tax.common.presentation.cd.builders.ControlPanelHolder;
import ch.dvbern.tax.common.presentation.cd.builders.Director;
import ch.dvbern.tax.common.presentation.cd.builders.IControlBuilder;
import ch.dvbern.tax.common.presentation.cd.builders.common.AControlBuilder;
import ch.dvbern.tax.common.presentation.cd.builders.wizard.WButtonBuilder;
import ch.dvbern.tax.common.presentation.cd.builders.wizard.WLabelBuilder;
import ch.dvbern.tax.common.presentation.cd.builders.wizard.WSectionHeaderBuilder;
import ch.dvbern.tax.common.presentation.cd.builders.wizard.WSeparatorBuilder;
import ch.dvbern.tax.common.presentation.cd.builders.wizard.WTableBuilder;
import ch.dvbern.tax.common.presentation.cd.builders.wizard.WValueBuilder;
import ch.dvbern.tax.common.presentation.cd.util.ControlReuseUtil;
import ch.dvbern.tax.common.presentation.cd.util.GuiUtil;
import ch.dvbern.tax.common.presentation.cd.widgets.BorderedLabel;
import ch.dvbern.tax.common.presentation.cd.widgets.BorderedLabelStyledText;
import ch.dvbern.tax.common.transfer.dto.WizardDisplayInfoDTO;
import ch.dvbern.tax.common.transfer.dto.convert.AbstractConverter;
import ch.dvbern.tax.common.transfer.util.WizardLabelAddOnHelper;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WSectionBuilder
extends AControlBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(WSectionBuilder.class);
    private static final Director director = new Director();
    private static final WSectionHeaderBuilder sectionHeaderBuilder = new WSectionHeaderBuilder();
    private static final WSeparatorBuilder separatorBuilder = new WSeparatorBuilder();
    private static final WLabelBuilder labelBuilder = new WLabelBuilder();
    private static final WButtonBuilder buttonBuilder = new WButtonBuilder();
    private static final WValueBuilder valueBuilder = new WValueBuilder();
    private static final WTableBuilder tableBuilder = new WTableBuilder();
    private BorderedLabelStyledText label;
    private WizardDisplayInfoDTO.SectionItemDTO sectionItemDTO;
    private ControlPanelHolder sectionHolder;
    private ControlReuseUtil.CompositeAndControlReuseUtil sectionCRU;
    private int[] columns;

    public void init(WizardDisplayInfoDTO.SectionItemDTO sectionDTO) {
        this.sectionItemDTO = sectionDTO;
        this.label = null;
        this.sectionHolder = null;
        this.sectionCRU = null;
        this.columns = null;
    }

    @Override
    public Control getControl() {
        return this.label;
    }

    @Override
    public void createControl() {
        List listRows;
        if (this.sectionItemDTO.getState() == 12) {
            return;
        }
        this.createSectionCRU();
        this.sectionCRU.getControlReuseUtil().start();
        if (this.sectionItemDTO.getHeader() != null) {
            this.createHeader();
        }
        this.createColDefs();
        if (this.sectionItemDTO.getHeaders() != null && !this.sectionItemDTO.getHeaders().isEmpty()) {
            this.createHeaders();
        }
        if ((listRows = this.sectionItemDTO.getRows()) != null) {
            for (WizardDisplayInfoDTO.RowItemDTO rowItemDTO : listRows) {
                if (12 == rowItemDTO.getState()) continue;
                List<Integer> gridRow = this.getGridRow(this.columns, rowItemDTO.getCols());
                List cols = rowItemDTO.getCols();
                if (cols == null) continue;
                for (int i = 0; i < cols.size(); ++i) {
                    WizardDisplayInfoDTO.AbstractItemDTO element = (WizardDisplayInfoDTO.AbstractItemDTO)cols.get(i);
                    Integer size = gridRow.get(i) != null ? gridRow.get(i) : null;
                    this.createElement(element, size);
                }
            }
        }
        this.sectionCRU.getControlReuseUtil().end();
        this.sectionCRU.getComposite().layout();
    }

    private void createSectionCRU() {
        this.sectionCRU = this.controlReuseUtil.getCompositeAndControlReuseUtil(this.sectionItemDTO.getUniqueItemIdentifier());
        if (this.sectionCRU == null) {
            this.sectionCRU = this.controlReuseUtil.addComposite(this.sectionItemDTO.getUniqueItemIdentifier(), new Composite(this.parent, 0), new ControlReuseUtil());
            GridData gdSection = new GridData(768);
            this.sectionCRU.getComposite().setLayoutData((Object)gdSection);
            this.sectionCRU.getComposite().setBackground(GuiUtil.getColorRegistry().get(GuiUtil.COLOR_WHITE));
            this.sectionHolder = new ControlPanelHolder(this.sectionCRU.getComposite(), this.sectionCRU.getControlReuseUtil());
            separatorBuilder.init();
            this.buildControl(separatorBuilder);
        } else {
            this.sectionHolder = new ControlPanelHolder(this.sectionCRU.getComposite(), this.sectionCRU.getControlReuseUtil());
        }
    }

    private void createColDefs() {
        this.columns = this.getGridArray(this.sectionItemDTO.getColdefs());
        GridLayout layoutSection = new GridLayout(this.columns.length, false);
        layoutSection.horizontalSpacing = 2;
        layoutSection.verticalSpacing = 2;
        layoutSection.marginWidth = 0;
        this.sectionCRU.getComposite().setLayout((Layout)layoutSection);
        for (int i = 0; i < this.columns.length; ++i) {
            DisplayItemUniqueID id = new DisplayItemUniqueID(WSectionBuilder.class.getSimpleName(), "SectionCol." + i);
            Label label = (Label)this.sectionCRU.getControlReuseUtil().getControl(id);
            if (label == null) {
                label = new Label(this.sectionCRU.getComposite(), 64);
                label.setBackground(GuiUtil.getColorRegistry().get(GuiUtil.COLOR_WHITE));
                this.sectionCRU.getControlReuseUtil().addControl(id, (Control)label);
            }
            GridData gd = new GridData();
            if (this.columns[i] != Integer.MAX_VALUE) {
                gd.widthHint = this.columns[i];
            } else {
                gd.grabExcessHorizontalSpace = true;
            }
            label.setLayoutData((Object)gd);
        }
    }

    private void createHeader() {
        if (this.sectionItemDTO.getHeader() == null) {
            return;
        }
        DisplayItemUniqueID id = this.sectionItemDTO.getUniqueItemIdentifier().appendLocal(".header");
        BorderedLabel label = (BorderedLabel)this.controlReuseUtil.getControl(id);
        if (label == null) {
            int colspan = this.sectionItemDTO.getCntCols();
            label = new BorderedLabel(this.sectionCRU.getComposite(), 2, 1, colspan, null, 64);
            this.controlReuseUtil.addControl(id, (Control)label);
            label.setForeground(GuiUtil.getColorRegistry().get(GuiUtil.COLOR_SECTION_HEADER_FOREGROUND));
            label.setFont(GuiUtil.getFontRegistry().get("font.header.table"));
        }
        TaxmeController ctrl = TaxmeController.getInstance();
        AbstractConverter.ConverterContext ctx = new AbstractConverter.ConverterContext(ctrl.getLocalizationHelper(), ctrl.getTmoCdSession().getDataModel(), null);
        Object[] args = WizardLabelAddOnHelper.getReplacements((List)this.sectionItemDTO.getHeaderAddOns(), (AbstractConverter.ConverterContext)ctx);
        label.setText(Messages.configurableTranslate(this.sectionItemDTO.getHeader(), (Control)label.getNestedLabel(), args));
        label.setData(this.sectionItemDTO.getHeader());
        boolean isVisible = this.sectionItemDTO.getState() != 11;
        Color background = isVisible ? GuiUtil.getColorRegistry().get(GuiUtil.COLOR_SECTION_HEADER_BACKGROUND) : GuiUtil.getColorRegistry().get(GuiUtil.COLOR_SECTION_HEADER_BACKGROUND_TRANSPARENT);
        label.setBackground(background);
    }

    private void createHeaders() {
        List listHeaders = this.sectionItemDTO.getHeaders();
        List<Integer> gridHeaders = this.getGridHeader(this.columns, listHeaders);
        for (int i = 0; i < listHeaders.size(); ++i) {
            WizardDisplayInfoDTO.HeaderItemDTO header = (WizardDisplayInfoDTO.HeaderItemDTO)listHeaders.get(i);
            Integer width = gridHeaders.get(i) != null ? gridHeaders.get(i) : null;
            sectionHeaderBuilder.init(header, width);
            this.buildControl(sectionHeaderBuilder);
        }
    }

    private void createElement(WizardDisplayInfoDTO.AbstractItemDTO element, Integer width) {
        if (element instanceof WizardDisplayInfoDTO.LabelItemDTO) {
            WizardDisplayInfoDTO.LabelItemDTO labelItemDTO = (WizardDisplayInfoDTO.LabelItemDTO)element;
            labelBuilder.init(labelItemDTO, width);
            this.buildControl(labelBuilder);
        } else if (element instanceof WizardDisplayInfoDTO.ItemItemDTO) {
            WizardDisplayInfoDTO.ItemItemDTO itemItemDTO = (WizardDisplayInfoDTO.ItemItemDTO)element;
            valueBuilder.init(itemItemDTO, width);
            this.buildControl(valueBuilder);
        } else if (element instanceof WizardDisplayInfoDTO.ButtonDTO) {
            WizardDisplayInfoDTO.ButtonDTO buttonDTO = (WizardDisplayInfoDTO.ButtonDTO)element;
            buttonBuilder.init(buttonDTO);
            this.buildControl(buttonBuilder);
        } else if (element instanceof WizardDisplayInfoDTO.TableItemDTO) {
            WizardDisplayInfoDTO.TableItemDTO tableItemDTO = (WizardDisplayInfoDTO.TableItemDTO)element;
            tableBuilder.init(tableItemDTO, width);
        } else {
            LOG.warn("unsupported displayitem: " + String.valueOf(element.getClass()));
        }
    }

    private int[] getGridArray(List<WizardDisplayInfoDTO.ColDefItemDTO> coldefs) {
        if (coldefs == null) {
            return new int[]{Integer.MAX_VALUE};
        }
        int[] grid = new int[coldefs.size()];
        for (int i = 0; i < coldefs.size(); ++i) {
            WizardDisplayInfoDTO.ColDefItemDTO coldef = coldefs.get(i);
            grid[i] = !coldef.isWidthUndefined() ? Integer.parseInt(coldef.getWidth()) : Integer.MAX_VALUE;
        }
        return grid;
    }

    private List<Integer> getGridHeader(int[] grid, List<WizardDisplayInfoDTO.HeaderItemDTO> headers) {
        ArrayList<Integer> gridHeader = new ArrayList<Integer>();
        int iGrid = 0;
        for (WizardDisplayInfoDTO.HeaderItemDTO headerItemDTO : headers) {
            int length = 0;
            if (headerItemDTO.getColspan() >= 1) {
                int i = 0;
                while (i < headerItemDTO.getColspan()) {
                    length = length != Integer.MAX_VALUE && grid[iGrid] != Integer.MAX_VALUE ? (length += grid[iGrid]) : Integer.MAX_VALUE;
                    ++i;
                    ++iGrid;
                }
            }
            gridHeader.add(length == Integer.MAX_VALUE ? null : Integer.valueOf(length));
        }
        return gridHeader;
    }

    private List<Integer> getGridRow(int[] grid, List<? extends WizardDisplayInfoDTO.AbstractItemDTO> cols) {
        ArrayList<Integer> gridRow = new ArrayList<Integer>();
        int iGrid = 0;
        for (int iRow = 0; cols != null && iRow < cols.size(); ++iRow) {
            WizardDisplayInfoDTO.AbstractItemDTO element = cols.get(iRow);
            int length = 0;
            if (element instanceof WizardDisplayInfoDTO.RowContent) {
                WizardDisplayInfoDTO.RowContent labelItemDTO = (WizardDisplayInfoDTO.RowContent)element;
                if (labelItemDTO.getColspan() >= 1) {
                    int i = 0;
                    while (i < labelItemDTO.getColspan()) {
                        length = length != Integer.MAX_VALUE && grid[iGrid] != Integer.MAX_VALUE ? (length += grid[iGrid]) : Integer.MAX_VALUE;
                        ++i;
                        ++iGrid;
                    }
                }
            } else {
                LOG.warn("unsupported displayitem: " + String.valueOf(element.getClass()));
            }
            gridRow.add(length == Integer.MAX_VALUE ? null : Integer.valueOf(length));
        }
        return gridRow;
    }

    private void buildControl(IControlBuilder builder) {
        director.init(builder, this.sectionHolder);
        director.createControl();
    }
}

