/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.cd.action;

import ch.dvbern.tax.common.presentation.cd.TaxmeController;
import ch.dvbern.tax.common.presentation.cd.dialog.DeleteWarningDialog;
import ch.dvbern.tax.common.transfer.dto.ExpertDisplayInfoDTO;
import ch.dvbern.tax.common.transfer.dto.MessageItemDTO;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import ch.dvbern.tax.common.transfer.dto.WizardDisplayInfoDTO;
import ch.dvbern.tax.common.transfer.dto.convert.AbstractConverter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.widgets.Display;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidateAction
extends Action {
    private static final Logger LOG = LoggerFactory.getLogger(ValidateAction.class);

    public void execute(ExpertDisplayInfoDTO formItemDTO) {
        Collection deleteWarnings;
        Map<String, ModelItemDTO> changes = this.validateRecursiveExpert(formItemDTO.getItems());
        String dmk = TaxmeController.getInstance().getFormAccessKey();
        ExpertDisplayInfoDTO di = TaxmeController.getInstance().getTmoCdSession().expertUpdate(changes, true, false, dmk, TaxmeController.getInstance().getLocale(), true);
        Collection collection = deleteWarnings = di != null ? di.getDeleteWarnings() : null;
        if (deleteWarnings != null && !deleteWarnings.isEmpty()) {
            DeleteWarningDialog dialog = new DeleteWarningDialog(Display.getCurrent().getActiveShell(), deleteWarnings);
            dialog.open();
            int returnCode = dialog.getReturnCode();
            if (returnCode == 0) {
                TaxmeController.getInstance().getTmoCdSession().update(changes, true, true, dmk);
            }
        }
    }

    private Map<String, ModelItemDTO> validateRecursiveExpert(List<? extends ExpertDisplayInfoDTO.ItemDTO> children) {
        if (children == null) {
            return null;
        }
        HashMap<String, ModelItemDTO> result = new HashMap<String, ModelItemDTO>();
        for (ExpertDisplayInfoDTO.ItemDTO itemDTO : children) {
            if (itemDTO instanceof ExpertDisplayInfoDTO.ValueItemDTO) {
                ExpertDisplayInfoDTO.ValueItemDTO iDTO = (ExpertDisplayInfoDTO.ValueItemDTO)itemDTO;
                ModelItemDTO modelItem = iDTO.getModelItem();
                if (iDTO.isReadonly() || modelItem.getValue() != null && modelItem.getState() != 3) continue;
                if (modelItem.getValue() == null) {
                    this.validateItem("", iDTO, true);
                }
                if (!modelItem.isTouched()) {
                    modelItem.setTouched();
                }
                result.put(iDTO.getDataModelKey(), modelItem);
                continue;
            }
            if (!(itemDTO instanceof ExpertDisplayInfoDTO.TableDTO)) continue;
            ExpertDisplayInfoDTO.TableDTO table = (ExpertDisplayInfoDTO.TableDTO)itemDTO;
            for (Object element2 : table.getPrintRows()) {
                ExpertDisplayInfoDTO.TableDTO.RowDTO row = (ExpertDisplayInfoDTO.TableDTO.RowDTO)element2;
                int colIndex = 0;
                for (Object item : row.getValues()) {
                    if (item instanceof ExpertDisplayInfoDTO.TableDTO.CellDTO) {
                        ExpertDisplayInfoDTO.TableDTO.ValueCellDTO value;
                        ModelItemDTO modelItem;
                        ExpertDisplayInfoDTO.TableDTO.CellDTO cell = (ExpertDisplayInfoDTO.TableDTO.CellDTO)item;
                        if (cell instanceof ExpertDisplayInfoDTO.TableDTO.ValueCellDTO && (modelItem = (value = (ExpertDisplayInfoDTO.TableDTO.ValueCellDTO)cell).getModelItem()) != null && (modelItem.getValue() == null || modelItem.getState() == 3)) {
                            ExpertDisplayInfoDTO.TableDTO.ColumnDTO col = (ExpertDisplayInfoDTO.TableDTO.ColumnDTO)table.getAllColumns().get(colIndex);
                            if (modelItem.getValue() == null) {
                                this.validateItem("", value, col, true);
                            }
                            if (!modelItem.isTouched()) {
                                modelItem.setTouched();
                            }
                            result.put(value.getDataModelKey(), value.getModelItem());
                        }
                    } else if (item instanceof ExpertDisplayInfoDTO.ValueItemDTO) {
                        this.validateRecursiveExpert(Collections.singletonList((ExpertDisplayInfoDTO.ValueItemDTO)item));
                    }
                    ++colIndex;
                }
            }
        }
        return result;
    }

    public void execute(WizardDisplayInfoDTO.FormItemDTO formItemDTO) {
        List<WizardDisplayInfoDTO.DataModelItem> items = this.validateRecursive(formItemDTO.getChildren());
        if (!items.isEmpty()) {
            Collection deleteWarnings;
            HashMap<String, ModelItemDTO> changes = new HashMap<String, ModelItemDTO>();
            for (WizardDisplayInfoDTO.DataModelItem itemDTO : items) {
                ModelItemDTO newValue = new ModelItemDTO(itemDTO.getValue());
                newValue.setTouched();
                changes.put(itemDTO.getDataModelKey(), newValue);
            }
            String dmk = TaxmeController.getInstance().getDataModelKey();
            WizardDisplayInfoDTO wizardDisplayDTO = TaxmeController.getInstance().getTmoCdSession().update(changes, true, false, dmk);
            Collection collection = deleteWarnings = wizardDisplayDTO != null ? wizardDisplayDTO.getDeleteWarnings() : null;
            if (deleteWarnings != null && !deleteWarnings.isEmpty()) {
                DeleteWarningDialog dialog = new DeleteWarningDialog(Display.getCurrent().getActiveShell(), deleteWarnings);
                dialog.open();
                int returnCode = dialog.getReturnCode();
                if (returnCode == 0) {
                    TaxmeController.getInstance().getTmoCdSession().update(changes, true, true, dmk);
                }
            }
        }
    }

    private List<WizardDisplayInfoDTO.DataModelItem> validateRecursive(List<? extends WizardDisplayInfoDTO.AbstractItemDTO> children) {
        if (children == null) {
            return null;
        }
        ArrayList<WizardDisplayInfoDTO.DataModelItem> result = new ArrayList<WizardDisplayInfoDTO.DataModelItem>();
        for (WizardDisplayInfoDTO.AbstractItemDTO abstractItemDTO : children) {
            List<WizardDisplayInfoDTO.DataModelItem> l;
            if (abstractItemDTO instanceof WizardDisplayInfoDTO.DataModelItem) {
                WizardDisplayInfoDTO.DataModelItem dataModelItem = (WizardDisplayInfoDTO.DataModelItem)abstractItemDTO;
                if (dataModelItem instanceof WizardDisplayInfoDTO.ItemItemDTO) {
                    WizardDisplayInfoDTO.ItemItemDTO iDTO = (WizardDisplayInfoDTO.ItemItemDTO)dataModelItem;
                    if (iDTO.getValue() != null && iDTO.getState() != 3) continue;
                    if (iDTO.getValue() == null) {
                        this.validateItem("", iDTO, true);
                    }
                    result.add((WizardDisplayInfoDTO.DataModelItem)iDTO);
                    continue;
                }
                if (dataModelItem instanceof WizardDisplayInfoDTO.FileDetailsItemDTO) {
                    WizardDisplayInfoDTO.FileDetailsItemDTO fileDetailsItemDTO = (WizardDisplayInfoDTO.FileDetailsItemDTO)dataModelItem;
                    result.add((WizardDisplayInfoDTO.DataModelItem)fileDetailsItemDTO);
                    continue;
                }
                LOG.error("unsupported: {}", (Object)dataModelItem.getClass().getName());
                continue;
            }
            if (abstractItemDTO instanceof WizardDisplayInfoDTO.TableItemDTO) {
                l = this.validateRecursive(((WizardDisplayInfoDTO.TableItemDTO)abstractItemDTO).getRows());
                if (l == null) continue;
                result.addAll(l);
                continue;
            }
            if (abstractItemDTO instanceof WizardDisplayInfoDTO.SectionItemDTO) {
                l = this.validateRecursive(((WizardDisplayInfoDTO.SectionItemDTO)abstractItemDTO).getRows());
                if (l == null) continue;
                result.addAll(l);
                continue;
            }
            if (!(abstractItemDTO instanceof WizardDisplayInfoDTO.RowItemDTO) || (l = this.validateRecursive(((WizardDisplayInfoDTO.RowItemDTO)abstractItemDTO).getCols())) == null) continue;
            result.addAll(l);
        }
        return result;
    }

    public void execute(String value, WizardDisplayInfoDTO.ItemItemDTO itemDTO) {
        if (this.validateItem(value, itemDTO, true)) {
            this.executeWithoutScreenUpdate(itemDTO);
            TaxmeController.getInstance().update(false);
        } else {
            TaxmeController.getInstance().refresh();
        }
    }

    private void executeWithoutScreenUpdate(WizardDisplayInfoDTO.ItemItemDTO itemDTO) {
        Collection deleteWarnings;
        ModelItemDTO newValue = new ModelItemDTO(itemDTO.getValue());
        newValue.setTouched();
        HashMap<String, ModelItemDTO> changes = new HashMap<String, ModelItemDTO>();
        changes.put(itemDTO.getDataModelKey(), newValue);
        String dmk = TaxmeController.getInstance().getDataModelKey();
        WizardDisplayInfoDTO wizardDisplayDTO = TaxmeController.getInstance().getTmoCdSession().update(changes, true, false, dmk);
        Collection collection = deleteWarnings = wizardDisplayDTO != null ? wizardDisplayDTO.getDeleteWarnings() : null;
        if (deleteWarnings != null && !deleteWarnings.isEmpty()) {
            DeleteWarningDialog dialog = new DeleteWarningDialog(Display.getCurrent().getActiveShell(), deleteWarnings);
            dialog.open();
            int returnCode = dialog.getReturnCode();
            if (returnCode == 0) {
                TaxmeController.getInstance().getTmoCdSession().update(changes, true, true, dmk);
            }
        }
    }

    private boolean validateItem(String value, WizardDisplayInfoDTO.ItemItemDTO itemDTO, boolean preValidation) {
        if (value != null) {
            value = value.trim();
        }
        if (itemDTO.getRendererAndInputValidator() != null) {
            try {
                TaxmeController ctrl = TaxmeController.getInstance();
                AbstractConverter.ConverterContext ctx = new AbstractConverter.ConverterContext(ctrl.getLocalizationHelper(), ctrl.getTmoCdSession().getDataModel(), itemDTO.getDataModelKey());
                Object result = itemDTO.getRendererAndInputValidator().getObject(value, itemDTO.getOptionItems(), ctx);
                return this.doSuccess(itemDTO, result, preValidation);
            }
            catch (AbstractConverter.ConvertException e) {
                MessageItemDTO message = new MessageItemDTO(e.getMessage(), (Object)e.getMaxLength(), 4);
                return this.doFailure(itemDTO, message, value);
            }
        }
        int type = itemDTO.getType();
        if (value != null) {
            value = value.trim();
        }
        if (type != 3 && (value == null || value.isEmpty())) {
            return this.doSuccess(itemDTO, null, preValidation);
        }
        if (type == 100) {
            if (value != null && value.length() > itemDTO.getMaxlength()) {
                MessageItemDTO message = new MessageItemDTO("error.format.text", (Object)itemDTO.getMaxlength(), 4);
                return this.doFailure(itemDTO, message, value);
            }
            return this.doSuccess(itemDTO, (Object)value, preValidation);
        }
        return false;
    }

    private boolean doSuccess(WizardDisplayInfoDTO.ItemItemDTO itemDTO, Object value, boolean preValidation) {
        if (preValidation) {
            itemDTO.setValue(value);
        }
        return true;
    }

    private boolean doFailure(WizardDisplayInfoDTO.ItemItemDTO itemDTO, MessageItemDTO message, String value) {
        if (itemDTO.getMessages() != null) {
            itemDTO.getMessages().clear();
        }
        itemDTO.addMessage(message);
        if (message.getType() == 4) {
            itemDTO.setState(4);
        } else {
            itemDTO.setState(2);
        }
        itemDTO.setValue((Object)value);
        return false;
    }

    public void execute(String value, ExpertDisplayInfoDTO.ValueItemDTO itemDTO) {
        if (this.validateItem(value, itemDTO, true)) {
            this.expertUpdate(itemDTO.getDataModelKey(), itemDTO.getModelItem().getValue());
        } else {
            TaxmeController.getInstance().refresh();
        }
    }

    public void execute(String value, ExpertDisplayInfoDTO.TableDTO.ValueCellDTO cellDTO, ExpertDisplayInfoDTO.TableDTO.RowDTO row, ExpertDisplayInfoDTO.TableDTO.ColumnDTO columnDTO) {
        Object oldVal;
        Object object = oldVal = cellDTO.getModelItem() == null ? null : cellDTO.getModelItem().getValue();
        if (row.isEmptyRow() && value.equals(oldVal)) {
            return;
        }
        if (this.validateItem(value, cellDTO, columnDTO, true)) {
            HashMap<String, ModelItemDTO> changes = new HashMap<String, ModelItemDTO>();
            if (row.isEmptyRow()) {
                for (Object elem : row.getValues()) {
                    ModelItemDTO mi;
                    ExpertDisplayInfoDTO.TableDTO.ValueCellDTO cell;
                    if (!(elem instanceof ExpertDisplayInfoDTO.TableDTO.ValueCellDTO) || (cell = (ExpertDisplayInfoDTO.TableDTO.ValueCellDTO)elem) == cellDTO || (mi = cell.getModelItem()) == null || mi.isTouched() || mi.getValue() == null) continue;
                    mi.setTouched();
                    changes.put(cell.getDataModelKey(), mi);
                }
            }
            changes.put(cellDTO.getDataModelKey(), cellDTO.getModelItem());
            this.expertUpdate(changes);
        } else {
            TaxmeController.getInstance().refresh();
        }
    }

    private void expertUpdate(String dmk, Object newValue) {
        ModelItemDTO mi = new ModelItemDTO(newValue);
        mi.setTouched();
        HashMap<String, ModelItemDTO> changes = new HashMap<String, ModelItemDTO>();
        changes.put(dmk, mi);
        this.expertUpdate(changes);
    }

    private void expertUpdate(Map<String, ModelItemDTO> changes) {
        Collection deleteWarnings;
        TaxmeController ctrl = TaxmeController.getInstance();
        String fak = ctrl.getFormAccessKey();
        ExpertDisplayInfoDTO edi = ctrl.getTmoCdSession().expertUpdate(changes, true, false, fak, ctrl.getLocale(), false);
        if (edi != null && (deleteWarnings = edi.getDeleteWarnings()) != null && !deleteWarnings.isEmpty()) {
            DeleteWarningDialog dialog = new DeleteWarningDialog(ctrl.getShell(), deleteWarnings);
            dialog.open();
            int returnCode = dialog.getReturnCode();
            if (returnCode == 0) {
                TaxmeController.getInstance().getTmoCdSession().expertUpdate(changes, true, true, fak, ctrl.getLocale(), false);
            } else {
                edi = ctrl.getExpertDisplayInfoDTO(fak, 1);
            }
        }
        ctrl.setExpertDisplayInfo(edi, fak);
    }

    private boolean validateItem(String value, ExpertDisplayInfoDTO.ValueItemDTO itemDTO, boolean preValidation) {
        if (value != null) {
            value = value.trim();
        }
        if (itemDTO.getRendererAndInputValidator() != null) {
            try {
                TaxmeController ctrl = TaxmeController.getInstance();
                AbstractConverter.ConverterContext ctx = new AbstractConverter.ConverterContext(ctrl.getLocalizationHelper(), ctrl.getTmoCdSession().getDataModel(), itemDTO.getDataModelKey());
                Object result = itemDTO.getRendererAndInputValidator().getObject(value, itemDTO.getOptionItems(), ctx);
                return this.doSuccess(itemDTO, result, preValidation);
            }
            catch (AbstractConverter.ConvertException e) {
                MessageItemDTO message = new MessageItemDTO(e.getMessage(), (Object)e.getMaxLength(), 4);
                return this.doFailure(itemDTO, message, value);
            }
        }
        int type = itemDTO.getType();
        if (value != null) {
            value = value.trim();
        }
        if (type != 3 && (value == null || value.isEmpty())) {
            return this.doSuccess(itemDTO, null, preValidation);
        }
        if (type == 100) {
            return this.doSuccess(itemDTO, (Object)value, preValidation);
        }
        return false;
    }

    private boolean validateItem(String value, ExpertDisplayInfoDTO.TableDTO.ValueCellDTO cellDTO, ExpertDisplayInfoDTO.TableDTO.ColumnDTO columnDTO, boolean preValidation) {
        if (value != null) {
            value = value.trim();
        }
        if (columnDTO.getRendererAndInputValidator() != null) {
            try {
                TaxmeController ctrl = TaxmeController.getInstance();
                AbstractConverter.ConverterContext ctx = new AbstractConverter.ConverterContext(ctrl.getLocalizationHelper(), ctrl.getTmoCdSession().getDataModel(), cellDTO.getDataModelKey());
                Object result = columnDTO.getRendererAndInputValidator().getObject(value, cellDTO.getOptionItems(), ctx);
                return this.doSuccess(cellDTO, result, preValidation);
            }
            catch (AbstractConverter.ConvertException e) {
                MessageItemDTO message = new MessageItemDTO(e.getMessage(), (Object)e.getMaxLength(), 4);
                return this.doFailure(cellDTO, message, value);
            }
        }
        int type = columnDTO.getType();
        if (value != null) {
            value = value.trim();
        }
        if (type != 3 && (value == null || value.isEmpty())) {
            return this.doSuccess(cellDTO, null, preValidation);
        }
        if (type == 100) {
            return this.doSuccess(cellDTO, (Object)value, preValidation);
        }
        return false;
    }

    private boolean doSuccess(ExpertDisplayInfoDTO.ValueItemDTO itemDTO, Object value, boolean preValidation) {
        ModelItemDTO newModelItem = new ModelItemDTO(value);
        newModelItem.setTouched();
        if (preValidation) {
            itemDTO.setModelItem(newModelItem);
        }
        return true;
    }

    private boolean doSuccess(ExpertDisplayInfoDTO.TableDTO.ValueCellDTO cellDTO, Object value, boolean preValidation) {
        ModelItemDTO newModelItem = new ModelItemDTO(value);
        newModelItem.setTouched();
        if (preValidation) {
            cellDTO.setModelItem(newModelItem);
        }
        return true;
    }

    private boolean doFailure(ExpertDisplayInfoDTO.ValueItemDTO valueDTO, MessageItemDTO message, String value) {
        int state;
        ArrayList<MessageItemDTO> messages = new ArrayList<MessageItemDTO>();
        messages.add(message);
        int n = state = message.getType() == 4 ? 4 : 2;
        if (valueDTO.getModelItem() == null) {
            valueDTO.setModelItem(new ModelItemDTO((Object)value, state, messages));
        } else {
            valueDTO.setModelItem(valueDTO.getModelItem().clone((Object)value, state, messages));
        }
        return false;
    }

    private boolean doFailure(ExpertDisplayInfoDTO.TableDTO.ValueCellDTO cellDTO, MessageItemDTO message, String value) {
        int state;
        ArrayList<MessageItemDTO> messages = new ArrayList<MessageItemDTO>();
        messages.add(message);
        int n = state = message.getType() == 4 ? 4 : 2;
        if (cellDTO.getModelItem() == null) {
            cellDTO.setModelItem(new ModelItemDTO((Object)value, state, messages));
        } else {
            cellDTO.setModelItem(cellDTO.getModelItem().clone((Object)value, state, messages));
        }
        return false;
    }
}

