/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.cd.action;

import ch.dvbern.tax.common.presentation.cd.TaxmeConfig;
import ch.dvbern.tax.common.presentation.cd.TaxmeController;
import ch.dvbern.tax.common.presentation.cd.action.ButtonAddAction;
import ch.dvbern.tax.common.presentation.cd.action.ButtonDeleteAction;
import ch.dvbern.tax.common.presentation.cd.action.ButtonEditAction;
import ch.dvbern.tax.common.presentation.cd.action.ButtonVisualizeAction;
import ch.dvbern.tax.common.presentation.cd.action.PrintAllAction;
import ch.dvbern.tax.common.presentation.cd.action.PrintableActionBase;
import ch.dvbern.tax.common.presentation.cd.action.TablerowClickAction;
import ch.dvbern.tax.common.presentation.cd.action.menu.ChangeLayoutAction;
import ch.dvbern.tax.common.presentation.cd.action.menu.EditRedoAction;
import ch.dvbern.tax.common.presentation.cd.action.menu.EditUndoAction;
import ch.dvbern.tax.common.presentation.cd.action.menu.FileChangePasswordAction;
import ch.dvbern.tax.common.presentation.cd.action.menu.FileCloseAction;
import ch.dvbern.tax.common.presentation.cd.action.menu.FileDossierAction;
import ch.dvbern.tax.common.presentation.cd.action.menu.FileImportAction;
import ch.dvbern.tax.common.presentation.cd.action.menu.FileNewAction;
import ch.dvbern.tax.common.presentation.cd.action.menu.FileOpenAction;
import ch.dvbern.tax.common.presentation.cd.action.menu.FilePrintAction;
import ch.dvbern.tax.common.presentation.cd.action.menu.FileSaveAction;
import ch.dvbern.tax.common.presentation.cd.action.menu.FileSaveAsAction;
import ch.dvbern.tax.common.presentation.cd.action.menu.HelpAboutAction;
import ch.dvbern.tax.common.presentation.cd.action.menu.HelpMainhelpAction;
import ch.dvbern.tax.common.presentation.cd.action.menu.HelpShorthelpAction;
import ch.dvbern.tax.common.presentation.cd.action.menu.SaveGuiEditAction;
import ch.dvbern.tax.common.presentation.cd.action.menu.UtilProxySettingsAction;
import ch.dvbern.tax.common.presentation.cd.action.menu.UtilReloadModelAction;
import ch.dvbern.tax.common.presentation.cd.action.menu.UtilSetApplicationPathAction;
import ch.dvbern.tax.common.presentation.cd.action.menu.UtilSetFontSizeAction;
import ch.dvbern.tax.common.presentation.cd.action.menu.UtilUpdateAction;
import ch.dvbern.tax.common.presentation.cd.action.menu.UtilWindowResizeAction;
import ch.dvbern.tax.common.presentation.cd.action.menu.ViewSelectModeAction;
import ch.dvbern.tax.common.presentation.common.Mode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.eclipse.jface.action.Action;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ActionRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(ActionRegistry.class);
    public static final String FILE_NEW = "new";
    public static final String OPEN = "open";
    public static final String IMPORT = "import";
    public static final String SAVE_AS = "save.as";
    public static final String SAVE = "save";
    public static final String PRINT = "print";
    public static final String INIT = "init";
    public static final String TREUHAND = "treuhand";
    public static final String DOCUMENTS = "documents";
    public static final String LAWS = "laws";
    public static final String TABLE_ADD = "table.add";
    public static final String TABLE_EDIT = "table.edit";
    public static final String TABLE_DELETE = "table.delete";
    public static final String TABLE_VISUALIZE = "table.visualize";
    public static final String LINK_WWW = "link.www";
    public static final String ACTION_UPLOAD = "upload";
    public static final String CLOSE = "close";
    public static final String CHANGE_PWD = "change.pwd";
    public static final String FILE_DOSSIER = "change.dossier";
    public static final String EDIT_UNDO = "edit.undo";
    public static final String EDIT_REDO = "edit.redo";
    public static final String MODE_EXPERT = "view.expert";
    public static final String MODE_WIZARD = "view.wizard";
    public static final String UTIL_UPDATE = "util.update";
    public static final String UTIL_VALOR = "util.valor";
    public static final String WINDOWS_RESIZE = "windows.resize";
    public static final String UTIL_ACROREAD_PATH = "util.acroread.path";
    public static final String UTIL_BROWSER_PATH = "util.browser.path";
    public static final String LARGE_FONTS = "large.fonts";
    public static final String SMALL_FONTS = "small.fonts";
    public static final String PROXY_SETTINGS = "proxy.settings";
    public static final String HELP_SHORTHELP = "help.shorthelp";
    public static final String HELP_MAINHELP = "help.mainhelp";
    public static final String HELP_ABOUT = "help.about";
    public static final String RELOAD_MODEL = "reload.model";
    public static final String SAVE_GUI_EDIT = "save.gui.edit";
    public static final String TABLE_ROW_CLICK = "table.row.click";
    private static final ActionRegistry instance = new ActionRegistry();
    private final List<PrintableActionBase> printActions = new ArrayList<PrintableActionBase>();
    private final List<ChangeLayoutAction> changeLayoutActions = new ArrayList<ChangeLayoutAction>();
    private final List<Action> documentActions = new ArrayList<Action>();
    private final List<Action> lawActions = new ArrayList<Action>();
    private final Map<String, Action> actions = new HashMap<String, Action>();
    private final LinkedHashMap<String, ArrayList<Action>> customMenuActions = new LinkedHashMap();

    private ActionRegistry() {
        this.printActions.add(new PrintAllAction());
        this.registerAction(FILE_NEW, new FileNewAction());
        this.registerAction(OPEN, new FileOpenAction());
        this.registerAction(IMPORT, new FileImportAction());
        this.registerAction(SAVE_AS, new FileSaveAsAction());
        this.registerAction(SAVE, new FileSaveAction());
        this.registerAction(PRINT, new FilePrintAction());
        this.registerAction(TABLE_ADD, new ButtonAddAction());
        this.registerAction(TABLE_EDIT, new ButtonEditAction());
        this.registerAction(TABLE_DELETE, new ButtonDeleteAction());
        this.registerAction(TABLE_VISUALIZE, new ButtonVisualizeAction());
        this.registerAction(CLOSE, new FileCloseAction());
        this.registerAction(CHANGE_PWD, new FileChangePasswordAction());
        this.registerAction(FILE_DOSSIER, new FileDossierAction());
        this.registerAction(EDIT_UNDO, new EditUndoAction());
        this.registerAction(EDIT_REDO, new EditRedoAction());
        this.registerAction(MODE_EXPERT, new ViewSelectModeAction("menu.view.mode.expert", "icon.menu.view.mode.expert", Mode.EXPERT));
        this.registerAction(MODE_WIZARD, new ViewSelectModeAction("menu.view.mode.wizard", "icon.menu.view.mode.wizard", Mode.WIZARD));
        this.registerAction(WINDOWS_RESIZE, new UtilWindowResizeAction());
        this.registerAction(UTIL_UPDATE, new UtilUpdateAction("menu.util.update", 0));
        this.registerAction(UTIL_VALOR, new UtilUpdateAction("menu.util.valor", 0));
        this.registerAction(UTIL_ACROREAD_PATH, new UtilSetApplicationPathAction("menu.acroread.path", "label.dialog.setapplicationpath.acroread", "acroread.path.use", "acroread.path"));
        this.registerAction(UTIL_BROWSER_PATH, new UtilSetApplicationPathAction("menu.browser.path", "label.dialog.setapplicationpath.browser", "browser.path.use", "browser.path"));
        this.registerAction(LARGE_FONTS, new UtilSetFontSizeAction("menu.util.fontsize.large", true));
        this.registerAction(SMALL_FONTS, new UtilSetFontSizeAction("menu.util.fontsize.small", false));
        this.registerAction(PROXY_SETTINGS, new UtilProxySettingsAction());
        this.registerAction(HELP_SHORTHELP, new HelpShorthelpAction());
        this.registerAction(HELP_MAINHELP, TaxmeConfig.getMainhelpDir() != null ? new HelpMainhelpAction() : null);
        this.registerAction(HELP_ABOUT, new HelpAboutAction());
        this.registerAction(RELOAD_MODEL, Boolean.getBoolean("model.reload.enabled") ? new UtilReloadModelAction() : null);
        this.registerAction(SAVE_GUI_EDIT, TaxmeController.isGuiEditEnabled() ? new SaveGuiEditAction() : null);
        this.registerAction(TABLE_ROW_CLICK, new TablerowClickAction());
    }

    public static ActionRegistry getInstance() {
        return instance;
    }

    public void addPrintAction(PrintableActionBase action) {
        this.printActions.add(action);
    }

    public List<PrintableActionBase> getPrintActions() {
        return this.printActions;
    }

    public @NonNull List<ChangeLayoutAction> getChangeLayoutActions() {
        return this.changeLayoutActions;
    }

    public void addDocumentAction(Action action) {
        this.documentActions.add(action);
    }

    public void addChangeLayoutAction(@NonNull ChangeLayoutAction action) {
        if (action == null) {
            throw new NullPointerException("Action cannot be null.");
        }
        this.changeLayoutActions.add(action);
    }

    public List<Action> getDocumentActions() {
        return this.documentActions;
    }

    public void addLawActions(Action action) {
        this.lawActions.add(action);
    }

    public List<Action> getLawActions() {
        return this.lawActions;
    }

    public Action getAction(String id) {
        return this.actions.get(id);
    }

    public void registerAction(@NonNull String id, @Nullable Action action) {
        this.actions.put(id, action);
    }

    public void createCustomMenu(String customMenuId) {
        ArrayList oldActList = this.customMenuActions.put(customMenuId, new ArrayList());
        if (oldActList != null) {
            LOG.warn("customMenuActions doppelt angelegt: " + customMenuId);
        }
    }

    public void addCustomMenuAction(String customMenuId, Action action) {
        ArrayList<Action> actList = this.customMenuActions.get(customMenuId);
        if (actList == null) {
            LOG.warn("customMenuActions wird implizit angelegt: " + customMenuId);
            this.createCustomMenu(customMenuId);
            actList = this.customMenuActions.get(customMenuId);
        }
        assert (actList != null);
        actList.add(action);
    }

    public Set<String> getCustomMenus() {
        return this.customMenuActions.keySet();
    }

    public @Nullable List<Action> getCustomMenuActions(String customMenuId) {
        List actList = this.customMenuActions.get(customMenuId);
        if (actList == null) {
            LOG.warn("customMenuActions existiert nicht fuer: " + customMenuId);
        }
        return actList;
    }
}

