/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.transfer.dto.convert;

import ch.dvbern.tax.common.transfer.dto.OptionItemsDTO;
import ch.dvbern.tax.common.transfer.dto.convert.AbstractConverter;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class TranslatedLabelConverter
extends AbstractConverter<String> {
    private static final long serialVersionUID = 1L;
    private boolean toBeTranslated = false;

    public TranslatedLabelConverter() {
        super(String.class);
        this.toBeTranslated = false;
    }

    public TranslatedLabelConverter(boolean toBeTranslated) {
        super(String.class);
        this.toBeTranslated = toBeTranslated;
    }

    @Override
    public @Nullable String getObject(@Nullable String s, @Nullable OptionItemsDTO optionItems, @NonNull AbstractConverter.ConverterContext ctx) throws AbstractConverter.ConvertException {
        return s;
    }

    @Override
    public @Nullable String getRenderedValue(@Nullable Object o, boolean readonly, @Nullable OptionItemsDTO optionItems, @NonNull AbstractConverter.ConverterContext ctx) {
        String key = o.toString();
        if (this.toBeTranslated) {
            try {
                return ctx.getLocalizationHelper().translate(key, new Object[0]);
            }
            catch (Exception e) {
                return key;
            }
        }
        return key;
    }
}

