/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.transfer.dto.convert;

import ch.dvbern.tax.common.transfer.dto.OptionItemsDTO;
import ch.dvbern.tax.common.transfer.dto.convert.AbstractConverter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class TextConverter
extends AbstractConverter<String> {
    private static final long serialVersionUID = 3905807487042008886L;
    public static final List<Character.UnicodeBlock> DEFAULT_ALLOWED_BLOCKS = Collections.unmodifiableList(Arrays.asList(Character.UnicodeBlock.BASIC_LATIN, Character.UnicodeBlock.LATIN_1_SUPPLEMENT, Character.UnicodeBlock.LATIN_EXTENDED_A, Character.UnicodeBlock.LATIN_EXTENDED_ADDITIONAL, Character.UnicodeBlock.LATIN_EXTENDED_B, Character.UnicodeBlock.LATIN_EXTENDED_C, Character.UnicodeBlock.CURRENCY_SYMBOLS));
    protected int maxLength;
    private boolean trimLeft = false;
    private boolean trimRight = false;

    public TextConverter(int maxLength) {
        super(String.class);
        this.maxLength = maxLength;
    }

    public TextConverter(int maxLength, boolean trimLeft, boolean trimRight) {
        super(String.class);
        this.maxLength = maxLength;
        this.trimLeft = trimLeft;
        this.trimRight = trimRight;
    }

    @Override
    public @Nullable String getObject(@Nullable String s, @Nullable OptionItemsDTO optionItems, @NonNull AbstractConverter.ConverterContext ctx) throws AbstractConverter.ConvertException {
        return this.parseString(s);
    }

    public @Nullable String parseString(@Nullable String s) throws AbstractConverter.ConvertException {
        if (s == null || s.length() <= 0) {
            return null;
        }
        if (s.length() > this.maxLength) {
            throw new AbstractConverter.ConvertException("error.format.text", this.maxLength);
        }
        StringBuilder sb = new StringBuilder(s.length());
        for (int i = 0; i < s.length(); ++i) {
            char currentChar = s.charAt(i);
            String substitute = this.substitute(currentChar);
            if (substitute == null) continue;
            sb.append(substitute);
        }
        return sb.toString();
    }

    protected @NonNull Collection<Character.UnicodeBlock> allowedBlocks() {
        return DEFAULT_ALLOWED_BLOCKS;
    }

    protected @Nullable String substitute(char currentChar) {
        Character.UnicodeBlock blockOfchar = Character.UnicodeBlock.of(currentChar);
        Collection<Character.UnicodeBlock> allowedBlocks = this.allowedBlocks();
        if (allowedBlocks.contains(blockOfchar)) {
            return String.valueOf(currentChar);
        }
        return null;
    }

    @Override
    public @Nullable String getRenderedValue(@Nullable Object o, boolean readonly, @Nullable OptionItemsDTO optionItems, @NonNull AbstractConverter.ConverterContext ctx) {
        String result = "";
        if (o instanceof String) {
            result = (String)o;
        } else if (o != null) {
            result = o.toString();
        }
        if (this.trimRight && result.length() > this.maxLength) {
            result = result.substring(0, this.maxLength);
        }
        if (this.trimLeft && result.length() > this.maxLength) {
            result = result.substring(result.length() - this.maxLength);
        }
        return result;
    }

    @Override
    public int getMaxLength() {
        return this.maxLength;
    }
}

