/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.transfer.dto.convert;

import ch.dvbern.tax.common.transfer.dto.convert.AbstractConverter;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;

public abstract class NumberConverter<T extends Number>
extends AbstractConverter<T> {
    private static final long serialVersionUID = 1L;
    protected static final DecimalFormatSymbols dfs = new DecimalFormatSymbols(new Locale("de", "CH"));
    protected final int maxLength;

    protected NumberConverter(Class<T> targetType, int maxLength) {
        super(targetType);
        this.maxLength = maxLength;
    }

    protected static DecimalFormat createDecimalFormat(String pattern) {
        DecimalFormat df = new DecimalFormat(pattern, dfs);
        df.setDecimalFormatSymbols(dfs);
        df.setGroupingSize(3);
        df.setGroupingUsed(true);
        df.setDecimalSeparatorAlwaysShown(false);
        return df;
    }

    @Override
    public int getMaxLength() {
        return this.maxLength;
    }

    @Override
    public int calcLength(String input) {
        if (input == null) {
            return 0;
        }
        input = input.replaceAll("\\.", "");
        input = input.replaceAll("'", "");
        input = input.replaceAll("\u2019", "");
        input = input.replaceAll("-", "");
        return input.length();
    }
}

