/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.transfer.dto.convert;

import ch.dvbern.tax.common.integration.conf.ApplicationConfig;
import ch.dvbern.tax.common.transfer.dto.OptionItemsDTO;
import ch.dvbern.tax.common.transfer.dto.convert.AbstractConverter;
import ch.dvbern.tax.common.transfer.util.FormatHelper;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class MonthYearConverter
extends AbstractConverter<Date> {
    private static final long serialVersionUID = 3257844376993477682L;
    private static final SimpleDateFormat sdf_render = new SimpleDateFormat("MM.yyyy");

    public MonthYearConverter() {
        super(Date.class);
    }

    @Override
    public @Nullable Date getObject(@Nullable String s, @Nullable OptionItemsDTO optionItems, @NonNull AbstractConverter.ConverterContext ctx) throws AbstractConverter.ConvertException {
        if (s == null || s.length() <= 0) {
            return null;
        }
        try {
            return this.parse(s);
        }
        catch (Exception e) {
            throw new AbstractConverter.ConvertException("error.format.monthyear", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public @Nullable String getRenderedValue(@Nullable Object o, boolean readonly, @Nullable OptionItemsDTO optionItems, @NonNull AbstractConverter.ConverterContext ctx) {
        if (o == null) {
            return "";
        }
        if (o instanceof Date) {
            SimpleDateFormat simpleDateFormat = sdf_render;
            synchronized (simpleDateFormat) {
                return sdf_render.format((Date)o);
            }
        }
        return o.toString();
    }

    @Override
    public @NonNull String getUserInputRegExpPattern() {
        return "([0-9]{1,2})(\\.?)([0-9]{0,4})";
    }

    private Date parse(String input) throws Exception {
        StringBuilder sb = new StringBuilder("01.");
        sb.append(input);
        String date = sb.toString();
        Calendar aCalendar = FormatHelper.getCalendar(date);
        if (aCalendar == null) {
            date = date.replaceAll("\\.", "");
            aCalendar = FormatHelper.getCalendar(date);
        }
        if (aCalendar == null) {
            aCalendar = FormatHelper.getCalendar(input);
        }
        if (aCalendar != null) {
            aCalendar.set(5, 1);
            return aCalendar.getTime();
        }
        throw new AbstractConverter.ConvertException("error.format.monthyear");
    }

    @Override
    public int getMaxLength() {
        return 7;
    }

    static {
        sdf_render.setTimeZone(ApplicationConfig.TIMEZONE);
    }
}

