/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.transfer.dto.convert;

import ch.dvbern.tax.common.transfer.dto.OptionItemsDTO;
import ch.dvbern.tax.common.transfer.dto.convert.AbstractConverter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class MailConverter
extends AbstractConverter<String> {
    private static final long serialVersionUID = 3256439226903378226L;
    private final Pattern pattern = Pattern.compile("^[\\w\\.\\-]+@([\\w\\-]+\\.)*[\\w\\-]{2,63}\\.[a-zA-Z]{2,20}$");

    public MailConverter() {
        super(String.class);
    }

    @Override
    public @Nullable String getObject(@Nullable String s, @Nullable OptionItemsDTO optionItems, @NonNull AbstractConverter.ConverterContext ctx) throws AbstractConverter.ConvertException {
        return this.parseString(s);
    }

    public @Nullable String parseString(@Nullable String s) throws AbstractConverter.ConvertException {
        if (s == null || s.length() <= 0) {
            return null;
        }
        Matcher m = this.pattern.matcher(s);
        if (!m.matches()) {
            throw new AbstractConverter.ConvertException("error.format.mail");
        }
        return s;
    }

    @Override
    public @Nullable String getRenderedValue(@Nullable Object o, boolean readonly, @Nullable OptionItemsDTO optionItems, @NonNull AbstractConverter.ConverterContext ctx) {
        if (o == null) {
            return "";
        }
        return o.toString();
    }

    @Override
    public int getMaxLength() {
        return 100;
    }
}

