/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.transfer.dto.convert;

import ch.dvbern.tax.common.transfer.dto.OptionItemsDTO;
import ch.dvbern.tax.common.transfer.dto.convert.AbstractConverter;
import ch.dvbern.tax.common.transfer.dto.convert.NumberConverter;
import java.text.DecimalFormat;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class IntConverter
extends NumberConverter<Long> {
    private static final long serialVersionUID = 3257282526450890292L;
    private static final DecimalFormat df_int = IntConverter.createDecimalFormat("#,##0");
    private final boolean printZeroIfReadonly;

    public IntConverter(int maxLength, boolean printZeroIfReadonly) {
        super(Long.class, maxLength);
        this.printZeroIfReadonly = printZeroIfReadonly;
    }

    @Override
    public @Nullable Long getObject(@Nullable String s, @Nullable OptionItemsDTO optionItems, @NonNull AbstractConverter.ConverterContext ctx) throws AbstractConverter.ConvertException {
        if (s == null || s.length() <= 0) {
            return null;
        }
        try {
            if (this.calcLength(s) > this.maxLength) {
                throw new AbstractConverter.ConvertException("error.format.int", this.maxLength);
            }
            s = s.replaceAll("'", "").replaceAll("\u2019", "");
            return Long.valueOf(s);
        }
        catch (NumberFormatException nfe) {
            throw new AbstractConverter.ConvertException("error.format.int", this.maxLength);
        }
    }

    @Override
    public @Nullable String getRenderedValue(@Nullable Object o, boolean readonly, @Nullable OptionItemsDTO optionItems, @NonNull AbstractConverter.ConverterContext ctx) {
        return IntConverter.getRenderValue(o, readonly, this.printZeroIfReadonly);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getRenderValue(@Nullable Object o, boolean readonly, boolean printZeroIfReadonly) {
        if (o == null) {
            return "";
        }
        if (o instanceof Number) {
            long value = o instanceof Float || o instanceof Double ? Math.round(((Number)o).doubleValue()) : ((Number)o).longValue();
            if (value == 0L && readonly && !printZeroIfReadonly) {
                return "";
            }
            DecimalFormat decimalFormat = df_int;
            synchronized (decimalFormat) {
                return df_int.format(value);
            }
        }
        return o.toString();
    }

    @Override
    public @NonNull String getUserInputRegExpPattern() {
        return "-?[0-9'\u2019]*\\.?";
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("maxLength", this.maxLength).append("printZeroIfReadonly", this.printZeroIfReadonly).build();
    }
}

