/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.transfer.dto.convert;

import ch.dvbern.tax.common.transfer.dto.OptionItemsDTO;
import ch.dvbern.tax.common.transfer.dto.convert.AbstractConverter;
import java.util.regex.Pattern;
import nl.garvelink.iban.IBAN;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class IBANConverter
extends AbstractConverter<String> {
    private static final Pattern NO_COUNTRY_PTN = Pattern.compile("[0-9]{2}.*");

    public IBANConverter() {
        super(String.class);
    }

    @Override
    public @Nullable String getObject(@Nullable String s, @Nullable OptionItemsDTO optionItems, @NonNull AbstractConverter.ConverterContext ctx) throws AbstractConverter.ConvertException {
        if (s == null || ((String)s).length() <= 0) {
            return null;
        }
        if (NO_COUNTRY_PTN.matcher((CharSequence)(s = ((String)s).replaceAll("\\s", ""))).matches()) {
            s = "CH" + (String)s;
        }
        try {
            IBAN.parse((CharSequence)s);
        }
        catch (IllegalArgumentException e) {
            throw new AbstractConverter.ConvertException("error.false.noIBAN");
        }
        return s;
    }

    @Override
    public @Nullable String getRenderedValue(@Nullable Object o, boolean readonly, @Nullable OptionItemsDTO optionItems, @NonNull AbstractConverter.ConverterContext ctx) {
        if (o == null) {
            return "";
        }
        String str = (String)o;
        try {
            return IBAN.parse((CharSequence)str).toString();
        }
        catch (IllegalArgumentException e) {
            return str;
        }
    }
}

