/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.transfer.dto.convert;

import ch.dvbern.tax.common.transfer.dto.OptionItemsDTO;
import ch.dvbern.tax.common.transfer.dto.convert.AbstractConverter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class AhvNeuConverter
extends AbstractConverter<String> {
    private static final long serialVersionUID = 3618977871490462256L;
    private final Pattern patternValidate = Pattern.compile("(\\d\\d\\d)(\\.?)(\\d\\d\\d\\d)(\\.?)(\\d\\d\\d\\d)(\\.?)(\\d\\d)");
    private final Pattern patternRender = Pattern.compile("(\\d\\d\\d)(\\d\\d\\d\\d)(\\d\\d\\d\\d)(\\d\\d)");

    public AhvNeuConverter() {
        super(String.class);
    }

    @Override
    public @Nullable String getObject(@Nullable String s, @Nullable OptionItemsDTO optionItems, @NonNull AbstractConverter.ConverterContext ctx) throws AbstractConverter.ConvertException {
        if (s == null || s.length() <= 0) {
            return null;
        }
        Matcher m = this.patternValidate.matcher(s);
        if (!m.matches()) {
            throw new AbstractConverter.ConvertException("error.format.ahv.neu");
        }
        return this.getRenderedValue(s, false, optionItems, ctx);
    }

    @Override
    public @Nullable String getRenderedValue(@Nullable Object o, boolean readonly, @Nullable OptionItemsDTO optionItems, @NonNull AbstractConverter.ConverterContext ctx) {
        if (o == null) {
            return "";
        }
        Matcher m = this.patternRender.matcher(o.toString());
        if (m.matches()) {
            return m.group(1) + "." + m.group(2) + "." + m.group(3) + "." + m.group(4);
        }
        return o.toString();
    }

    @Override
    public int getMaxLength() {
        return 16;
    }
}

