/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.transfer.dto;

import ch.dvbern.tax.common.transfer.dto.OptionItemDTO;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class OptionItemsDTO
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final boolean localized;
    private final LinkedHashMap<Object, OptionItemDTO> optionItemsPlain;
    private final Map<String, LinkedHashMap<Object, OptionItemDTO>> optionItemsLocalized;

    protected OptionItemsDTO(boolean localized, LinkedHashMap<Object, OptionItemDTO> optionItemsPlain, Map<String, LinkedHashMap<Object, OptionItemDTO>> optionItemsLocalized) {
        this.localized = localized;
        this.optionItemsPlain = optionItemsPlain;
        this.optionItemsLocalized = optionItemsLocalized;
    }

    public static OptionItemsDTO createLocalized(Map<String, ? extends Map<Object, OptionItemDTO>> optionItems) {
        if (optionItems == null) {
            throw new RuntimeException("optionItems argument must not be null");
        }
        HashMap<String, LinkedHashMap<Object, OptionItemDTO>> options = new HashMap<String, LinkedHashMap<Object, OptionItemDTO>>();
        for (Map.Entry<String, ? extends Map<Object, OptionItemDTO>> entry : optionItems.entrySet()) {
            LinkedHashMap<Object, OptionItemDTO> optionsPerLang = new LinkedHashMap<Object, OptionItemDTO>(entry.getValue());
            options.put(entry.getKey(), optionsPerLang);
        }
        return new OptionItemsDTO(true, null, options);
    }

    public static OptionItemsDTO createPlain(Map<Object, OptionItemDTO> optionItems) {
        if (optionItems == null) {
            throw new RuntimeException("optionItems argument must not be null");
        }
        return new OptionItemsDTO(false, new LinkedHashMap<Object, OptionItemDTO>(optionItems), null);
    }

    public static OptionItemsDTO createEmpty(boolean localized) {
        if (localized) {
            return OptionItemsDTO.createLocalized(new HashMap());
        }
        return OptionItemsDTO.createPlain(new LinkedHashMap<Object, OptionItemDTO>());
    }

    public Set<?> getOptionKeys() {
        if (this.isLocalized()) {
            return this.getOptionItemsForLocale(null).keySet();
        }
        return this.optionItemsPlain.keySet();
    }

    public OptionItemDTO get(Object key) {
        if (this.isLocalized()) {
            return this.getOptionItemsForLocale(null).get(key);
        }
        return this.optionItemsPlain.get(key);
    }

    public @Nullable OptionItemDTO get(@NonNull Object key, Locale locale) {
        if (this.isLocalized()) {
            LinkedHashMap<Object, OptionItemDTO> m = this.getOptionItemsForLocale(locale);
            if (m != null) {
                return (OptionItemDTO)m.get(key);
            }
        } else {
            return this.optionItemsPlain.get(key);
        }
        return null;
    }

    public @NonNull LinkedHashMap<Object, OptionItemDTO> getOptionItemsForLocale(@Nullable Locale locale) {
        String languageCode = locale != null ? locale.getLanguage() : null;
        return this.getOptionItems(languageCode);
    }

    public @NonNull LinkedHashMap<Object, OptionItemDTO> getOptionItems(@Nullable String languageCode) {
        if (this.isLocalized()) {
            LinkedHashMap<Object, OptionItemDTO> result = null;
            if (languageCode == null || languageCode.isEmpty()) {
                Iterator<LinkedHashMap<Object, OptionItemDTO>> iter = this.optionItemsLocalized.values().iterator();
                if (iter.hasNext()) {
                    result = this.optionItemsLocalized.values().iterator().next();
                }
            } else {
                result = this.optionItemsLocalized.get(languageCode);
            }
            if (result != null) {
                return result;
            }
            LinkedHashMap<Object, OptionItemDTO> newLangMap = new LinkedHashMap<Object, OptionItemDTO>();
            this.optionItemsLocalized.put(languageCode, newLangMap);
            return newLangMap;
        }
        return this.optionItemsPlain;
    }

    public boolean isLocalized() {
        return this.localized;
    }

    public @NonNull Set<String> getLanguageCodes() {
        if (this.isLocalized()) {
            return this.optionItemsLocalized.keySet();
        }
        return Collections.emptySet();
    }

    public OptionItemsDTO shallowCopy() {
        LinkedHashMap<Object, OptionItemDTO> plainCopy = null;
        if (this.optionItemsPlain != null) {
            plainCopy = new LinkedHashMap<Object, OptionItemDTO>(this.optionItemsPlain);
        }
        HashMap<String, LinkedHashMap<Object, OptionItemDTO>> localizedCopy = null;
        if (this.optionItemsLocalized != null) {
            localizedCopy = new HashMap<String, LinkedHashMap<Object, OptionItemDTO>>(this.optionItemsLocalized);
        }
        return new OptionItemsDTO(this.localized, plainCopy, localizedCopy);
    }

    public void addOption(Object key, OptionItemDTO option) {
        if (this.isLocalized()) {
            for (String langCode : this.optionItemsLocalized.keySet()) {
                this.optionItemsLocalized.get(langCode).put(key, option);
            }
        } else {
            this.optionItemsPlain.put(key, option);
        }
    }

    public void addOption(String languageCode, Object key, OptionItemDTO option) {
        if (this.isLocalized()) {
            LinkedHashMap<Object, OptionItemDTO> options = this.optionItemsLocalized.get(key);
            if (options == null) {
                options = new LinkedHashMap();
                this.optionItemsLocalized.put(languageCode, options);
            }
            options.put(key, option);
        } else {
            this.optionItemsPlain.put(key, option);
        }
    }
}

