/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.transfer.dto;

import ch.dvbern.tax.common.ejb.util.CDIHelper;
import ch.dvbern.tax.common.transfer.dto.ResourceBundleManager;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class LocalizationHelper {
    private final Locale locale;
    private final ResourceBundleManager resourceBundleManager;
    private static final Map<Locale, LocalizationHelper> locHelperMap = new ConcurrentHashMap<Locale, LocalizationHelper>();

    protected LocalizationHelper(ResourceBundleManager resourceBundleManager, Locale locale) {
        this.locale = locale;
        this.resourceBundleManager = resourceBundleManager;
    }

    public Locale getCurrentLocale() {
        return this.locale;
    }

    public @NonNull String translate(@NonNull String key, Object ... replacementArguments) {
        return this.resourceBundleManager.translate(key, this.locale, replacementArguments);
    }

    public boolean containsKey(@NonNull String key) {
        return this.resourceBundleManager.containsKey(key, this.locale);
    }

    public static LocalizationHelper newInstance(Locale locale) {
        LocalizationHelper lh = locHelperMap.get(locale);
        if (null == lh) {
            lh = new LocalizationHelper(CDIHelper.getResourceBundleManager(), locale);
            locHelperMap.put(locale, lh);
        }
        return lh;
    }

    public static class LocalizationHelperException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public LocalizationHelperException(@NonNull String msg) {
            super(msg);
        }

        public LocalizationHelperException(@NonNull String key, @Nullable Throwable nestedException) {
            super(key, nestedException);
        }
    }
}

