/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.transfer.dto;

import java.io.Serializable;

public class ColorDTO
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final int red;
    private final int green;
    private final int blue;
    private final String hexColor;

    public ColorDTO(int r, int g, int b) {
        this.red = r;
        this.green = g;
        this.blue = b;
        this.hexColor = this.getHexColor();
    }

    public int getRed() {
        return this.red;
    }

    public int getGreen() {
        return this.green;
    }

    public int getBlue() {
        return this.blue;
    }

    public String toString() {
        return this.hexColor;
    }

    private String getHexColor() {
        StringBuffer sb = new StringBuffer(7);
        sb.append('#');
        this.appendColor(sb, this.getRed());
        this.appendColor(sb, this.getGreen());
        this.appendColor(sb, this.getBlue());
        return sb.toString();
    }

    private void appendColor(StringBuffer sb, int color) {
        if (color < 16) {
            sb.append('0');
        }
        sb.append(Integer.toHexString(color).toUpperCase());
    }
}

