/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.common.util;

import ch.dvbern.tax.common.presentation.common.util.CloseUtils;
import ch.dvbern.tax.common.presentation.common.util.TaxFileAttachment;
import ch.dvbern.tax.common.presentation.common.util.TaxFileUtil;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import ch.dvbern.tax.common.transfer.failure.ApplicationException;
import ch.dvbern.tax.common.transfer.failure.InvalidAuthenticationException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.spec.AlgorithmParameterSpec;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaxFile {
    private static final Logger LOG = LoggerFactory.getLogger(TaxFile.class);
    private final Cipher cipher = TaxFileUtil.createCipher();
    private AlgorithmParameterSpec paramSpec;
    private SecretKey secretKey;
    private File file;
    private String password;

    public TaxFile(@NonNull File file, @Nullable String password) {
        this.setFile(file);
        this.setPassword(password);
    }

    public File getFile() {
        return this.file;
    }

    private void setFile(@NonNull File file) {
        if (file == null) {
            throw new IllegalArgumentException("File must not be null");
        }
        this.file = file;
    }

    public void setPassword(@Nullable String pw) {
        if (pw == null) {
            pw = "";
        }
        if (pw.equals(this.password)) {
            return;
        }
        this.secretKey = TaxFileUtil.createSecretKey(pw);
        this.paramSpec = TaxFileUtil.createAlgorithmParamSpec(pw);
        this.password = pw;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Map<String, ModelItemDTO> readModel() throws InvalidAuthenticationException, IOException {
        Map<String, ModelItemDTO> map;
        ZipFile zf = null;
        BufferedInputStream is = null;
        try {
            try {
                zf = new ZipFile(this.file);
                ZipEntry ze = zf.getEntry("dvb-tax-model-12345678909876543210");
                if (ze == null) {
                    throw new ApplicationException("TaxFile contains no model");
                }
                is = new BufferedInputStream(zf.getInputStream(ze));
            }
            catch (IOException ioe) {
                LOG.info("can't open as zip file. trying to open as an old tax file");
                LOG.debug("Exception", (Throwable)ioe);
                is = new BufferedInputStream(new FileInputStream(this.file));
            }
            Cipher cipher = this.cipher;
            synchronized (cipher) {
                map = TaxFileUtil.read(is, this.cipher, this.paramSpec, this.secretKey);
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(is);
            CloseUtils.closeQuietly(zf);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)is);
        CloseUtils.closeQuietly(zf);
        return map;
    }

    public void saveModel(Map<String, ModelItemDTO> dataModel) throws IOException {
        if (dataModel == null) {
            throw new IllegalArgumentException("can't save. dataModel must not be null");
        }
        this.save(null, null, null, dataModel, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TaxFileAttachment> getAttachments() throws IOException {
        if (!this.file.exists() || this.file.length() == 0L) {
            return Collections.emptyList();
        }
        ArrayList<TaxFileAttachment> toReturn = new ArrayList<TaxFileAttachment>();
        ZipFile zf = null;
        try {
            zf = new ZipFile(this.file);
            Enumeration<? extends ZipEntry> entries = zf.entries();
            while (entries.hasMoreElements()) {
                ZipEntry ze = entries.nextElement();
                if ("dvb-tax-model-12345678909876543210".equals(ze.getName())) continue;
                TaxFileAttachment att = new TaxFileAttachment(ze.getName(), ze.getComment(), ze.getSize(), this);
                toReturn.add(att);
            }
        }
        catch (IOException ioe) {
            try {
                LOG.info("can't open as zip file. trying to open as an old tax file");
                LOG.debug("Exception", (Throwable)ioe);
            }
            catch (Throwable throwable) {
                CloseUtils.closeQuietly(zf);
                throw throwable;
            }
            CloseUtils.closeQuietly(zf);
        }
        CloseUtils.closeQuietly(zf);
        Collections.sort(toReturn);
        return toReturn;
    }

    public File getAttachmentFile(TaxFileAttachment attachment) throws IOException {
        if (attachment == null) {
            throw new NullPointerException("attachment may not be null");
        }
        return this.getAttachmentFile(attachment.getFileName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File getAttachmentFile(String fileName) throws IOException {
        ZipEntry ze;
        File tmp;
        ZipFile zf;
        BufferedInputStream is;
        block4: {
            File file;
            if (fileName == null) {
                throw new NullPointerException("fileName may not be null");
            }
            is = null;
            zf = null;
            tmp = null;
            try {
                zf = new ZipFile(this.file);
                ze = zf.getEntry(fileName);
                if (ze != null) break block4;
                file = null;
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(is);
                CloseUtils.closeQuietly(zf);
                throw throwable;
            }
            IOUtils.closeQuietly(is);
            CloseUtils.closeQuietly(zf);
            return file;
        }
        String name = ze.getName();
        int pos = name.lastIndexOf(46);
        tmp = pos > 0 ? File.createTempFile(name.substring(0, pos), name.substring(pos)) : File.createTempFile(name, null);
        tmp.deleteOnExit();
        is = new BufferedInputStream(zf.getInputStream(ze));
        FileUtils.copyInputStreamToFile((InputStream)is, (File)tmp);
        File file = tmp;
        IOUtils.closeQuietly((InputStream)is);
        CloseUtils.closeQuietly(zf);
        return file;
    }

    public void putAttachmentFile(File file, String comment) throws IOException {
        if (file == null) {
            throw new NullPointerException("file may not be null");
        }
        if ("dvb-tax-model-12345678909876543210".equals(file.getName())) {
            throw new IllegalArgumentException("invalid file name:" + file.getName());
        }
        this.save(null, file, comment, null, null);
    }

    public void removeAttachment(TaxFileAttachment attachment) throws IOException {
        if (attachment == null) {
            throw new NullPointerException("attachment may not be null");
        }
        this.removeAttachment(attachment.getFileName());
    }

    public void removeAttachment(String fileName) throws IOException {
        if (fileName == null) {
            throw new NullPointerException("fileName may not be null");
        }
        this.save(fileName, null, null, null, null);
    }

    public void setComment(String fileName, String comment) throws IOException {
        if (fileName == null) {
            throw new NullPointerException("fileName may not be null");
        }
        this.save(null, null, comment, null, fileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void save(String toRemove, File toAdd, String comment, Map<String, ModelItemDTO> newModel, String fileForCommentUpdate) throws IOException {
        ZipOutputStream os = null;
        ZipFile zf = null;
        File tmp = null;
        try {
            ZipEntry ze;
            if (!this.getAttachments().isEmpty() || toAdd != null || toRemove != null) {
                tmp = File.createTempFile(this.file.getName(), ".tmp");
            }
            os = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(tmp == null ? this.file : tmp)));
            if (newModel != null) {
                ze = new ZipEntry("dvb-tax-model-12345678909876543210");
                os.putNextEntry(ze);
                TaxFileUtil.write(os, newModel, this.cipher, this.paramSpec, this.secretKey);
                os.closeEntry();
            }
            if (toAdd != null) {
                ze = new ZipEntry(toAdd.getName());
                ze.setSize(toAdd.length());
                if (comment != null) {
                    ze.setComment(comment);
                }
                os.putNextEntry(ze);
                FileUtils.copyFile((File)toAdd, (OutputStream)os);
                os.closeEntry();
            }
            if (tmp != null && this.file.exists() && this.file.length() > 0L) {
                try {
                    zf = new ZipFile(this.file);
                }
                catch (ZipException ze2) {
                    LOG.info("can't open the current tax file as a zip file. probably an old tax file.");
                    LOG.debug("exception", (Throwable)ze2);
                }
            }
            if (zf != null) {
                Enumeration<? extends ZipEntry> entries = zf.entries();
                while (entries.hasMoreElements()) {
                    String toAddName;
                    ZipEntry ze3 = entries.nextElement();
                    String string = toAddName = toAdd == null ? null : toAdd.getName();
                    if (ze3.getName().equals(toRemove) || ze3.getName().equals(toAddName) || ze3.getName().equals("dvb-tax-model-12345678909876543210") && newModel != null) continue;
                    if (ze3.getName().equals(fileForCommentUpdate)) {
                        ze3.setComment(comment);
                    }
                    os.putNextEntry(ze3);
                    try (InputStream is = zf.getInputStream(ze3);){
                        IOUtils.copy((InputStream)is, (OutputStream)os);
                    }
                    os.closeEntry();
                }
            }
            CloseUtils.closeQuietly(zf);
            os.close();
            if (tmp != null) {
                FileUtils.copyFile((File)tmp, (File)this.file);
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(os);
            CloseUtils.closeQuietly(zf);
            FileUtils.deleteQuietly(tmp);
            throw throwable;
        }
        IOUtils.closeQuietly((OutputStream)os);
        CloseUtils.closeQuietly(zf);
        FileUtils.deleteQuietly((File)tmp);
    }
}

