/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.common.util;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class Render
implements Serializable,
Comparable<Render>,
Cloneable,
Iterable<String> {
    private static final long serialVersionUID = 1L;
    static final String ALL_KEY = "all";
    public static final Render ALL = new Render("all");
    private final @NonNull Set<String> render;
    private final @NonNull String asString;

    private static String refreshString(Set<String> render) {
        return StringUtils.join(render, (String)",");
    }

    public Render() {
        this.render = Collections.unmodifiableSet(new LinkedHashSet());
        this.asString = Render.refreshString(this.render);
    }

    public Render(Render other) {
        LinkedHashSet container = other == null ? new LinkedHashSet() : new LinkedHashSet<String>(other.render);
        this.render = Collections.unmodifiableSet(container);
        this.asString = Render.refreshString(this.render);
    }

    Render(@NonNull Set<String> dataSet) {
        LinkedHashSet<String> data = dataSet == null ? new LinkedHashSet<String>() : new LinkedHashSet(dataSet.size());
        data.addAll(dataSet);
        this.render = Collections.unmodifiableSet(data);
        this.asString = Render.refreshString(this.render);
    }

    Render(String ... elements) {
        if (elements == null) {
            this.render = new LinkedHashSet<String>();
        } else {
            LinkedHashSet<String> data = new LinkedHashSet<String>(elements.length);
            data.addAll(Arrays.asList(elements));
            this.render = Collections.unmodifiableSet(data);
        }
        this.asString = Render.refreshString(this.render);
    }

    public @NonNull String toString() {
        return this.asString;
    }

    public boolean isRenderAll() {
        return this.render.contains(ALL_KEY);
    }

    public static boolean isRenderAll(Render render) {
        return render != null && render.isRenderAll();
    }

    public boolean isRenderSelf() {
        return this.render.isEmpty();
    }

    public static boolean isRenderSelf(Render render) {
        return render == null || render.isRenderSelf();
    }

    public @NonNull Set<String> asUnmodifiableSet() {
        return this.render;
    }

    @Override
    public @NonNull Iterator<String> iterator() {
        return this.render.iterator();
    }

    @Override
    public int compareTo(@NonNull Render other) {
        return this.toString().compareTo(other.toString());
    }

    public int hashCode() {
        return this.render.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (!(other instanceof Render)) {
            return false;
        }
        return this.render.equals(((Render)other).render);
    }

    public int size() {
        return this.render.size();
    }

    protected @NonNull Render clone() throws CloneNotSupportedException {
        super.clone();
        return new Render(this.render);
    }

    public boolean isEmpty() {
        return this.render.isEmpty();
    }

    public boolean contains(@Nullable Object o) {
        if (o == null) {
            return false;
        }
        if (o instanceof Render) {
            return this.render.containsAll(((Render)o).render);
        }
        return this.render.contains(o);
    }

    public @NonNull Object[] toArray() {
        return this.render.toArray();
    }

    public <T> @NonNull T[] toArray(T[] a) {
        return this.render.toArray(a);
    }

    public boolean containsAll(@Nullable Collection<?> c) {
        if (c == null) {
            return false;
        }
        return this.render.containsAll(c);
    }
}

