/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.common.util;

import java.util.Map;

public class HelpMapping {
    public static final String DEFAULT_PATH = "kurzhilfeDefault.html";
    private static final char SEP = '.';
    private final boolean fallbackOnParent;
    private final String defaultPath;
    protected final Map<? super String, ? super String> mapping;

    protected HelpMapping(Map<? super String, ? super String> mapping) {
        this(mapping, false, DEFAULT_PATH);
    }

    protected HelpMapping(Map<? super String, ? super String> mapping, boolean fallbackOnParent, String defaultPath) {
        if (mapping == null) {
            throw new NullPointerException("Mappings cannot be null");
        }
        this.mapping = mapping;
        this.fallbackOnParent = fallbackOnParent;
        this.defaultPath = defaultPath;
    }

    public boolean contains(String key) {
        if (key == null) {
            throw new NullPointerException("Key cannot be null");
        }
        return this.mapping.containsKey(key);
    }

    public String get(String key) {
        if (key == null) {
            throw new NullPointerException("Key cannot be null");
        }
        return this.mapping.get(key);
    }

    public String resolve(String key) {
        if (key == null) {
            throw new NullPointerException("Key cannot be null");
        }
        String path = this.mapping.get(key);
        if (path == null) {
            int lastSep;
            if (this.fallbackOnParent && (lastSep = key.lastIndexOf(46)) != -1) {
                return this.resolve(key.substring(0, lastSep));
            }
            path = this.defaultPath;
        }
        return path;
    }

    public static HelpMapping wrap(Map<? super String, ? super String> mapping, boolean fallbackOnParent) {
        return HelpMapping.wrap(mapping, fallbackOnParent, DEFAULT_PATH);
    }

    public static HelpMapping wrap(Map<? super String, ? super String> mapping, boolean fallbackOnParent, String defaultPath) {
        return new HelpMapping(mapping, fallbackOnParent, defaultPath);
    }
}

