/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.common.util;

import ch.dvbern.tax.common.presentation.bd.DvbTaxSession;
import ch.dvbern.tax.common.transfer.failure.ApplicationException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Iterator;
import java.util.ServiceLoader;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;

public final class ActionHelper {
    public static final long TMO_SESSION_LOCK_TIMEOUT = 5000L;

    private ActionHelper() {
    }

    private static <Instance> Instance loadService(Class<Instance> interfaceClass) {
        ServiceLoader<Instance> services = ServiceLoader.load(interfaceClass);
        Iterator<Instance> iter = services.iterator();
        if (iter.hasNext()) {
            return iter.next();
        }
        throw new ApplicationException("Could not find Implementation of " + interfaceClass.getName() + ". Please create META-INF/services/" + interfaceClass.getName() + " and put the implementation class name in.");
    }

    public static DvbTaxSession createTmoSession() {
        DvbTaxSession session = ActionHelper.loadService(DvbTaxSession.class);
        MutexInvocationHandler ih = new MutexInvocationHandler(session, 5000L);
        DvbTaxSession proxy = (DvbTaxSession)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{DvbTaxSession.class}, (InvocationHandler)ih);
        return proxy;
    }

    private static class MutexInvocationHandler
    implements InvocationHandler,
    Serializable {
        private static final long serialVersionUID = 1L;
        private transient Semaphore mutex = new Semaphore(1);
        private final Object target;
        private final long lockTimeoutMsec;

        public MutexInvocationHandler(Object target, long lockTimeoutMsec) {
            this.target = target;
            this.lockTimeoutMsec = lockTimeoutMsec;
        }

        @Override
        public Object invoke(Object obj, Method m, Object[] args) throws Throwable {
            if (!this.mutex.tryAcquire(this.lockTimeoutMsec, TimeUnit.MILLISECONDS)) {
                throw new ApplicationException("object in use. wait time expired");
            }
            try {
                Object object = m.invoke(this.target, args);
                return object;
            }
            catch (Exception t) {
                if (t instanceof InvocationTargetException) {
                    InvocationTargetException ite = (InvocationTargetException)t;
                    throw ite.getTargetException();
                }
                throw t;
            }
            finally {
                this.mutex.release();
            }
        }

        private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
            s.defaultReadObject();
            this.mutex = new Semaphore(1);
        }
    }
}

