/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.common.print.pdf.printer.pdfform.resolvers;

import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PdfKey
implements Serializable {
    public static final String MODEL_SCHEME = "model";
    public static final int NOT_A_ROW = 0;
    private static final long serialVersionUID = 3408625917118445832L;
    private static final Logger LOG = LoggerFactory.getLogger(PdfKey.class);
    private static final char SCHEME_SEPARATOR_CHAR = ':';
    private static final Pattern ROWNUM_FRAGMENT_EXTRACTOR = Pattern.compile("^(.*)\\.(\\d+)$");
    private final @NonNull URI uri;
    private final @Nullable String sourceString;
    private final int pdfRow;

    public PdfKey(@NonNull URI uri) {
        this(uri, null);
    }

    public PdfKey(@NonNull URI uri, @Nullable String sourceString) {
        this.uri = Objects.requireNonNull(uri);
        this.pdfRow = this.parseFragmentAsRowNum(uri);
        this.sourceString = sourceString;
    }

    public static @NonNull PdfKey parseSimpleUri(@NonNull String simpleUri) {
        Objects.requireNonNull(simpleUri);
        String cleanUri = simpleUri.replaceAll("(_\\d+)*$", "");
        if (!cleanUri.equals(simpleUri)) {
            LOG.warn("Naming bug: {}", (Object)simpleUri);
        }
        URI uri = null;
        try {
            int schemeSeparatorIdx = cleanUri.indexOf(58);
            if (schemeSeparatorIdx == -1) {
                uri = URI.create("model:/" + cleanUri);
            } else {
                String scheme = cleanUri.substring(0, schemeSeparatorIdx);
                String path = cleanUri.substring(schemeSeparatorIdx + 1);
                uri = URI.create(scheme + ":/" + path);
            }
        }
        catch (IllegalArgumentException ignored) {
            throw new IllegalArgumentException("invalid syntax: " + simpleUri);
        }
        Matcher matcher = ROWNUM_FRAGMENT_EXTRACTOR.matcher(uri.getPath());
        if (matcher.matches()) {
            String pathWithoutRownum = matcher.group(1);
            String rowNumText = matcher.group(2);
            try {
                int rowNum = Integer.parseInt(rowNumText);
                assert (rowNum > 0);
                uri = URI.create(PdfKey.buildUriString(uri.getScheme(), pathWithoutRownum, uri.getQuery(), rowNum));
            }
            catch (Exception nfe) {
                throw new IllegalArgumentException("Not a valid row number in fragment: " + simpleUri, nfe);
            }
        }
        return new PdfKey(uri, simpleUri);
    }

    private static @NonNull String buildUriString(@NonNull String scheme, @NonNull String path, @Nullable String resolverArgs, @Nullable Integer rowNum) {
        String uriString = scheme + ":" + path + (String)(resolverArgs == null ? "" : "?" + resolverArgs) + "#" + rowNum;
        return uriString;
    }

    private int parseFragmentAsRowNum(@NonNull URI uri) {
        String fragment = uri.getFragment();
        if (fragment == null) {
            return 0;
        }
        return Integer.parseInt(fragment);
    }

    public @NonNull URI getUri() {
        return this.uri;
    }

    public int getPdfRow() {
        return this.pdfRow;
    }

    public boolean isTableKey() {
        return this.pdfRow != 0;
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append((Object)this.uri).append(this.getPdfRow()).append((Object)this.sourceString).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PdfKey pdfKey1 = (PdfKey)o;
        return new EqualsBuilder().append((Object)this.uri, (Object)pdfKey1.uri).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.uri).toHashCode();
    }

    public @NonNull String getScheme() {
        return this.uri.getScheme();
    }

    public @NonNull String getPath() {
        return this.uri.getPath().startsWith("/") ? this.uri.getPath().substring(1) : this.uri.getPath();
    }

    public @Nullable String getResolverArgs() {
        return this.uri.getQuery();
    }

    public @NonNull PdfKey withScheme(@NonNull String scheme) {
        URI newUri = null;
        try {
            newUri = new URI(scheme, this.uri.getUserInfo(), this.uri.getHost(), this.uri.getPort(), this.uri.getPath(), this.uri.getQuery(), this.uri.getFragment());
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Could not change scheme: " + scheme + " in uri " + String.valueOf(this.uri), e);
        }
        return new PdfKey(newUri);
    }
}

