/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.common.print.pdf.printer.pdfform.resolvers;

import ch.dvbern.tax.common.presentation.common.print.pdf.printer.pdfform.PdfForm;
import ch.dvbern.tax.common.presentation.common.print.pdf.printer.pdfform.RunContext;
import ch.dvbern.tax.common.presentation.common.print.pdf.printer.pdfform.TableRow;
import ch.dvbern.tax.common.presentation.common.print.pdf.printer.pdfform.resolvers.DataModelDelegateResolver;
import ch.dvbern.tax.common.presentation.common.print.pdf.printer.pdfform.resolvers.DataModelResolver;
import ch.dvbern.tax.common.presentation.common.print.pdf.printer.pdfform.resolvers.PdfKey;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class CheckboxResolver
extends DataModelDelegateResolver {
    private final Boolean condition;
    private final String markerMatch;
    private final String markerMismatch;

    private CheckboxResolver(@NonNull String scheme, boolean condition, @NonNull String markerMatch, @NonNull String markerMismatch) {
        super(scheme, new DataModelResolver(DataModelResolver.Localization.RAW_VALUE));
        this.condition = condition;
        this.markerMatch = Objects.requireNonNull(markerMatch);
        this.markerMismatch = Objects.requireNonNull(markerMismatch);
    }

    @Override
    public @Nullable Object resolve(@NonNull PdfKey pdfKey, @Nullable TableRow tableRow, @NonNull PdfForm page, @NonNull RunContext ctx) {
        Object value = this.dataModelResolve(pdfKey, tableRow, page, ctx);
        if (this.condition.equals(value)) {
            return this.markerMatch;
        }
        return this.markerMismatch;
    }

    public static class CheckboxFalseResolver
    extends CheckboxResolver {
        public CheckboxFalseResolver(@NonNull String scheme, @NonNull String markerMatch, @NonNull String markerMismatch) {
            super(scheme, false, markerMatch, markerMismatch);
        }

        public CheckboxFalseResolver() {
            this("bool-false", "X", "");
        }
    }

    public static class CheckboxTrueResolver
    extends CheckboxResolver {
        public CheckboxTrueResolver(@NonNull String scheme, @NonNull String markerMatch, @NonNull String markerMismatch) {
            super(scheme, true, markerMatch, markerMismatch);
        }

        public CheckboxTrueResolver() {
            this("bool-true", "X", "");
        }
    }
}

